/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.refactoring.ui.j.ui;

import java.beans.BeanInfo;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.*;
import org.netbeans.modules.xml.refactoring.Usage;
import org.netbeans.modules.xml.refactoring.ui.j.api.RefactoringElement;
import org.netbeans.modules.xml.refactoring.ui.util.AnalysisUtilities;
import org.openide.nodes.Node;
import org.openide.text.PositionBounds;

/**
 * @author Pavel Flaska
 */
public class CheckNode extends DefaultMutableTreeNode {
    public static final long serialVersionUID = 1L;
    
    public final static int SINGLE_SELECTION = 0;
    public final static int DIG_IN_SELECTION = 4;
    
    private int selectionMode;
    private boolean isSelected = true;
    
    private String nodeLabel;
    private Icon icon;
    
    private boolean disabled = false;
    private boolean checkEnabled = true;
    private boolean needsRefresh = false;
    
    private PositionBounds bounds = null;
    private String resourceName;
    
    private Node origNode;
    
    /**
     * @param userObject usage path element, could be either Model or Component
     * @param node original node for the userObject
     */
    public CheckNode(Object userObject, Node node) {
        super(userObject, true);
        this.origNode = node;
        nodeLabel = node.getDisplayName();
        icon = new ImageIcon(node.getIcon(BeanInfo.ICON_COLOR_16x16));
        if (userObject instanceof Usage) {
            isSelected = ((Usage)userObject).isIncludedInRefactoring();
        }
        setSelectionMode(DIG_IN_SELECTION);
    }

    public CheckNode(String label, ImageIcon icon) {
        super(new Object(), true);
        this.nodeLabel = label;
        this.icon = icon;
    }
    
    String getLabel() {
        return nodeLabel;
    }
    
    public void  setLabel(String nodeLabel) {
        this.nodeLabel = nodeLabel;
    }
    
    Icon getIcon() {
        return icon;
    }
    
    
    
    public void setDisabled() {
        disabled = true;
        isSelected = false;
        removeAllChildren();
    }
    
    boolean isDisabled() {
        return disabled;
    }
    
    public void setCheckEnabled(boolean enabled) {
        checkEnabled = enabled;
    }
    
    
    public boolean getCheckEnabled() {
        return checkEnabled;
    }
    
    void setNeedsRefresh() {
        needsRefresh = true;
        setDisabled();
    }
    
    boolean needsRefresh() {
        return needsRefresh;
    }
    
    public void setSelectionMode(int mode) {
        selectionMode = mode;
    }
    
    public int getSelectionMode() {
        return selectionMode;
    }
    
    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        if ((selectionMode == DIG_IN_SELECTION) && (children != null)) {
            Enumeration e = children.elements();
            while (e.hasMoreElements()) {
                CheckNode node = (CheckNode)e.nextElement();
                node.setSelected(isSelected);
            }
        }
        
        if (userObject instanceof Usage && isLeaf()){
            ((Usage)userObject).setIncludedInRefactoring(isSelected);
        }
    }
    
    public boolean isSelected() {
        if (userObject instanceof RefactoringElement) {
            return ((RefactoringElement) userObject).isEnabled() &&
                    !((((RefactoringElement) userObject).getStatus() == RefactoringElement.GUARDED) || (((RefactoringElement) userObject).getStatus() == RefactoringElement.READ_ONLY));
        } else {
            return isSelected;
        }
    }
    
    public PositionBounds getPosition() {
        if (userObject instanceof RefactoringElement)
            return ((RefactoringElement) userObject).getPosition();
        return null;
    }
    
    private String tooltip;
    public String getToolTip() {
        if (tooltip==null) {
//            if ((resourceName != null) && (userObject instanceof RefactoringElement)) {
//                RefactoringElement ree = (RefactoringElement) userObject;
//                PositionBounds bounds = getPosition();
//                if (bounds != null) {
//                    int line;
//                    try {
//                        line = bounds.getBegin().getLine() + 1;
//                    } catch (IOException ioe) {
//                        return null;
//                    }
//                    tooltip = resourceName + ':' + line;
//                }
//            }
//            if (schemaComponent != null){
//                // TODO schema file:line number  myFolder/mySchema.xsd:42
//            }
            return null;
        }
        return tooltip;
    }
    
//lativ begin
    public Node getOrigNode() {
        return origNode;
    }
//lativ end
    
}
