/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.refactoring.ui.j.spi.ui;

import java.text.MessageFormat;
import org.netbeans.modules.xml.nbprefuse.View;
import org.netbeans.modules.xml.refactoring.DeleteRequest;
import org.netbeans.modules.xml.refactoring.RefactorRequest;
import org.netbeans.modules.xml.refactoring.ui.j.api.AbstractRefactoring;
import org.netbeans.modules.xml.refactoring.ui.j.api.Problem;
import org.netbeans.modules.xml.refactoring.ui.j.api.WhereUsedQuery;
import org.netbeans.modules.xml.refactoring.ui.j.ui.RefactoringPanel;
import org.netbeans.modules.xml.refactoring.ui.j.ui.SafeDeletePanel;
import org.netbeans.modules.xml.refactoring.ui.views.WhereUsedView;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/**
 *
 * @author Jeri Lockhart
 */
public class DeleteRefactoringUI implements RefactoringUI{
    
    private WhereUsedQuery query;
    private WhereUsedView view;
    private DeleteRequest deleteRequest;
    private CustomRefactoringPanel panel;
    
    /** Creates a new instance of WhereUsedQueryUI */
    public DeleteRefactoringUI(WhereUsedView view, DeleteRequest request) {
        this.view = view;
        deleteRequest = request;
        query = new WhereUsedQuery(request.getTarget());
    }
    
    public DeleteRefactoringUI(WhereUsedView view, NamedReferenceable target) {
        this(view, new DeleteRequest(target));
    }

    ////////////////////////////////////////////////////////////////////////////
    /**  Start Implementation of RefactoringUI
     */
    ////////////////////////////////////////////////////////////////////////////
    /**
     * Returns refactoring-specific panel containing input fields for 
     * refactoring parameters. This method is called by ParametersPanel
     * which is responsible for displaying refactoring parameters dialog.
     * Name of the panel returned from this method will be used as the dialog
     * name. This panel can use setPreviewEnabled method of the passed
     * ParametersPanel to enable/disable Preview button of the refactoring
     * parameters dialog.
     * 
     * @param parent ParametersPanel that the returned panel will be displayed in.
     * @return Refactoring-specific parameters panel.
     */
    public CustomRefactoringPanel getPanel(ParametersPanel parent) {
         
        
        if(panel == null)
            panel = new SafeDeletePanel(getTarget());
        return panel;
    }

    /**
     * Implementation of this method should set the refactoring parameters entered
     * by user into the refactoring-specific parameters panel (returned from getPanel
     * method) into the underlying refactoring object.
     * 
     * @return Chain of problems returned from the underlying refactoring object
     * when trying to set its parameters.
     */
    public Problem setParameters() {
        return null;
    }

    /**
     * Indicates whether this class represents a real refactoring that changes
     * code or whether it is just a query (e.g. all usages for a class).
     * 
     * @return <code>true</code> if the class represents only a query,
     * <code>false</code> if the class represents a real refactoring.
     */
    public boolean isQuery() {
        return false;
    }

    public boolean hasParameters() {
        return false;
    }

    /**
     * Returns underlying refactoring object.
     * 
     * @return Underlying refactoring object.
     */
    public AbstractRefactoring getRefactoring() {
        return query;
    }


    public HelpCtx getHelpCtx() {
        return new HelpCtx(DeleteRefactoringUI.class);
    }

    /**
     * Returns description of the refactoring.
     * 
     * @return Refactoring description.
     */
    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage(RefactoringPanel.class, "LBL_Delete")).format (
                    new Object[] {getTarget().getName() } 
                );
        
    }

    public Problem checkParameters() {
        return null;
    }
    
    
    public View getView() {
       return view;    
    }
    
    public void setView(View view){
        
        this.view = WhereUsedView.class.cast(view);
    }
    
    
    /**
     * 
     * 
     * @returns RefactorRequest
     */
    public RefactorRequest getRefactorRequest() {
        return deleteRequest;
        
    }
    
    
    /**
     * Returns name of the refactoring.
     * 
     * @return Refactoring name.
     */
    public String getName() {
        return new MessageFormat(NbBundle.getMessage(RefactoringPanel.class, "LBL_Delete")).format (
                    new Object[] {getTarget().getName()}
                );
    }
    
    ////////////////////////////////////////////////////////////////////////////
    /**  End Implementation of RefactoringUI
     */
    ////////////////////////////////////////////////////////////////////////////
   
    public NamedReferenceable getTarget() {
        return deleteRequest.getTarget();
    }
}
