/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.refactoring.ui.j.spi.ui;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
//import org.netbeans.jmi.javamodel.Element;
//import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
//import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
//import org.netbeans.modules.refactoring.ui.RefactoringPanel;
//import org.netbeans.api.mdr.MDRepository;
//import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

/** Generic superclass for refactoring actions.
 * Subclasses should implement createRefactoringUI and enabled methods.
 * 
 * @author Martin Matula
 */
public abstract class AbstractRefactoringAction extends NodeAction implements RefactoringAction, Runnable {
    private Node[] activatedNodes;
    private int caretPosition;
    private int startSelectionPosition;
    private int endSelectionPosition;
    private static DelegateTextAction delegate = new DelegateTextAction();

    /** Creates a new instance of AbstractRefactoringAction */
    public AbstractRefactoringAction(String name, Icon icon) {
        setName(name);
        setIcon(icon);
    }
    
    public final String getName() {
        return (String) getValue(Action.NAME);
    }
    
    protected void setName(String name) {
        putValue(Action.NAME, name);
    }
    
    protected void setMnemonic(char m) {
        putValue(Action.MNEMONIC_KEY, new Integer(m));
    }
    
    public final void performAction(final Node[] n) {
        new Runnable() {
            public void run() {
                processContext(n, delegate.getTextComponent());
                AbstractRefactoringAction.this.run();
            }
        };
//        JavaMetamodel.getManager().invokeAfterScanFinished(r, trim(getName()));
    }
    
    private boolean invokedExternally = false;
//    public void actionPerformed(final ActionEvent ev) {
////        if (ev == RefactoringActionsFactory.DEFAULT_EVENT) {
////            invokedExternally = true;
////        }
////        AbstractRefactoringAction.super.actionPerformed(ev);
////        if (ev == RefactoringActionsFactory.DEFAULT_EVENT) {
////            invokedExternally = false;
////        }
//    }
    
    private static String trim(String arg) {
        arg = org.openide.util.Utilities.replaceString(arg, "&", ""); // NOI18N
        return org.openide.util.Utilities.replaceString(arg, "...", ""); // NOI18N
    }
    
    protected abstract boolean enabled(Node[] activatedNodes);
    
    /** Should be implemented by subclasses to provide instance of RefactoringUI
     * implementation for the implemented refactoring. The method should initialize
     * the RefactoringUI implementation with the provided array of nodes and textComponent.
     * @param nodes Array of activated nodes that the refactoring should be performed
     * on.
     * @param selectedElement org.netbeans.jmi.javamodel.Element at cursor position if the action is invoked in editor or <code>null</code>.
     * @return Implementation of RefactoringUI for the refactoring this action is
     * supposed to invoke.
     */
//    protected abstract RefactoringUI createRefactoringUI(Node[] nodes, Element selectedElement);

//    protected RefactoringUI createRefactoringUI(Element selectedElement,int startOffset,int endOffset) {
//        return createRefactoringUI(activatedNodes, selectedElement);
//    }
    
    public final void processContext(Node[] activatedNodes, JTextComponent textComponent) {
        this.activatedNodes = activatedNodes;

        setCaretPosition(textComponent);
        boolean e = enabled(activatedNodes);
        //if (e != isEnabled()) {
            setEnabled(e);
        //}
    }
    
    private void setCaretPosition(JTextComponent textComponent) {
        caretPosition = -1;
        if (activatedNodes == null || textComponent == null || invokedExternally)
            return;
        // #56228: need to get EditorCookie from DataObject rather than directly
        DataObject dobj = (DataObject) activatedNodes[0].getCookie(DataObject.class);
        if (dobj != null) {
            EditorCookie ec = (EditorCookie) dobj.getCookie(EditorCookie.class);
            if (ec != null) {
                TopComponent activetc = TopComponent.getRegistry().getActivated();
                if (activetc instanceof CloneableEditorSupport.Pane) {
                    JEditorPane pane=((CloneableEditorSupport.Pane)activetc).getEditorPane();

                    if (textComponent.equals(pane)) {
                        caretPosition = textComponent.getCaretPosition();
                        startSelectionPosition = textComponent.getSelectionStart();
                        endSelectionPosition = textComponent.getSelectionEnd();
                        
                        //fix of issue 62849
                        if (startSelectionPosition != endSelectionPosition && endSelectionPosition == caretPosition) {
                            caretPosition--;
                        }
                    }
                }
            }
        }
    }

    public final void run() {
//        Element selectedElement=null;
//        MDRepository rep = JavaModel.getJavaRepository();
//        RefactoringUI ui = null;
//        
//        rep.beginTrans(true);
//        try {
////            JavaMetamodel.getManager().setClassPath(
////              ClassPathFactory.createClassPath(RefactoringClassPathImplementation.getDefault())
////            );
//            if (caretPosition != -1) {
//                FileObject fo;
//                DataObject dobj = (DataObject)activatedNodes[0].getCookie(DataObject.class);
//                while (dobj instanceof DataShadow) {
//                    dobj = ((DataShadow) dobj).getOriginal();
//                }
//                fo=dobj.getPrimaryFile();
//                JavaModel.setClassPath(fo);
//                selectedElement = JavaMetamodel.getManager().getElementByOffset(fo,caretPosition);
//                if (selectedElement !=null && startSelectionPosition != endSelectionPosition) {
//                    Element startElement,endElement;
//                   
//                    ui = createRefactoringUI(selectedElement, startSelectionPosition, endSelectionPosition);
//                }
//            }
//            if (ui == null) {
//                ui = createRefactoringUI(activatedNodes, selectedElement);
//            }
//        } finally {
//            rep.endTrans();
//        }
//        TopComponent activetc = TopComponent.getRegistry().getActivated();
//        if (activetc instanceof CloneableEditorSupport.Pane) {
//            new RefactoringPanel(ui, activetc);
//        } else {
//            new RefactoringPanel(ui);    
//        }    
    }
    
    public boolean enable(Node[]a) {
        return enabled(a);
    }
    
    public org.openide.util.HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (PROP_ENABLED.equals(name)) {
            if (newValue != null) {
                super.firePropertyChange(name, oldValue, newValue);
            }
        } else {
            super.firePropertyChange(name, oldValue, newValue);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

//    public void performAction() {
//        super.performAction();
//    }
    
    private static final class DelegateTextAction extends TextAction {
    public static final long serialVersionUID = 1L;
        
        public DelegateTextAction() {
            super("");
        }
        
        public void actionPerformed(ActionEvent a) {
        }
        
        public JTextComponent getTextComponent() {
            return getFocusedComponent();
        }
    };

}
