/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.refactoring.ui.j.api;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

//import org.netbeans.api.mdr.MDRepository;
//import org.netbeans.modules.javacore.api.JavaModel;
//import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
//import org.netbeans.modules.refactoring.ProgressSupport;
//import org.netbeans.modules.refactoring.SPIAccessor;
//import org.netbeans.modules.refactoring.classpath.RefactoringClassPathImplementation;
//import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
//import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;


/** Singleton class used to invoke refactorings.
 *
 * @author Martin Matula, Daniel Prusa
 */
public final class RefactoringSession {
//public final class RefactoringSession {
    private final LinkedList internalList;
//    private final RefactoringElementsBag bag;
    private final Collection refactoringElements;
    private final String description;
//    private ProgressSupport progressSupport;
    
    private RefactoringSession(String description) {
        internalList = new LinkedList();
//        bag = SPIAccessor.DEFAULT.createBag(this, internalList);
        this.description = description;
        this.refactoringElements = new ElementsCollection();
    }
    
    /** Creates a new refactoring session.
     */
    public static RefactoringSession create(String description) {
        return new RefactoringSession(description);
    }

    public Problem doRefactoring(boolean saveAfterDone) {
//        Iterator it = internalList.iterator();
//        fireProgressListenerStart(0, internalList.size()+1);
//        try {
//            MDRepository repository = JavaModel.getJavaRepository();
//            boolean fail = true;
//            repository.beginTrans(true);
//            JavaMetamodel.getUndoManager().setUndoDescription(description);
//            try {
//                JavaModel.setClassPath(RefactoringClassPathImplementation.getDefault());
//                while (it.hasNext()) {
//                    fireProgressListenerStep();
//                    RefactoringElementImplementation element = (RefactoringElementImplementation) it.next();
//                    if (element.isEnabled() && !((element.getStatus() == RefactoringElement.GUARDED) || (element.getStatus() == RefactoringElement.READ_ONLY))) {
//                        element.performChange();
//                    }
//                }
//                fail = false;
//            } finally {
//                repository.endTrans(fail);
//            }
//            if (saveAfterDone) {
//                JavaMetamodel.getUndoManager().saveAll();
//            }
//            fireProgressListenerStep();
//        } finally {
//            fireProgressListenerStop();
//        }
        return null;
    }
    
    public Collection getRefactoringElements() {
        return refactoringElements;
    }
    
    public synchronized void addProgressListener(ProgressListener listener) {
//        if (progressSupport == null ) {
//            progressSupport = new ProgressSupport();
//        }
//        progressSupport.addProgressListener(listener);
    }

    public synchronized void removeProgressListener(ProgressListener listener) {
//        if (progressSupport != null ) {
//            progressSupport.removeProgressListener(listener); 
//        }
    }

//    RefactoringElementsBag getElementsBag() {
//        return bag;
//    }

    private void fireProgressListenerStart(int type, int count) {
//        if (progressSupport != null) {
//            progressSupport.fireProgressListenerStart(this, type, count);
//        }
    }

    private void fireProgressListenerStep() {
//        if (progressSupport != null) {
//            progressSupport.fireProgressListenerStep(this);
//        }
    }

    private void fireProgressListenerStop() {
//        if (progressSupport != null) {
//            progressSupport.fireProgressListenerStop(this);
//        }
    }
    
    private class ElementsCollection extends AbstractCollection {
        public Iterator iterator() {
            return new Iterator() {
                private final Iterator inner = internalList.iterator();

                public void remove() {
                    throw new UnsupportedOperationException();
                }
                
                public Object next() throws NoSuchElementException {
//                    return new RefactoringElement((RefactoringElementImplementation) inner.next());
                    return null;
                }
                
                public boolean hasNext() {
                    return inner.hasNext();
                }
            };
        }

        public int size() {
            return internalList.size();
        }
    }
}
