/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * RefactoringUndoAction.java
 *
 * Created on May 25, 2006, 12:17 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.netbeans.modules.xml.refactoring.actions;

import java.text.MessageFormat;
import org.netbeans.modules.xml.refactoring.RefactoringManager;
import org.netbeans.modules.xml.refactoring.impl.UndoRedoProgress;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;

/**
 *
 * @author Jeri Lockhart
 */
public class RefactoringUndoAction extends CallableSystemAction {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * Perform the action based on the currently activated nodes.
     * Note that if the source of the event triggering this action was itself
     * a node, that node will be the sole argument to this method, rather
     * than the activated nodes.
     *
     */
    public void performAction() {
	UndoRedoProgress progress = new UndoRedoProgress();
	progress.start();
	try {
	    RefactoringManager.getInstance().undo();
	} finally {
	    progress.stop();
	}
    }
    
    /**
     * Test whether the action should be enabled based
     * on the currently activated nodes.
     *
     *
     * @param activatedNodes current activated nodes, may be empty but not <code>null</code>
     * @return <code>true</code> to be enabled, <code>false</code> to be disabled
     */
    public boolean isEnabled() {
        return RefactoringManager.getInstance().canUndo();
    }
    
    /**
     * Get a human presentable name of the action.
     * This may be
     * presented as an item in a menu.
     * <p>Using the normal menu presenters, an included ampersand
     * before a letter will be treated as the name of a mnemonic.
     *
     * @return the name of the action
     */
    public String getName() {
        String undoType = "";   //NOI18N
        if (RefactoringManager.getInstance().canUndo()) {
            undoType =
                    RefactoringManager.getInstance().getLastRefactorRequest().getDescription();
            
            return MessageFormat.format(NbBundle.getMessage(RefactoringUndoAction.class,
                    "LBL_Undo"),
                    new Object[]{undoType});
        }
        return NbBundle.getMessage(RefactoringUndoAction.class,
                "LBL_Undo_Disabled");
    }
    
    /**
     * Get a help context for the action.
     *
     * @return the help context for this action
     */
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    /**
     * If true, this action should be performed asynchronously in a private thread.
     * If false, it will be performed synchronously as called in the event thread.
     * <p>The default value is true for compatibility reasons; subclasses are strongly
     * encouraged to override it to be false, and to either do their work promptly
     * in the event thread and return, or to somehow do work asynchronously (for example
     * using {@link RequestProcessor#getDefault}).
     * <p class="nonnormative">You may currently set the global default to false
     * by setting the system property
     * <code>org.openide.util.actions.CallableSystemAction.synchronousByDefault</code>
     * to <code>true</code>.</p>
     * <p class="nonnormative">When true, the current implementation also provides for a wait cursor during
     * the execution of the action. Subclasses which override to return false should
     * consider directly providing a wait or busy cursor if the nature of the action
     * merits it.</p>
     *
     * @return true if this action should automatically be performed asynchronously
     * @since 4.11
     */
    protected boolean asynchronous() {
        return true;
    }
}
