/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.

 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.refactoring.actions;

import javax.swing.JMenuItem;
import org.netbeans.modules.xml.refactoring.ui.j.spi.ui.WhereUsedQueryUI;
import org.netbeans.modules.xml.refactoring.ui.j.ui.RefactoringPanel;
import org.netbeans.modules.xml.refactoring.ui.util.AnalysisUtilities;
import org.netbeans.modules.xml.refactoring.ui.views.WhereUsedView;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.windows.TopComponent;

/**
 *
 * @author Jeri Lockhart
 */
public class FindUsagesAction extends CookieAction
{
    static final long serialVersionUID = 1L;
    
    private static final Class[] COOKIE_ARRAY =
            new Class[] { };
    
    /**
     *
     *
     */
    public FindUsagesAction() {
        super();
    }
    
    
    /**
     *
     *
     */
    public String getName() {
        return NbBundle.getMessage(FindUsagesAction.class,
                "LBL_FindUsages"); // NOI18N
    }
    
    
    /**
     *
     *
     */
    public HelpCtx getHelpCtx() {
        return new HelpCtx(getClass());
    }
    
    
    /**
     *
     *
     */
    protected boolean asynchronous() {
        return false;
    }
    
    
    /**
     *
     *
     */
    protected boolean enable(Node[] nodes) {
        if (nodes.length!=1)
            return false;
        
        Referenceable ref = AnalysisUtilities.getReferenceable(nodes);
        return ref instanceof Referenceable;
    }
    
    
    /**
     *
     *
     */
    protected void performAction(Node[] nodes) {
        assert nodes.length==1:
            "Length of nodes array should be 1";
        Referenceable ref = AnalysisUtilities.getReferenceable(nodes);
        assert ref != null:"The node's NamedReferenceable should not be null";
        WhereUsedView wuv = new WhereUsedView(ref);
        WhereUsedQueryUI ui = new WhereUsedQueryUI(wuv, ref);
        TopComponent activetc = TopComponent.getRegistry().getActivated();
        if (activetc instanceof CloneableEditorSupport.Pane) {
            new RefactoringPanel(ui, activetc);
        } else {
            new RefactoringPanel(ui);
        }
    }
    
    protected int mode() {
        return CookieAction.MODE_EXACTLY_ONE;
    }



    protected Class[] cookieClasses() {
        return COOKIE_ARRAY;
    }
    
 
    
    ////////////////////////////////////////////////////////////////////////////
    // Instance members
    ////////////////////////////////////////////////////////////////////////////
    
    protected JMenuItem menuItem;
}
