package org.netbeans.modules.xml.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.xml.refactoring.impl.RefactoringUtil;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Reference;


public class Usage {
    private Component component;
    private Type type;
    private UsageGroup container;
    private boolean includedInRefactoring;
    private String refactoringDescription;
    
    public Usage(Component component, UsageGroup container) {
        this(component, Type.REFERENCE, container);
    }
    
    public Usage(Component component, Type type, UsageGroup container) {
        this.component = component;
        this.type = type;
        this.container = container;
        includedInRefactoring = true;
    }
    
    public enum Type {
        REFERENCE, GENERALIZATION;
        public String toString() {
            return RefactoringUtil.getDescription(this);
        }
    }

    /**
     * Returns component having the usage.
     */
    public Component getComponent() {
        return component;
    }
    
    /**
     * Returns type of the usage.
     */
    public Type getType() {
        return type;
    }
    
    public void setType(Type type) {
        this.type = type;
    }
    
    /**
     * Return the containing group of this usage.
     */
    public UsageGroup getContainer() {
        return container;
    }
    
    /**
     * Returns path from root to the usage host component.
     */
    public List<Component> getPathFromRoot() {
        return getContainer().getEngine().getUIHelper().getRelevantPathFromRoot(this.getComponent());
    }
    
    /**
     * Whether this usage item should be included in refactoring.
     */
    public boolean isIncludedInRefactoring() { 
        return includedInRefactoring; 
    }
    public void setIncludedInRefactoring(boolean included) {
        includedInRefactoring = included;
    }
    
    /**
     * Returns short description of the change would be done on this usage item
     * if the refactoring is applied.  Return null if this usage item has not been
     * associated with any refactoring request with a call to 
     * RefactoringManager.precheck().
     */
    public String getRefactoringDescription() {
        return refactoringDescription;
    }
    public void setRefactoringDescription(String desc) {
        this.refactoringDescription = desc;
    }
}