/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.css.text.syntax;

import org.netbeans.editor.BaseTokenCategory;
import org.netbeans.editor.BaseTokenID;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;

import org.netbeans.modules.css.text.syntax.javacc.lib.*;

/**
 * Token-ids and token-categories for CSS.
 *
 * @author  Miloslav Metelka
 * @author  Petr Kuzel
 * @version 1.0
 */
public class CSSTokenContext extends TokenContext {

    public final static int ATKW_ID = 1;
    public final static int COMMENT_ID = 2;
    public final static int EOL_ID = 3;
    public final static int ERROR_ID = 4;
    public final static int PLAIN_ID = 5;
    public final static int PROPERTY_ID = 6;
    public final static int SELECTOR_ID = 7;


    public final static JJTokenID ATKW = new JJTokenID("at-keyword", ATKW_ID); // NOI18N
    public final static JJTokenID COMMENT = new JJTokenID("comment", COMMENT_ID); // NOI18N
    public final static JJTokenID EOL = new JJTokenID("eol", EOL_ID); // NOI18N
    public final static JJTokenID ERROR = new JJTokenID("error", ERROR_ID, true); // NOI18N
    public final static JJTokenID PLAIN = new JJTokenID("plain", PLAIN_ID); // NOI18N
    public final static JJTokenID PROPERTY = new JJTokenID("property", PROPERTY_ID); // NOI18N
    public final static JJTokenID SELECTOR = new JJTokenID("selector", SELECTOR_ID); // NOI18N

    // Context instance declaration
    public static final CSSTokenContext context = new CSSTokenContext();

    public static final TokenContextPath contextPath = context.getContextPath();

    private CSSTokenContext() {
        super("css-"); // NOI18N

        try {
            addDeclaredTokenIDs();
        } catch (Exception e) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) { // NOI18N
                e.printStackTrace();
            }
        }

    }
}
