/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.css.text;

import java.io.*;
import java.awt.event.*;
import javax.swing.Timer;
import javax.swing.JEditorPane;
import javax.swing.event.*;
import javax.swing.text.*;

import org.openide.text.EditorSupport;
import org.openide.text.Line;
import org.openide.windows.*;
import org.openide.loaders.*;
import org.openide.cookies.*;

import org.netbeans.modules.css.*;

/**
 * Editor OAPI integration stuff.
 *
 * @author  Petr Kuzel
 * @version 1.0
 */
public class CSSEditorSupport extends EditorSupport {

    public CSSEditorSupport(MultiDataObject.Entry entry) {
        super (entry);
        setMIMEType (CSSObject.MIME_TYPE);
    }

    /* A method to create a new component. Overridden in subclasses.
     * @return the {@link Editor} for this support
     */
    protected CloneableTopComponent createCloneableTopComponent () {
        // initializes the document if not initialized
        prepareDocument ();

        return createCSSEditorComponent();
    }

    /** Method for creation of the java editor component
     * - accessible from the innerclass.
     */
    CSSEditorComponent createCSSEditorComponent() {
        CSSEditorComponent editor = new CSSEditorComponent (findDataObject());

        // dock into editor mode if possible
        Workspace current = WindowManager.getDefault().getCurrentWorkspace();
        Mode editorMode = current.findMode (EDITOR_MODE);
        if (editorMode != null)
            editorMode.dockInto (editor);

        return editor;
    }

//~~~~~~~~~~~~~~~~~~~~~~~~~ ENCODING HANDLING ~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /** Opens the css checking for corect encoding. 
    public void open() {

        try {

            openDocument(); //sync call  - prepare encodingErr

            if (encodingErr) {
                String pattern = Util.THIS.getString("TEXT_WRONG_ENCODING");
                String msg = MessageFormat.format(pattern, new Object[] {entry.getFile().toString()});
                TopManager.getDefault().notify(new NotifyDescriptor.Message(msg, NotifyDescriptor.ERROR_MESSAGE));
            } else {
                super.open();
            }

        } catch (IOException ex) {
            String pattern = Util.THIS.getString("TEXT_LOADING_ERROR");
            String msg = MessageFormat.format(pattern, new Object[] {entry.getFile().toString()});
            TopManager.getDefault().notify(new NotifyDescriptor.Message(msg, NotifyDescriptor.ERROR_MESSAGE));
        }
        
    }

    //indicates than document has wrong encoding
    private volatile boolean encodingErr;

    /** Read the file from the stream, detect right encoding.
    
    protected void loadFromStreamToKit (StyledDocument doc, InputStream in, EditorKit kit) throws IOException, BadLocationException {
        try {
            encodingErr = false;
            Reader reader = new CSSReader(in);        
            kit.read(reader, doc, 0);
        } catch (CharConversionException ex) {
            encodingErr = true;
        } catch (UnsupportedEncodingException ex) {
            encodingErr = true;
        }

    }

    /** Store the document in proper encoding.
    
    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream out) throws IOException, BadLocationException {
        try {
            Writer writer = new CSSWriter(out);
            kit.write(writer, doc, 0, doc.getLength());
        } catch (UnsupportedEncodingException ex) {
            //!!! just write nothing //?? save say as UTF-8
        }
    }

*/ 
    
    /////////////////////////////
    /// class XMLEditorComponent
    public static class CSSEditorComponent extends EditorSupport.Editor {
        /** The support, subclass of EditorSupport */
        CSSEditorSupport support;

private static final long serialVersionUID = 1997409673385969462L;

        /** Only for externalization */
        public CSSEditorComponent () {
            super();
        }

        /** Creates new editor */
        public CSSEditorComponent (DataObject obj) {
            super (obj);
            initialize();
        }

        /** Obtain a support for this component */
        private void initialize () {
            support = (CSSEditorSupport)obj.getCookie (CSSEditorSupport.class);
        }

//        /** Returns Editor pane for private use.
//         * @return Editor pane for private use.
//         */
//        private JEditorPane getEditorPane () {
//            return pane;
//        }

        /* Is called from the clone method to create new component from this one.
         * This implementation only clones the object by calling super.clone method.
         * @return the copy of this object
         */
        protected CloneableTopComponent createClonedObject () {
            return support.createCSSEditorComponent();
        }


        /* This method is called when parent window of this component has focus,
         * and this component is preferred one in it. This implementation adds 
         * performer to the ToggleBreakpointAction.
         */
        protected void componentActivated () {
            super.componentActivated();
        }

        /*
         * This method is called when parent window of this component losts focus,
         * or when this component losts preferrence in the parent window. This 
         * implementation removes performer from the ToggleBreakpointAction.
         */
        protected void componentDeactivated () {
            super.componentDeactivated();
        }

        /** Deserialize this top component.
         * @param in the stream to deserialize from
         */
        public void readExternal (ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal (in);
            initialize();
        }
    }

}
