/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.css.actions;

import java.awt.datatransfer.StringSelection;
import java.net.*;

import org.openide.*;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.*;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.actions.*;
import org.openide.filesystems.*;

import org.netbeans.modules.css.*;

/**
* Action that put XML style processing instruction in clipboard.
* TODO add PI flavor.
*
* @author Petr Kuzel
*/
public abstract class CopyStyleAction extends CookieAction {

    protected static final String comment = Util.THIS.getString("Style-Comment") + "\n"; // NOI18N

    /** Serial Version UID */
    private static final long serialVersionUID = -6638807099960633334L;
    
    /** What triggers me?
    * @return MODE_EXACTLY_ONE.
    */
    public int mode() {
        return MODE_EXACTLY_ONE;
    }

    /** What triggers me?
    * @return {CSSObject.class}
    */
    public Class[] cookieClasses() {
        return new Class[] {CSSObject.class};
    }

    /** Action.
    */
    protected void performAction(final Node[] nodes) {
        if (nodes.length != 1) return;
        if (nodes[0] == null) return;

        CSSObject csso = (CSSObject) nodes[0].getCookie(CSSObject.class);

        if (csso != null) {
            String pi = createText(csso);
            StringSelection ss = new StringSelection(pi);
            ExClipboard clipboard = (ExClipboard) Lookup.getDefault().lookup(ExClipboard.class);
            clipboard.setContents(ss, null);
            StatusDisplayer.getDefault().setStatusText(Util.THIS.getString("MSG_Style_tag_in_clipboard"));  // NOI18N
        }

    }

    /** A method that creates particular clipboard text.
    * @return text to be placed to clip board.
    */
    protected abstract String createText(CSSObject node);

    /** Get help context for the action.
    */
    public HelpCtx getHelpCtx() {
        return new HelpCtx(getClass());
    }

    /** Converts CSS fileobject to its href that is valid during IDE runtime. */
    protected String getHref(FileObject fo) {
        URL u = URLMapper.findURL(fo, URLMapper.NETWORK);
        if (u != null) {
            return u.toExternalForm();
        } else {
            return fo.getPath();
        }
    }

    /** Produces XML PI text. */
    public final static class XML extends CopyStyleAction {

        /** Serial Version UID */
        private static final long serialVersionUID = -6638807099960633335L;
        
        protected String createText(CSSObject csso) {
            return comment + "<?xml-stylesheet type=\"text/css\" href=\"" + this.getHref(csso.getPrimaryFile()) + "\" ?>"; // NOI18N
        }

        public String getName() {
            return Util.THIS.getString("Copy-XML-Style"); // NOI18N
        }
    }

    /** Produces HTML style text. */
    public final static class HTML extends CopyStyleAction {

        /** Serial Version UID */
        private static final long serialVersionUID = -6638807099960633336L;
        
        protected String createText(CSSObject csso) {
            return comment + "<link rel=\"StyleSheet\" type=\"text/css\" href=\"" + this.getHref(csso.getPrimaryFile()) + "\" media=\"screen\" >";  // NOI18N
        }

        public String getName() {
            return Util.THIS.getString("Copy-HTML-Style"); // NOI18N
        }
    }
}
