/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
/*
 * DTDParserTest.java
 * NetBeans JUnit based test
 *
 * Created on April 10, 2002, 9:06 AM
 */

package org.netbeans.modules.xml.core.wizard;

import java.io.*;
import java.net.URL;
import java.util.*;
import junit.framework.*;
import org.netbeans.junit.*;
import org.xml.sax.*;
import org.xml.sax.ext.*;
import org.xml.sax.helpers.*;
import org.openide.xml.*;
import org.openide.util.Lookup;
import org.netbeans.modules.xml.core.tree.ModuleEntityResolver;

/**
 * Must be executed in IDE with mounted NetBEans XML Catalog.
 *
 * @author Petr Kuzel
 */
public class DTDParserTest extends NbTestCase {
    
    public DTDParserTest(java.lang.String testName) {
        super(testName);
    }
    
    public static void main(java.lang.String[] args) {
        junit.textui.TestRunner.run(suite());
    }
    
    public static Test suite() {
        TestSuite suite = new NbTestSuite(DTDParserTest.class);
        
        return suite;
    }
    
    /** Test of parse method, of class org.netbeans.modules.xml.core.wizard.DTDParser. */
    public void testParse() {        
        URL dtd = getClass().getResource("data/dtd.dtd");
        InputSource in = new InputSource(dtd.toExternalForm());
        Set roots = new DTDParser().parse(in);        
        assertTrue("Expected decl not found!", roots.contains("root"));
    }    
    
}
