/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.actions;

import java.awt.Container;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.netbeans.jellytools.EditorWindowOperator;
import org.netbeans.jellytools.actions.OpenAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.properties.ComboBoxProperty;
import org.netbeans.jellytools.properties.PropertySheetOperator;
import org.netbeans.jellytools.properties.PropertySheetTabOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.junit.NbTestSuite;
import org.netbeans.tests.xml.JXTest;

/** Checks Open XML, DTD action and expanding XML, DTD trees. */
public class OpenActionJTest extends JXTest {
    
    /** Creates new XMLNodeTest */
    public OpenActionJTest(String testName) {
        super(testName);
    }
    
    // TESTS ///////////////////////////////////////////////////////////////////
    
    /** Opens XML documet and expands documet tree in the Tree Editor. */
    public void testOpenXML() {
        openTest("Node00", 26);
    }
    
    /** Expands XML documet tree in the Explorer. */
    public void testExpandXML() {
        expandTest("Node01", 26);
    }
    
    /** Opens DTD documet and expands documet tree in the Tree Editor. */
    public void testOpenDTD() {
        openTest("books", 75);
    }
    
    /** Expands DTD documet tree in the Explorer. */
    public void testExpandDTD() {
        expandTest("books1", 75);
    }
    
    // LIB ////////////////////////////////////////////////////////////////////
    
    /** Opens document, expands documet's tree end counts documents nodes. */
    private void openTest(String label, int nodesNum) {
        // node in the Explorer
        Node exNode = null;
        // node in the Tree Editor
        Node teNode = null;
        
        // perform Open Action
        OpenAction  openAction = new OpenAction();
        ContainerOperator treeEditor = null;
        try {
            // find document node and open it
            exNode = findDataNode(label);
            openAction.perform(exNode);
            JTabbedPaneOperator op = new JTabbedPaneOperator(new EditorWindowOperator());
            Container cont = (Container) new JTabbedPaneOperator(new EditorWindowOperator()).selectPage(label);
            treeEditor = new ContainerOperator(cont);
        } catch (Exception ex) {
            fail("Cannot perform Open Action.", ex);
        }
        
        setNodeView(exNode, "Linear Node View");
        
        int count = 0;
        try {
            // expand documet tree in the Tree Editor and count nodes
            teNode = new Node(new JTreeOperator(treeEditor), "");
            count = expand(teNode);
        } catch (Exception ex) {
            fail("Cannot expand document tree in the Tree Editor.", ex);
        }
        new EditorWindowOperator().closeDiscard();
        assertEquals("Invalid nodes count.", count, nodesNum);
    }
    
    /** Opens document, expands documet's tree end counts documents nodes. */
    private void expandTest(String label, int nodesNum) {
        // node in the Tree Editor
        Node exNode = null;
        try {
            exNode = findDataNode(label);
            // force document to parse
            exNode.expand();
            exNode.waitExpanded();
            exNode.collapse();
        } catch (Exception ex) {
            fail("Cannot expand document.", ex);
        }
        
        setNodeView(exNode, "Linear Node View");
        
        int count = 0;
        try {
            // expand documet tree in the Explorer and count nodes
            count = expand(exNode);
        } catch (Exception ex) {
            fail("Cannot expand document tree in the explorer.", ex);
        }
        assertEquals("Invalid nodes count.", count, nodesNum);
    }
    
    /**
     * expands node recursively and returns number of childs on all sublevels
     */
    private int expand(Node node) {
        node.select();
        JTree jtree = (JTree)node.tree().getSource();
        TreePath tpath = node.getTreePath();
        if (jtree.getModel().isLeaf(tpath.getLastPathComponent())) return 0;
        node.expand();
        node.waitExpanded();
        String[] children = node.getChildren();
        int num = children.length;
        for (int i = 0; i < children.length ; i++) {
            num += expand(new Node(node, i));
        }
        return num;
    }
    
    /** Sets node view */
    private void setNodeView(Node node, String view) {
        try {
            node.select();
            PropertySheetOperator pso = new PropertySheetOperator("Properties of " + node.getText()); //!!! FIXME: I18N
            PropertySheetTabOperator psto = pso.getPropertySheetTabOperator("View"); //!!! FIXME: I18N
            new ComboBoxProperty(psto, "Node View").setValue(view); //!!! FIXME: I18N
        } catch (Exception ex) {
            fail("Cannot set " + view + " for " + node.getText(), ex);
        }
    }
    
    // MAIN ////////////////////////////////////////////////////////////////////
    
//    public static Test suite() {
//        TestSuite suite = new NbTestSuite();
//        suite.addTest(new OpenActionJTest("testOpenXML"));
//        suite.addTest(new OpenActionJTest("testOpenDTD"));
//        return suite;
//    }
    
    public static void main(String[] args) throws Exception {
        DEBUG = false;
        System.setProperty("xmltest.dbgTimeouts", "true");
        //TestRunner.run(OpenActionJTest.class);
        
        TestSuite suite = new NbTestSuite();
        suite.addTest(new OpenActionJTest("testOpenXML"));
        suite.addTest(new OpenActionJTest("testOpenDTD"));
        TestRunner.run(suite);
    }
}
