/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.wizard;

import java.awt.Component;
import java.net.*;
import java.io.*;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.text.JTextComponent;

/**
 * This panel gathers data that are necessary for instantiting of XML
 * document conforming to given XML Schema.
 * <p>
 * Data allows to create a document that respect restrictions of current parser
 * implementations (they use schemaLocation hint specifically).
 *
 * @author  Petr Kuzel
 */
public class SchemaPanel extends AbstractPanel {
    /** Serial Version UID */
    private static final long serialVersionUID = -7568909683682244030L;    
    
    
    /** Creates new form SchemaPanel */
    public SchemaPanel() {
        initComponents();
        initAccessibility();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        descTextArea = new javax.swing.JTextArea();
        locationLabel = new javax.swing.JLabel();
        locationTextField = new javax.swing.JTextField();
        locationButton = new javax.swing.JButton();
        nsLabel = new javax.swing.JLabel();
        nsComboBox = new javax.swing.JComboBox();
        rootLabel = new javax.swing.JLabel();
        rootComboBox = new javax.swing.JComboBox();
        fillPanel = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        setName(Util.THIS.getString("PROP_schema_panel_name"));
        descTextArea.setColumns(20);
        descTextArea.setEditable(false);
        descTextArea.setLineWrap(true);
        descTextArea.setText(Util.THIS.getString("MSG_schema_wizard_desc"));
        descTextArea.setWrapStyleWord(true);
        descTextArea.setDisabledTextColor(descTextArea.getForeground());
        descTextArea.setEnabled(false);
        descTextArea.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 0);
        add(descTextArea, gridBagConstraints);

        locationLabel.setLabelFor(locationTextField);
        locationLabel.setText(Util.THIS.getString("LBL_schema_location"));
        locationLabel.setToolTipText(Util.THIS.getString("PROP_schema_locationLabel_desc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 12);
        add(locationLabel, gridBagConstraints);

        locationTextField.setToolTipText(Util.THIS.getString("PROP_schema_locationTextField_desc"));
        locationTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                locationTextFieldFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 12);
        add(locationTextField, gridBagConstraints);

        locationButton.setText(Util.THIS.getString("LBL_browse"));
        locationButton.setToolTipText(Util.THIS.getString("PROP_schema_locationButton_desc"));
        locationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                locationButtonActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 0);
        add(locationButton, gridBagConstraints);

        nsLabel.setLabelFor(nsComboBox);
        nsLabel.setText(Util.THIS.getString("LBL_root_namespace"));
        nsLabel.setToolTipText(Util.THIS.getString("PROP_schema_nsLabel_desc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 12);
        add(nsLabel, gridBagConstraints);

        nsComboBox.setEditable(true);
        nsComboBox.setToolTipText(Util.THIS.getString("PROP_schema_nsComboBox_desc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 0);
        add(nsComboBox, gridBagConstraints);

        rootLabel.setLabelFor(rootComboBox);
        rootLabel.setText(Util.THIS.getString("PROP_schema_root_name"));
        rootLabel.setToolTipText(Util.THIS.getString("PROP_schema_rootLabel_desc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 12);
        add(rootLabel, gridBagConstraints);

        rootComboBox.setEditable(true);
        rootComboBox.setToolTipText(Util.THIS.getString("PROP_schema_rootComboBox_desc"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(rootComboBox, gridBagConstraints);

        fillPanel.setLayout(null);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(fillPanel, gridBagConstraints);

    }//GEN-END:initComponents

    private void initAccessibility() {

        // memonics
        Util util = Util.THIS;        
        locationLabel.setDisplayedMnemonic(util.getChar("PROP_schema_locationLabel_mne"));
        rootLabel.setDisplayedMnemonic(util.getChar("PROP_schema_rootLabel_mne"));
        nsLabel.setDisplayedMnemonic(util.getChar("PROP_schema_nsLabel_mne"));
        locationButton.setMnemonic(util.getChar("PROP_schema_locationButton_mne"));
        getAccessibleContext().setAccessibleDescription(descTextArea.getText());
    }
    
    private void locationTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_locationTextFieldFocusLost
        updatePossibilities();
    }//GEN-LAST:event_locationTextFieldFocusLost

    private void locationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_locationButtonActionPerformed
        File file = Util.selectSchemaFile("xsd xml xsdl");
        if (file == null) return;
        try {
            URL url = file.toURL();
            locationTextField.setText(url.toExternalForm());
            updatePossibilities();
        } catch (MalformedURLException ex) {
            // ignore it
        }
    }//GEN-LAST:event_locationButtonActionPerformed

    /**
     * Update namespace and root combo models.
     */
    private void updatePossibilities() {
        
        //??? we are in AWT parser in other Task and post results in AWT-queue
        
        SchemaParser parser = new SchemaParser();
        
        String systemId = locationTextField.getText();
        try {
            URL context = model.getTargetFolderURL();            
            if (context != null) {
                systemId = new URL(context, systemId).toExternalForm();
            }
        } catch (MalformedURLException ex) {
            // ignore it use one passes by user
        }
        SchemaParser.SchemaInfo info = parser.parse(systemId);        
        
        if (info == null) return;
        
        nsModel.removeAllElements();
        if (info.namespace != null) {
            nsModel.addElement(info.namespace);
        }
        
        if (info.roots.size() > 0) {
            rootModel.removeAllElements();
            Iterator it = info.roots.iterator();
            while (it.hasNext()) {
                String next = (String) it.next();
                rootModel.addElement(next);
            }
        }
        
        // select suggested text (do not focus it)
        Component editor = rootComboBox.getEditor().getEditorComponent();
        if (editor instanceof JTextComponent) {
            ((JTextComponent)editor).selectAll();
        }
    }
    
    /** User just entered the panel, init view by model values
     */
    protected void initView() {
        
        // we use well-defined mutable models
        
        nsModel = new DefaultComboBoxModel();
        rootModel = new DefaultComboBoxModel();
        
        nsComboBox.setModel(nsModel);
        rootComboBox.setModel(rootModel);
    }    
    
    /** User just leaved the panel, update model
     */
    protected void updateModel() {
        String uri = locationTextField.getText();
        if (uri != null) {
            // we need to escape spaces, URI does not like them
            uri = uri.replaceAll(" ", "%20"); // NOI18N
            try {
                // escape the non-ASCII characters
                uri = new URI(uri).toASCIIString();
            } catch (URISyntaxException e) {
                // the specified uri is not valid, it is too late to fix it now
            }
        }
        model.setSystemID(uri == null || uri.length() == 0 ? null : uri);
        
        Object ns = nsComboBox.getSelectedItem();
        model.setNamespace(ns == null ? null : ns.toString());
        
        Object root = rootComboBox.getSelectedItem();
        model.setRoot(root == null ? null : root.toString());
        
    }    
    
    /** User just reentered the panel.
     */
    protected void updateView() {
    }
    
    private DefaultComboBoxModel nsModel;
    private DefaultComboBoxModel rootModel;
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel locationLabel;
    private javax.swing.JLabel rootLabel;
    private javax.swing.JLabel nsLabel;
    private javax.swing.JComboBox rootComboBox;
    private javax.swing.JTextField locationTextField;
    private javax.swing.JTextArea descTextArea;
    private javax.swing.JButton locationButton;
    private javax.swing.JComboBox nsComboBox;
    private javax.swing.JPanel fillPanel;
    // End of variables declaration//GEN-END:variables

}
