/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.wizard;

import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

/**
 * Holds state of new document wizard.
 *
 * @author  Petr Kuzel
 */
public final class DocumentModel {
    
    public static final int NONE = 0;
    
    public static final int DTD = 1;
    
    public static final int SCHEMA = 2;
    
    public static final int OTHER = 3;
    
    private String name;
    
    private String namespace;
    
    private String publicID;    
    
    private String systemID;
        
    private String root;
    
    // input property describing wizard invocation context
    private URL targetFolderURL;
    
    public static final String PROP_TYPE = "type";
    
    private int type;

    private PropertyChangeSupport support;
        
    /** Creates new SchemaWizardModel */
    public DocumentModel(URL targetFolderURL) {
        type = NONE;
        this.targetFolderURL = targetFolderURL;
    }
        
    public String getName() {
        return name;
    }
    
    public void setName(String value) {
        name = value;
    }
        
    public String getNamespace() {
        return this.namespace;
    }
    
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
    
    public String getPublicID() {
        if (publicID != null && publicID.trim().equals("")) return null;
        return this.publicID;
    }
    
    public void setPublicID(String publicID) {
        this.publicID = publicID;
    }
    
    public String getSystemID() {
        return this.systemID;
    }
    
    public void setSystemID(String systemID) {
        this.systemID = systemID;
    }
    
    public String getRoot() {
        if (root != null && root.trim().equals("")) return null;
        return this.root;
    }
    
    public void setRoot(String root) {
        this.root = root;
    }
            
    public int getType() {
        return this.type;
    }
    
    public void setType(int type) {
        int old = this.type;
        this.type = type;
        getSupport().firePropertyChange(PROP_TYPE, old, type);
    }
    
    public URL getTargetFolderURL() {
        return targetFolderURL;
    }
        
    public void addPropertyChangeListener(PropertyChangeListener l) {
        getSupport().addPropertyChangeListener(l);
    }
    
    public void removePropertyChangeListener(PropertyChangeListener l) {
        getSupport().removePropertyChangeListener(l);
    }
    
    private synchronized PropertyChangeSupport getSupport() {
        if (support == null) {
            support = new PropertyChangeSupport(this);
        }
        return support;
    }
    
}
