/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.text;

import java.awt.Point;
import java.awt.Component;

import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.text.StyledDocument;

import org.openide.*;
import org.openide.text.*;
import org.openide.nodes.*;
import org.openide.cookies.*;

import org.netbeans.modules.xml.core.*;
import org.netbeans.modules.xml.core.sync.*;

/**
 * Takes care about specifics of XML test representations.
 * It covers update() method.
 *
 * @author  Petr Kuzel
 * @version 
 */
public class XMLTextRepresentation extends TextRepresentation {

    /** Creates new XMLTextRepresentation */
    public XMLTextRepresentation(TextEditorSupport editor, Synchronizator sync) {
        super(editor, sync);
    }


    /*
     * Retrives editor cookie and perform text replacing holding caret and view at original
     * position if possible.
     *
     */
    public void updateText (Object input) {
        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("XMLTextRepresentation::updateText");//, new RuntimeException ("Updating text...........")); // NOI18N

        final String in = (String) input;
        
        try {

            EditorCookie es = editor;
            if (es != null) {

                StyledDocument tmpdoc = es.getDocument();
                if (tmpdoc == null)
                    tmpdoc = es.openDocument();

                //sample editor position

                JEditorPane[] eps = es.getOpenedPanes();
                JEditorPane pane = null;
                JViewport port = null;
                int caretPosition = 0;
                Point viewPosition = null;
                if (eps != null) {
                    pane = eps[0];
                    caretPosition = pane.getCaretPosition();
                    port = getParentViewport (pane);
                    if (port != null)
                        viewPosition = port.getViewPosition();
                }

                // prepare modification task

                final Exception[] taskEx = new Exception[] {null};
                final StyledDocument sdoc = tmpdoc;

                Runnable task = new Runnable() {
                    public void run() {
                        try {
                            sdoc.remove (0, sdoc.getLength());  // right alternative

                            // we are at Unicode level
                            sdoc.insertString (0, in, null);
                        } catch (Exception iex) {
                            taskEx[0] = iex;
                        }
                    }
                };

                // perform document modification

                org.openide.text.NbDocument.runAtomicAsUser(sdoc, task);

                //??? setModified (true);  
                
                //restore editor position

                if (eps != null) {
                    try {
                        pane.setCaretPosition (caretPosition);
                    } catch (IllegalArgumentException e) {
                    }
                    port.setViewPosition (viewPosition);
                }

                if (taskEx[0]!=null) {
                    throw taskEx[0];
                }

            } //es!=null

        } catch (Exception e) {
            ErrorManager.getDefault().notify(e);
        }
    }
    
    
    /**
     * Update the representation without marking it as modified.
     */
    public void update(Object change) {
        if (change instanceof String) {
            String update = (String) change;
            updateText(update);
        } 
    }

    /**
     * Is this representation modified since last sync?
     */
    public boolean isModified() {
        return false; //!!! es.isModified();
    }


    private JViewport getParentViewport (JEditorPane component) {
        Component pc = component.getParent();
        return (pc instanceof JViewport) ? (JViewport)pc : null;
    }        
    
}
