/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.text;

import java.io.Reader;
import java.io.StringReader;

import javax.swing.text.Document;

import org.xml.sax.*;

import org.netbeans.modules.xml.core.*;
import org.netbeans.modules.xml.core.sync.*;
import org.netbeans.modules.xml.core.lib.*;
import java.net.URL;
import java.io.IOException;

/**
 * Manages text representation and its editor interaction.
 * Takes care for proper event propagation.
 *
 * It is related to Document. 
 * <p>Update accepts: String.
 * <p>Change provides: Document, Reader, InputSource, String
 *
 *
 * @author  Petr Kuzel
 * @version 
 */
public abstract class TextRepresentation extends SyncRepresentation {

    /**
     * Holds reference to editor support.
     */
    protected final TextEditorSupport editor;
    
    /** Creates new TextRepresentation */
    public TextRepresentation(TextEditorSupport editor, Synchronizator sync) {
        super(sync);
        this.editor = editor;
    }
    
    /**
     * Does this representation wraps given model?
     */
    public boolean represents(Class type) {
        return Document.class.isAssignableFrom(type);
    }

    public int level() {
        return 1;
    }

    /**
     * Return modification passed as update parameter to all slave representations.
     */
    public Object getChange(Class type) {
        if (type == null || type.isAssignableFrom(Document.class)) {
            return editor.getDocument();
        } else if (type.isAssignableFrom(String.class)) {
            try {
                return Convertors.documentToString(editor.openDocument());
            } catch (IOException ex) {
                Util.THIS.debug(ex);
                return null;
            }
        } else if (type.isAssignableFrom(InputSource.class)) {
            
            InputSource in = null;
            try {
                in = Convertors.documentToInputSource(editor.openDocument());
            } catch (IOException ex) {
                Util.THIS.debug(ex);
                return null;
            }
            try {
                URL baseURL = editor.getDataObject().getPrimaryFile().getURL();
                String systemId = baseURL.toExternalForm();
                in.setSystemId(systemId);
            } catch (IOException ex) {
                // file object diappeared, we can not parse relative external entities then
                if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug("Warning: missing file object, external entities cannot be parsed."); // NOI18N
            }
            return in;
        } else if (type.isAssignableFrom(Reader.class)) {
            try {
                return new StringReader(Convertors.documentToString(editor.openDocument()));
            } catch (IOException ex) {
                Util.THIS.debug(ex);
                return null;
            }
        }

        throw new RuntimeException("Unsupported type: " + type); // NOI18N
    }
    
    /**
     * @return select button diplay name used during notifying concurent modification
     * conflict.
     */
    public String getDisplayName() {
        return Util.THIS.getString ("PROP_Text_representation");
    }
    
    /**
     * Return accepted update class
     */
    public Class getUpdateClass() {
        return String.class;
    }

}
