/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.sync;

/**
 * Synchronization manager methods.
 * 
 * @author  Petr Kuzel
 * @version 1.0
 */
public interface Synchronizator {

    /** Tree representation has changed, update text accordingly. */
    public void representationChanged(Class type);

    /** @return state of this sync interface, true if just syncing. */
    public boolean isInSync();

    /**
     * A new model appeared.
     * It may my change result returned by getRepresentations().
     */
    public void addRepresentation(Representation rep);
    
    /**
     * Some model disppeared.
     * It may my change result returned by getRepresentations().
     */
    public void removeRepresentation(Representation rep);
    
    /**
     * Prior creating new representation we should query for primary one
     * and create the new one from the primary one.
     */
    public Representation getPrimaryRepresentation();
    
    
    /**
     * Allow to perform a task that is treated as ordinary synchronization request
     */
    public void postRequest(Runnable request);

}
