/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.sync;

import org.openide.nodes.*;

/**
 * Same data may have multiple representations. A representation can
 * be described using this interface.
 *
 * @author  Petr Kuzel
 * @version 
 */
public interface Representation {

    /**
     * @return select button diplay name used during notifying concurent modification
     * conflict.
     */
    public String getDisplayName();

    /**
     * Is this representation modified since last update?
     * Warning isModified() does not equals representationChanged().
     */
    public boolean isModified();

    /**
     * Determine whether given representation is valid. E.g. tree
     * represnattion is valid just if parsed successfully.
     */
    public boolean isValid();
    
    /**
     * Update the representation without marking it as modified.
     */
    public void update(Object change);

    /**
     * Return prefered update class or null if does not matter.
     * //??? Could return <codE>Class[]</code> in future.
     */
    public Class getUpdateClass();

    /**
     * Return modification passed as update parameter to all slave representations.
     * @param type if null return arbitrary representation
     * @return Change or null if change of given type can not be returned
     */
    public Object getChange(Class type);

    /**
     * Does this representation wraps given model?
     */
    public boolean represents(Class type);

    /**
     * Returnrepresentation level: 0 = file, 1 = byte buffer [text],
     * 2 = structural model, 3 = semantics model ... A higher level
     * representaion requires that lower level representation is
     * loaded too.
     *
     * @return
     */
    public int level();
}
