/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.settings;

import java.beans.*;
import java.util.*;

import org.openide.actions.*;
import org.openide.util.actions.*;

/**
 * A simple property editor allowing to select class name of default action.
 *
 * @author  Petr Kuzel
 */
public final class DefaultActionPropertyEditor extends PropertyEditorSupport {
    
    /** Action name to its class name map */
    private static Map name2class = new TreeMap();
    
    static {
        String dname, cname;
        dname = SystemAction.get(EditAction.class).getName();
        cname = EditAction.class.getName();
        name2class.put(dname, cname);
        
        dname = SystemAction.get(OpenAction.class).getName();
        cname = OpenAction.class.getName();
        name2class.put(dname, cname);        

//        dname = SystemAction.get(PopupAction.class).getName();
//        cname = PopupAction.class.getName();
//        name2class.put(dname, cname);        

        dname = SystemAction.get(ViewAction.class).getName();
        cname = ViewAction.class.getName();
        name2class.put(dname, cname);        
        
        //??? some more actions as check would be handy. We should define them
        // in core as a cookie actions
        
    }
    
    /** Creates new DefaultActionPropertyEditor */
    public DefaultActionPropertyEditor() {        
    }
    
    /**
     * @return display names of suitable actions
     */
    public String[] getTags() {
        Set names = name2class.keySet();
        return (String[]) names.toArray(new String[names.size()]);
    }
    
    public void setAsText(String action) {
        String klass = (String) name2class.get(action);
        if (klass != null) {
            setValue(klass);
        } else {
            setValue(null);  // we could findout whether it is not an action defined by class name
                             // it is a feature for experienced users that will be implemented by request
        }
    }

    /**
     * Represent propery value as a text.
     */
    public String getAsText() {
        String className = (String) getValue();
        if (className == null) {
            return Util.THIS.getString("PROP_system_default_action");
        } else {
            Iterator it = name2class.keySet().iterator();
            while (it.hasNext()) {
                String key = (String) it.next();
                String next = (String) name2class.get(key);
                if (next == null) continue;
                if (next.equals(className)) return key;
            }
            return className;  // for diagnostics purposes
        }        
    }
    
    public boolean supportsEditingTaggedValues () {
        return false;
    }
    
    public boolean hasInPlaceCustomEditor () {
        return false;
    }

    public boolean isPaintable() {
        return false;
    }
}
