/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.lib;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.SwingUtilities;

import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Mutex;

/**
 * @author  Libor Kramolis
 */
public final class GuiUtil {
    
    private GuiUtil() {}

    /**
     * Try to perform default action on specified file object.
     */
    public static void performDefaultAction (FileObject fo) {
        if (fo == null) {
            if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("FileObject can not be null.", new IllegalArgumentException());  // NOI18N
            return;            
        }
        final DataObject obj;
        try {
            obj = DataObject.find(fo);
        } catch (DataObjectNotFoundException e) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("DataObject not found", e); // NOI18N
            }
            return;            
        }
        // All else is GUI, do in EQ.
        Mutex.EVENT.readAccess(new Runnable() {
            public void run() {
                Node node = obj.getNodeDelegate();
                Action a = node.getPreferredAction();
                if (a != null) {
                    a.actionPerformed(new ActionEvent(node, ActionEvent.ACTION_PERFORMED, "")); // NOI18N
                }
            }
        });
    }

    public static boolean confirmAction (String message) {
        NotifyDescriptor nd = new NotifyDescriptor.Confirmation (message, NotifyDescriptor.YES_NO_OPTION);
        Object option = DialogDisplayer.getDefault().notify (nd);
        return ( option == NotifyDescriptor.YES_OPTION );
    }


    public static void setStatusText (String text) {
        StatusDisplayer.getDefault().setStatusText (text);
    }



    /**
     * Notify exception to user. Just shortcut to ErrorManager.
     */
    public static void notifyException (Throwable exc) {
        notifyException (null, exc);
    }


    /**
     * Notify annotated exception to user. Just shortcut to ErrorManager.
     */    
    public static void notifyException (String desc, Throwable ex) {
        ErrorManager err = ErrorManager.getDefault();
        if (desc != null) {
            err.annotate (ex, desc);
        }
        err.notify (err.EXCEPTION, ex);  // show stack trace to user
    }

    /**
     * Thread safe notify message as WARNING_MESSAGE.
     */
    public static void notifyWarning (final String message) {
        // invokeLater??? there had to be some error with DialogDisplyer
        SwingUtilities.invokeLater (new Runnable () {
                public void run () {
                    NotifyDescriptor nd = new NotifyDescriptor.Message
                        (message, NotifyDescriptor.WARNING_MESSAGE);
                    DialogDisplayer.getDefault ().notify (nd);
                }
            });
    }

    public static void notifyError (final String message) {
        SwingUtilities.invokeLater (new Runnable () {
                public void run () {
                    DialogDisplayer.getDefault().notify
                        (new NotifyDescriptor.Message (message, NotifyDescriptor.ERROR_MESSAGE)
                         );        
                }
            });
    }

}
