/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.core.lib;

import java.awt.event.FocusListener;

/**
 * Holds common A11Y hacks.
 *
 * @author  Petr Kuzel
 */
public final class A11YUtil {
    
    /** Creates a new instance of A11YUtil */
    private A11YUtil() {
    }
 
    private static FocusListener flis;
    
    /**
     * Get universal Focus listener suitable for decsription JTextFields only.
     * It provides screen reades support for read only enabled descriptions.
     */
    public static synchronized FocusListener getA11YJTextFieldSupport() {
    
        if (flis == null) {
            flis = new java.awt.event.FocusListener() {
                public void focusGained(java.awt.event.FocusEvent e) {
                    if (e.getComponent() instanceof javax.swing.JTextField) {
                        ((javax.swing.JTextField)e.getComponent()).selectAll();
                    }
                }
                public void focusLost(java.awt.event.FocusEvent e) {
                    if (e.getComponent() instanceof javax.swing.JTextField) {
                        ((javax.swing.JTextField)e.getComponent()).select(1,1);
                    }
                }
            };
        }
        return flis;
    }
    
}
