/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.cookies;

import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.xml.api.scenario.Scenario;

/**
 * Keeps scenario information which should be stored persistently per
 * DataObject.
 *
 * @author  asgeir@dimonsoftware.com
 */
public class ScenarioData implements Serializable {
    
    /** Serial Version UID */
    private static final long serialVersionUID = -6268945794243989727L;
    
    /** A collection of Scenario objects */
    private Vector scenarios; //XXX Vector is not good because it contains client implementations of Scenario and when such implementation is not available, the deserialization of entire Vector could be interupted. Rewrite it to custom [de]serialization object byte object!
    
    /** Index of the active scenario in the scenarios vector*/
    private int activeScenarioIndex;

    /** @link dependency */
    /*# Scenario lnkScenario; */

    /** Creates a new instance of ScenarioData */
    public ScenarioData() {
        scenarios = new Vector();
        activeScenarioIndex = -1;
    }
    
    /**
     * @return A collection of Scenario objects
     */
    public Vector getScenarios() {
        return scenarios;
    }

    /**
     * Sets the index of the active scenario in the scenarios vector.
     * The value should be >= 0 and < the size of the vector returned by
     * getScenarios().
     */
    public void setActiveScenarioIndex(int index) {
        activeScenarioIndex = index;
    }

    /**
     * @return Index of the active scenario in the scenarios vector
     */
    public int getActiveScenarioIndex() {
        return activeScenarioIndex;
    }        
}
