/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.cookies;

import org.openide.nodes.*;
import org.openide.loaders.*;
import org.openide.cookies.*;

/**
 * This implementation of CookieManagerCookie updates modified property of
 * passed DataObject according of presence of SaveCookie.
 *
 * @author  Petr Kuzel
 * @version 
 */
public class DataObjectCookieManager extends DefaultCookieManager {

    private final DataObject dobj;
    
    /** Creates new DataObjectCookieManager */
    public DataObjectCookieManager(DataObject dobj, CookieSet set) {
        super(set);
        this.dobj = dobj;
    }

    /**
     * Remove given cookie from cookies managed by owner.
     * The owner is free to update its internal state according it.
     */
    public void removeCookie(Node.Cookie cake) {
        
        //??? place it into RP? it fires. It should do callee, it knows about locks!

        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("DataObjectCookieManager::removeCookie " + cake.getClass()); // NOI18N
        
        super.removeCookie(cake);
        
        // any save cookie subclass means the we are not modified any more
        if (SaveCookie.class.isAssignableFrom (cake.getClass())) {
            dobj.setModified (false);
        }
    }
    
    /**
     * Add given cookie into set of cookies ot this cookie owner.
     * Cookie owner is free to update its internal state according it.
     */
    public void addCookie(Node.Cookie cake) {
        
        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("DataObjectCookieManager::addCookie " + cake.getClass()); // NOI18N
        
        super.addCookie(cake);
        
        // any save cookie subclass means the we are modified
        if (SaveCookie.class.isAssignableFrom (cake.getClass())) {
            dobj.setModified (true);
        }        
    }
    
}
