/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core.actions;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.util.*;

import javax.swing.JMenuItem;

import org.openide.awt.JInlineMenu;
import org.openide.windows.TopComponent.Registry;
import org.openide.windows.WindowManager;
import org.openide.util.actions.SystemAction;
import org.openide.util.actions.Presenter;
import org.openide.util.Lookup;


public abstract class CollectSystemAction extends SystemAction implements Presenter.Popup {
    /** Serial Version UID */
    private static final long serialVersionUID = 6517322512481423122L;

    /** All Actions Lookup Result. */
    private Lookup.Result allActionsResult;

    /** empty array of menu items */
    static JMenuItem[] NONE = new JMenuItem[] {};


    /** Which Class should be used for Lookup? */
    protected abstract Class getActionLookClass ();

    /** @return all instances of <code>getActionLookClass</code>.
     */
    protected synchronized Collection getPossibleActions () {
        if ( allActionsResult == null ) {
            allActionsResult = Lookup.getDefault().lookup (new Lookup.Template (getActionLookClass()));
        }
        return allActionsResult.allInstances();
    }


    private JMenuItem[] createMenu () {
        JMenuItem[] menu;

        menu = createMenu (getPossibleActions());

        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("--- CollectSystemAction.createMenu: menu = " + menu);//, new RuntimeException());

        return menu;
    }

    private JMenuItem[] createMenu (Collection coll) {
        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("\n--> CollectSystemAction.createMenu: ( " + coll + " )");

        ArrayList items = new ArrayList ();

        Iterator it = coll.iterator();
        while (it.hasNext ()) {
            SystemAction a = (SystemAction) it.next();
            
            if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("-*- CollectSystemAction.createMenu: next action " + a +
                             " -- " + ( a.isEnabled() ? "<enabled>" : "[disabled]" ) );
            
            if ( a.isEnabled() ) {
                JMenuItem item = null;
                if (a instanceof Presenter.Popup) {
                    item = ((Presenter.Popup)a).getPopupPresenter ();
                }

                if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("-*- CollectSystemAction.createMenu: menu item = " + item);

                // test if we obtained the item
                if (item != null) {
                    items.add (item);
                }
            }
        }

        if ( Util.THIS.isLoggable() ) /* then */ Util.THIS.debug ("<-- CollectSystemAction.createMenu: all items = " + items + "\n");

        JMenuItem[] array = new JMenuItem [items.size ()];
        items.toArray (array);
        return array;
    }


    /* @return popup presenter.
     */
    public JMenuItem getPopupPresenter () {
        return new Menu();
    }

    /* Do nothing.
    * This action itself does nothing, it only presents other actions.
    * @param ev ignored
    */
    public void actionPerformed (java.awt.event.ActionEvent e) {
    }



    /** Presenter for this action.
    */
    private class Menu extends JInlineMenu {
        private static final long serialVersionUID = -4962039848190160129L;

        /** last registered items */
        private JMenuItem[] last = NONE;
        /** own property change listner */
        private PropL propL = new PropL ();


        /**
         */
        Menu () {
            changeMenuItems (createMenu());

            Registry r = WindowManager.getDefault().getRegistry ();

            r.addPropertyChangeListener (
                org.openide.util.WeakListeners.propertyChange (propL, r)
            );
        }

        /** Changes the selection to new items.
        * @param items the new items
        */
        synchronized void changeMenuItems (JMenuItem[] items) {
            removeListeners (last);
            addListeners (items);
            last = items;
            setMenuItems (items);
        }


        /** Add listeners to menu items.
        * @param items the items
        */
        private void addListeners (JMenuItem[] items) {
            int len = items.length;
            for (int i = 0; i < len; i++) {
                items[i].addPropertyChangeListener (propL);
            }
        }

        /** Remove all listeners from menu items.
        * @param items the items
        */
        private void removeListeners (JMenuItem[] items) {
            int len = items.length;
            for (int i = 0; i < len; i++) {
                items[i].removePropertyChangeListener (propL);
            }
        }
        
        boolean needsChange = false;        

        public void addNotify() {
            if (needsChange) {
                changeMenuItems (createMenu());
                needsChange = false;
            }
            super.addNotify();
        }

        public void removeNotify() {
            removeListeners (last);
            last = NONE;
        }


        /** Property listnener to watch changes of enable state.
        */
        private class PropL implements PropertyChangeListener {
            public void propertyChange (PropertyChangeEvent ev) {
                String name = ev.getPropertyName ();
                if (
                    name == null ||
                    name.equals (SystemAction.PROP_ENABLED) ||
                    name.equals (Registry.PROP_ACTIVATED_NODES)
                    ) {
                    // change items later
                    needsChange = true;
                }
            }
        }
        
    } // end: class Menu
    
}
