/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.core;

import java.io.IOException;

import org.openide.loaders.*;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.actions.*;
import org.openide.util.actions.SystemAction;
import org.openide.util.*;

import org.netbeans.modules.xml.core.actions.CollectDTDAction;
import org.netbeans.modules.xml.core.actions.XMLUpdateDocumentAction;

/** Data loader which recognizes DTD files.
 * This class is final only for performance reasons,
 * can be unfinaled if desired.
 *
 * @author Libor Kramolis
 */
public final class DTDDataLoader extends UniFileLoader {

    /** Serial Version UID */
    private static final long serialVersionUID = 1954391380343387000L;

    /** */
    private static final String DTD_EXT = "dtd"; // NOI18N
    private static final String MOD_EXT = "mod"; // NOI18N

    /** Creates new DTDDataLoader */
    public DTDDataLoader() {
        super ("org.netbeans.modules.xml.core.DTDDataObject"); // NOI18N
    }

    /** Does initialization. Initializes display name,
    * extension list and the actions. */
    protected void initialize () {
        super.initialize();
        
        ExtensionList ext = getExtensions();
        ext.addExtension (DTD_EXT);
        ext.addExtension (MOD_EXT);
        ext.addMimeType (DTDDataObject.MIME_TYPE);
        ext.addMimeType ("text/x-dtd"); // NOI18N
        setExtensions (ext);
    }
    
    protected String actionsContext() {
        return "Loaders/text/x-dtd/Actions/";
    }

    /**
     * Lazy init name.
     */
    protected String defaultDisplayName () {
        return Util.THIS.getString ("PROP_DtdLoader_Name");        
    }
    

    /** Creates the right primary entry for given primary file.
     *
     * @param primaryFile primary file recognized by this loader
     * @return primary entry for that file
     */
    protected MultiDataObject.Entry createPrimaryEntry (MultiDataObject obj, FileObject primaryFile) {
        return new XMLDataLoader.XMLFileEntry (obj, primaryFile);  //adds smart templating
    }

    /** Creates the right data object for given primary file.
     * It is guaranteed that the provided file is realy primary file
     * returned from the method findPrimaryFile.
     *
     * @param primaryFile the primary file
     * @return the data object for this file
     * @exception DataObjectExistsException if the primary file already has data object
     */
    protected MultiDataObject createMultiObject (FileObject primaryFile)
    throws DataObjectExistsException, java.io.IOException {
        return new DTDDataObject (primaryFile, this);
    }
}
