/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.api.scenario;

/**
 * <p>
 * A ScenarioFactory creates scenarios of particular type, describes it and 
 * decides if that scenario type should be available for a particular DataObject type.
 * A Scenario implementation is always constructed using a ScenarioFactory.
 * The toString() method of a  ScenarioFactory implementation should return the 
 * name of the scenario type created by this factory. 
 * </p>
 * <p>
 * A ScenarioFactory should be registered in XML layers at the folder,
 * Plugins->XML->ScenarioFactories, like seen below.
 * </p>
 * <pre>
 * &lt;folder name="Plugins"&gt;
 *     &lt;folder name="XML"&gt;
 *         &lt;folder name="ScenarioFactories"&gt;
 *             &lt;file name="org-netbeans-modules-xsl-scenario-FileXSLScenarioFactory.instance"/&gt;
 *         &lt;/folder&gt;
 *    &lt;/folder&gt;
 * &lt;/folder&gt;
 * </pre>
 *
 * @author  asgeir@dimonsoftware.com
 * @deprecated Experimantal SPI
 */
public interface ScenarioFactory {
    
    /**
     * Creates a new scenario using this Factory.
     * @return a newly constructed Scenario.
     */
    Scenario createScenario();
    
    /**
     * Get the name of the scenario type created by this Factory.
     * @return The name of the scenario type created by this Factory.
     */
    String getName();  //getDisplayName()
    
    /**
     * Get a more detailed describtion of the scenario type created by this factory.
     * @return The describtion of the scenario type created by this factory.
     */
    String getDescription();
    
    /**
     * Decides if the scenario type created by this factory is allowed
     * for this DataObject
     * @param dataObject The DataObject which should be tested for this Factory.
     * @return true if this factory should be allowed for that DataObject.
     */
    boolean isEnabled(org.openide.loaders.DataObject dataObject);

    /** @link dependency 
     * @label creates*/
    /*#Scenario lnkScenario;*/
}
