/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.xml.axi.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.xml.axi.AXIComponent;

/**
 * The preview class encapsulates a collection of global elements,
 * used by other global elements.
 *
 * @author Ayub Khan
 */
public class Preview {
    
    Map<AXIComponent, java.util.List<AXIComponent>> pmap =
            new HashMap<AXIComponent, java.util.List<AXIComponent>>();
    Map<AXIComponent, java.util.List<AXIComponent>> reversemap =
            new HashMap<AXIComponent, java.util.List<AXIComponent>>();
    
    /** Creates a new instance of Preview */
    public Preview() {
    }
    
    /**
     * Returns a collection of schema components, all of which,
     * reference the same global schema component.
     */
    public Map<AXIComponent, java.util.List<AXIComponent>> getUsages() {
        return pmap;
    }
    
    /**
     * Returns a collection of schema components, all of which,
     * reference the same global schema component.
     */
    public Map<AXIComponent, java.util.List<AXIComponent>> getReverseUsages() {
        return reversemap;
    }
    
    void addToUsage(AXIComponent c, AXIComponent usedBy) {
        java.util.List<AXIComponent> l = pmap.get(c);
        if(l == null) {
            l = new ArrayList<AXIComponent>();
            pmap.put(c, l);
        }
        l.add(usedBy);
        
        addToReverseUsage(c, usedBy);
    }
    
    void addToReverseUsage(AXIComponent c, AXIComponent usedBy) {
        java.util.List<AXIComponent> r = reversemap.get(usedBy);
        if(r == null) {
            r = new ArrayList<AXIComponent>();
            reversemap.put(usedBy, r);
        }
        r.add(c);
    }
}
