/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.xml.axi.impl;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;

/**
 *
 * @author Samaresh (Samaresh.Panda@Sun.Com)
 */
public class OtherAXIModelListener implements ComponentListener {
        
    /**
     * Creates a new instance of AXIModelListener
     */
    public OtherAXIModelListener(AXIModelImpl model) {
        this.model = model;
    }
        
    public void valueChanged(ComponentEvent event) {
        eventReceived(event);
    }
    
    public void childrenDeleted(ComponentEvent event) {
        eventReceived(event);
    }
    
    public void childrenAdded(ComponentEvent event) {
        eventReceived(event);
    }
    
    /**
     * Some events received.
     */
    private void eventReceived(ComponentEvent event) {
        assert(model != null);
        events.add(event);
        ((ModelAccessImpl)model.getAccess()).setDirty();
    }
    
    /**
     * Returns true if the event pool is not empty,
     * false otherwise.
     */
    boolean needsSync() {
        return !events.isEmpty();
    }
    
    void syncCompleted() {
        events.clear();
    }
    
    private List<ComponentEvent> events = new ArrayList<ComponentEvent>();
    private AXIModelImpl model;
}
