/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext.policy;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import javax.swing.text.Document;
import junit.framework.*;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.addressing.EndpointReference;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.impl.WSDLModelImpl;

/**
 *
 * @author Martin Grebac
 */
public class PolicyTest extends TestCase {
    private final static String TEST_WSDL = "resources/SecureReliableRequestReply.xml";
    
    public PolicyTest(String testName) {
        super(testName);
    }
    
    protected void setUp() throws Exception {
    }
    
    protected void tearDown() throws Exception {
    }
    
    private WSDLModel getModel(){
        WSDLModel model = null;
       
        try{
             Document doc = this.getResourceAsDocument(TEST_WSDL);
             model = new WSDLModelImpl(doc);
             model.sync();
        } catch(Exception e){
            System.out.println("Exception class: " + e.getClass().getName());
            System.out.println("Unable to load model: " + e.getMessage());
        }
        return model;
    }
    
    public void testWrite() throws Exception {
        WSDLModel model = getModel();
        model.startTransaction();
        Definitions d = model.getDefinitions();
        System.out.println("definitions: " + d);
        WSDLComponentFactory fact = d.getWSDLModel().getFactory();

        List<Policy> extPElems = d.getExtensibilityElements(Policy.class);
        for (Policy p : extPElems) {
            System.out.println(p);
            p.getWSDLModel().getFactory();
        }

        Policy policy = fact.create(d, PolicyQName.POLICY.getQName(), Policy.class);
        policy.setID("111");
        All all = fact.create(policy, PolicyQName.ALL.getQName(), All.class);
        policy.setAll(all);
        d.addExtensibilityElement(policy);
 
        model.endTransaction();

        File f = dumpToTempFile(model.getBaseDocument());
        System.out.println("file: " + f.getAbsolutePath());
        
        Collection<Binding> bindings = d.getBindings();
        for (Binding b : bindings) {
            List<PolicyReference> extElems = b.getExtensibilityElements(PolicyReference.class);
            for (PolicyReference pr : extElems) {
                System.out.println(pr.getPolicyURI());
            }
            List<EndpointReference> extAElems = b.getExtensibilityElements(EndpointReference.class);
            for (EndpointReference p : extAElems) {
                System.out.println(p);
            }
        }
        
        //set global customizations
//        DefinitionsCustomization dc =
//                fact.create(d, JAXWSQName.BINDINGS.getQName(), DefinitionsCustomization.class);
//        EnableWrapperStyle ews = fact.create(dc, JAXWSQName.ENABLEWRAPPERSTYLE.getQName(),
//                EnableWrapperStyle.class);
//        ews.setEnabled(true);
//        EnableAsyncMapping eam = fact.create(dc, JAXWSQName.ENABLEASYNCMAPPING.getQName(),
//                EnableAsyncMapping.class);
//        eam.setEnabled(false);
//        dc.setEnableWrapperStyle(ews);
//        dc.setEnableAsyncMapping(eam);
//        d.addExtensibilityElement(dc);
        
//        set PortType customizations
//        Collection<PortType> portTypes = d.getPortTypes();
//        for(PortType p : portTypes){
//            if(p.getName().equals("AddNumbersImpl")){
//                PortTypeCustomization pc =
//                        fact.create(p, JAXWSQName.BINDINGS.getQName(), PortTypeCustomization.class);
//                JavaClass jc = fact.create(pc, JAXWSQName.CLASS.getQName(), JavaClass.class);
//                jc.setName("MathUtil");
//                pc.setJavaClass(jc);
//                ews = fact.create(dc, JAXWSQName.ENABLEWRAPPERSTYLE.getQName(), EnableWrapperStyle.class);
//                ews.setEnabled(true);
//                pc.setEnableWrapperStyle(ews);
//                eam = fact.create(dc, JAXWSQName.ENABLEASYNCMAPPING.getQName(),
//                        EnableAsyncMapping.class);
//                eam.setEnabled(false);
//                pc.setEnableAsyncMapping(eam);
//                p.addExtensibilityElement(pc);
//                
//                //set PortTypeOperation customizations
//                Collection<Operation> ops = p.getOperations();
//                for(Operation op : ops){
//                    if(op.getName().equals("addNumbers")){
//                        PortTypeOperationCustomization ptoc =
//                                fact.create(op, JAXWSQName.BINDINGS.getQName(),
//                                PortTypeOperationCustomization.class);
//                        
//                        //Customize method name
//                        JavaMethod javaMethod = fact.create(ptoc,
//                                JAXWSQName.METHOD.getQName(), JavaMethod.class);
//                        javaMethod.setName("add");
//                        ptoc.setJavaMethod(javaMethod);
//                        //Customize parameters using hard coded values
//                        JavaParameter parm1 = fact.create(ptoc,
//                                JAXWSQName.PARAMETER.getQName(), JavaParameter.class);
//                        parm1.setPart("wsdl:definitions/wsdl:message[@name='addNumbers']/wsdl:part[@name='parameters']");
//                        parm1.setChildElementName("tns:number1");
//                        parm1.setName("num1");
//                        ptoc.addJavaParameter(parm1);
//                        
//                        JavaParameter parm2 = fact.create(ptoc,
//                                JAXWSQName.PARAMETER.getQName(), JavaParameter.class);
//                        parm2.setPart("wsdl:definitions/wsdl:message[@name='addNumbers']/wsdl:part[@name='parameters']");
//                        parm2.setChildElementName("tns:number2");
//                        parm2.setName("num2");
//                        ptoc.addJavaParameter(parm2);
//                        //end of hard coded values
//                        
//                        ews = fact.create(ptoc,
//                                JAXWSQName.ENABLEWRAPPERSTYLE.getQName(), EnableWrapperStyle.class);
//                        ews.setEnabled(true);
//                        ptoc.setEnableWrapperStyle(ews);
//                        eam = fact.create(ptoc,
//                                JAXWSQName.ENABLEASYNCMAPPING.getQName(), EnableAsyncMapping.class);
//                        ptoc.setEnableAsyncMapping(eam);
//                        eam.setEnabled(false);
//                        op.addExtensibilityElement(ptoc);
//                        
//                        //Customize the faults
//                        Collection<Fault> faults = op.getFaults();
//                        for(Fault fault : faults){
//                            if(fault.getName().equals("AddNumbersException")){
//                                PortTypeOperationFaultCustomization ptofc =
//                                        fact.create(fault, JAXWSQName.BINDINGS.getQName(), PortTypeOperationFaultCustomization.class);
//                                jc = fact.create(ptofc, JAXWSQName.CLASS.getQName(), JavaClass.class);
//                                jc.setName("MathUtilException");
//                                ptofc.setJavaClass(jc);
//                                fault.addExtensibilityElement(ptofc);
//                            }
//                        }
//                    }
//                }
//            }
//        }
//        
//        //Customize the service
//        Collection<Service> services = d.getServices();
//        for(Service service : services){
//            if(service.getName().equals("AddNumbersService")){
//                ServiceCustomization sc = fact.create(service, JAXWSQName.BINDINGS.getQName(), ServiceCustomization.class);
//                JavaClass jc = fact.create(sc, JAXWSQName.CLASS.getQName(), JavaClass.class);
//                jc.setName("MathUtilService");
//                sc.setJavaClass(jc);
//                service.addExtensibilityElement(sc);
//                
//                //Customize the port
//                Collection<Port> ports = service.getPorts();
//                for(Port port : ports){
//                    if(port.getName().equals("AddNumbersPort")){
//                        PortCustomization poc = fact.create(port, JAXWSQName.BINDINGS.getQName(), PortCustomization.class);
//                        JavaMethod jmethod = fact.create(poc, JAXWSQName.METHOD.getQName(), JavaMethod.class);
//                        jmethod.setName("getMathUtil");
//                        poc.setJavaMethod(jmethod);
//                        port.addExtensibilityElement(poc);
//                    }
//                }
//            }
//        }
//        model.endTransaction();
//        
//        File f = dumpToTempFile(model.getBaseDocument());
//        System.out.println("file: " +f.getAbsolutePath());
//        
//        //now read it back
//        
//        List<DefinitionsCustomization> dces = d.getExtensibilityElements(DefinitionsCustomization.class);
//        System.out.println("###number of DefinitionsCustomizations: " + dces.size());
//        
//        Collection<PortType> pts = d.getPortTypes();
//        for(PortType portType : pts){
//            if(portType.getName().equals("AddNumbersImpl")) {
//                List<PortTypeCustomization> ptcs = portType.getExtensibilityElements(PortTypeCustomization.class);
//                System.out.println("####number of PortTypeCustomizations: " + ptcs.size());
//                for(PortTypeCustomization ptc : ptcs){
//                    JavaClass jc = ptc.getJavaClass();
//                    if(jc != null){
//                        System.out.println("Class name:  "       + jc.getName());
//                    }
//                }
//            }
//        }
//        
//        Collection<Binding> bindings = d.getBindings();
//        for(Binding binding : bindings){
//            if(binding.getName().equals("AddNumbersImplBinding")){
//                List<BindingCustomization> bcs = binding.getExtensibilityElements(BindingCustomization.class);
//                System.out.println("####Number of BindingCustomizations: " + bcs.size());
//            }
//        }
    }
    
    public static Document getResourceAsDocument(String path) throws Exception {
        InputStream in = PolicyTest.class.getResourceAsStream(path);
        return loadDocument(in);
    }
    
    public static Document loadDocument(InputStream in) throws Exception {
	Document sd = new org.netbeans.editor.BaseDocument(
            org.netbeans.modules.xml.text.syntax.XMLKit.class, false);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuffer sbuf = new StringBuffer();
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                sbuf.append(line);
                sbuf.append(System.getProperty("line.separator"));
            }
        } finally {
            br.close();
        }
        sd.insertString(0,sbuf.toString(),null);
        return sd;
    }
    
    public static void dumpToFile(Document doc, File f) throws Exception {
        if (! f.exists()) {
            f.createNewFile();
        }
        OutputStream out = new BufferedOutputStream(new FileOutputStream(f));
        PrintWriter w = new PrintWriter(out);
        w.print(doc.getText(0, doc.getLength()));
        w.close();
        out.close();
    }
    
    public static File dumpToTempFile(Document doc) throws Exception {
        File f = File.createTempFile("xsm", "xsd");
        dumpToFile(doc, f);
        return f;
    }
    
    
    // TODO add test methods here. The name must begin with 'test'. For example:
    // public void testHello() {}
    
}
