/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.wsdlmodelext.rm;

import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.rm.impl.*;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.spi.ElementFactory;
import org.w3c.dom.Element;

import javax.xml.namespace.QName;
import java.util.Collections;
import java.util.Set;

public class RMFactories {

    public static class RMAssertionFactory extends ElementFactory {
        public Set<QName> getElementQNames() {
            return Collections.singleton(RMQName.RMASSERTION.getQName());
        }
        public <C extends WSDLComponent> C create(WSDLComponent context, Class<C> type) {
            return type.cast(new RMAssertionImpl(context.getModel()));
        }
        public WSDLComponent create(WSDLComponent context, Element element) {
            return new RMAssertionImpl(context.getModel(), element);
        }
    }

    public static class AcknowledgementIntervalFactory extends ElementFactory {
        public Set<QName> getElementQNames() {
            return Collections.singleton(RMQName.ACKNOWLEDGEMENTINTERVAL.getQName());
        }
        public <C extends WSDLComponent> C create(WSDLComponent context, Class<C> type) {
            return type.cast(new AcknowledgementIntervalImpl(context.getModel()));
        }
        public WSDLComponent create(WSDLComponent context, Element element) {
            return new AcknowledgementIntervalImpl(context.getModel(), element);
        }
    }

    public static class BaseRetransmissionIntervalFactory extends ElementFactory {
        public Set<QName> getElementQNames() {
            return Collections.singleton(RMQName.BASERETRANSMISSIONINTERVAL.getQName());
        }
        public <C extends WSDLComponent> C create(WSDLComponent context, Class<C> type) {
            return type.cast(new BaseRetransmissionIntervalImpl(context.getModel()));
        }
        public WSDLComponent create(WSDLComponent context, Element element) {
            return new BaseRetransmissionIntervalImpl(context.getModel(), element);
        }
    }

    public static class ExponentialBackoffFactory extends ElementFactory {
        public Set<QName> getElementQNames() {
            return Collections.singleton(RMQName.EXPONENTIALBACKOFF.getQName());
        }
        public <C extends WSDLComponent> C create(WSDLComponent context, Class<C> type) {
            return type.cast(new ExponentialBackoffImpl(context.getModel()));
        }
        public WSDLComponent create(WSDLComponent context, Element element) {
            return new ExponentialBackoffImpl(context.getModel(), element);
        }
    }

    public static class InactivityTimeoutFactory extends ElementFactory {
        public Set<QName> getElementQNames() {
            return Collections.singleton(RMQName.INACTIVITYTIMEOUT.getQName());
        }
        public <C extends WSDLComponent> C create(WSDLComponent context, Class<C> type) {
            return type.cast(new InactivityTimeoutImpl(context.getModel()));
        }
        public WSDLComponent create(WSDLComponent context, Element element) {
            return new InactivityTimeoutImpl(context.getModel(), element);
        }
    }
    
}