/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import org.netbeans.modules.websvc.wsitconf.Utilities;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.mtom.*;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.policy.All;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.policy.ExactlyOne;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.policy.Policy;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;

import java.io.IOException;
import java.util.List;
import org.openide.ErrorManager;

/**
 *
 * @author Martin Grebac
 */
public class MtomModelHelper {
    
    /**
     * Creates a new instance of MtomModelHelper
     */
    public MtomModelHelper() {
    }
    
    public static OptimizedMimeSerialization getOptimizedMimeSerialization(Policy p) {
        OptimizedMimeSerialization mtomAssertion = null;
        if (p != null) {
            ExactlyOne eo = p.getExactlyOne();
            if (eo != null) {
                All all = eo.getAll();
                if (all != null) {
                    List<OptimizedMimeSerialization> assertions = 
                            all.getExtensibilityElements(OptimizedMimeSerialization.class);
                    if ((assertions != null) && (!assertions.isEmpty())) {
                        mtomAssertion = assertions.get(0);
                    }
                }
            }
        }
        return mtomAssertion;
    }
    
    // checks if Mtom is enabled in the config wsdl on specified binding
    public static boolean isMtomEnabled(Binding b, WSDLModel model) {
        Policy p = Utilities.getPolicyForElement(b, model);
        if (p != null) {
            OptimizedMimeSerialization mtomAssertion = getOptimizedMimeSerialization(p);
            return (mtomAssertion != null);
        }
        return false;
    }
    
    // enables Mtom in the config wsdl on specified binding
    public static void enableMtom(Binding b, WSDLModel model) {
        Policy p = Utilities.getPolicyForElement(b, model);
        OptimizedMimeSerialization mtom = getOptimizedMimeSerialization(p);
        if (mtom == null) {
            boolean isTransaction = model.isIntransaction();
            if (!isTransaction) {
                model.startTransaction();
            }
            try {
                WSDLComponentFactory wcf = model.getFactory();

                All all = null;
                if (p == null) {
                    all = PolicyModelHelper.createTopLevelPolicy(b, model, wcf);
                } else {
                    all = PolicyModelHelper.createTopExactlyOne(p, model, wcf);
                }

                mtom = (OptimizedMimeSerialization)wcf.create(all, MtomQName.OPTIMIZEDMIMESERIALIZATION.getQName());
                all.addExtensibilityElement(mtom);
            } finally {
                if (!isTransaction) {
                        model.endTransaction();
                }
            }
        }
    }

    // disables Mtom in the config wsdl on specified binding
    public static void disableMtom(Binding b, WSDLModel model) {
        Policy p = Utilities.getPolicyForElement(b, model);
        OptimizedMimeSerialization mtom = getOptimizedMimeSerialization(p);
        if (mtom != null) {
            boolean isTransaction = model.isIntransaction();
            if (!isTransaction) {
                model.startTransaction();
            }
            try {
                mtom.getParent().removeExtensibilityElement(mtom);
            } finally {
                if (!isTransaction) {
                        model.endTransaction();
                }
            }
        }
    }
}
