/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import org.netbeans.modules.websvc.wsitconf.Utilities;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.encoding.*;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.policy.All;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.policy.ExactlyOne;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.policy.Policy;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;

import java.io.IOException;
import java.util.List;

/**
 *
 * @author Martin Grebac
 */
public class EncodingModelHelper {
    
    /**
     * Creates a new instance of EncodingModelHelper
     */
    public EncodingModelHelper() {
    }
    
    public static Utf816FFFECharacterEncoding getUtf816FFFECharacterEncoding(Policy p) {
        Utf816FFFECharacterEncoding encAssertion = null;
        if (p != null) {
            ExactlyOne eo = p.getExactlyOne();
            if (eo != null) {
                All all = eo.getAll();
                if (all != null) {
                    List<Utf816FFFECharacterEncoding> assertions = 
                            all.getExtensibilityElements(Utf816FFFECharacterEncoding.class);
                    if ((assertions != null) && (!assertions.isEmpty())) {
                        encAssertion = assertions.get(0);
                    }
                }
            }
        }
        return encAssertion;
    }
    
    // checks if Mtom is enabled in the config wsdl on specified binding
    public static boolean isMtomEnabled(Binding b, WSDLModel model) {
        Policy p = Utilities.getPolicyForElement(b, model);
        if (p != null) {
            Utf816FFFECharacterEncoding encAssertion = getUtf816FFFECharacterEncoding(p);
            return (encAssertion != null);
        }
        return false;
    }
    
    // enables Mtom in the config wsdl on specified binding
    public static void enableMtom(Binding b, WSDLModel model) {
        Policy p = Utilities.getPolicyForElement(b, model);
        Utf816FFFECharacterEncoding encoding = getUtf816FFFECharacterEncoding(p);
        if (encoding == null) {
            model.startTransaction();
            WSDLComponentFactory wcf = model.getFactory();

            All all = null;
            if (p == null) {
                all = PolicyModelHelper.createTopLevelPolicy(b, model, wcf);
            } else {
                all = PolicyModelHelper.createTopExactlyOne(p, model, wcf);
            }
            
            encoding = (Utf816FFFECharacterEncoding)wcf.create(all, 
                    EncodingQName.UTF816FFFECHARACTERENCODING.getQName());
            all.addExtensibilityElement(encoding);
                model.endTransaction();
        }
    }

    // disables Mtom in the config wsdl on specified binding
    public static void disableMtom(Binding b, WSDLModel model) {
        Policy p = Utilities.getPolicyForElement(b, model);
        Utf816FFFECharacterEncoding mtom = getUtf816FFFECharacterEncoding(p);
        if (mtom == null) {
            model.startTransaction();
            mtom.getParent().removeExtensibilityElement(mtom);
                model.endTransaction();
        }
    }
}
