/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security.symmetric.tokens;

import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RequireDerivedKeys;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RequireEmbeddedTokenReference;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RequireIssuerSerialReference;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RequireKeyIdentifierReference;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RequireThumbprintReference;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.NbBundle;

/**
 *
 * @author  Martin Grebac
 */
public class X509Panel extends javax.swing.JPanel {
    
    public static final String X509_V110 = NbBundle.getMessage(X509Panel.class, "COMBO_X509_V110");
    public static final String X509_V310 = NbBundle.getMessage(X509Panel.class, "COMBO_X509_V310");
    public static final String X509_PKCS710 = NbBundle.getMessage(X509Panel.class, "COMBO_X509_PKCS710");
    public static final String X509_PKIPATHV110 = NbBundle.getMessage(X509Panel.class, "COMBO_X509_PKIPATHV110");
    public static final String X509_V111 = NbBundle.getMessage(X509Panel.class, "COMBO_X509_V111");
    public static final String X509_V311 = NbBundle.getMessage(X509Panel.class, "COMBO_X509_V311");
    public static final String X509_PKCS711 = NbBundle.getMessage(X509Panel.class, "COMBO_X509_PKCS711");
    public static final String X509_PKIPATHV111 = NbBundle.getMessage(X509Panel.class, "COMBO_X509_PKIPATHV111");

    private boolean inSync = false;

    private WSDLComponent tokenType;
    private WSDLModel model;
    
    /**
     * Creates new form X509Panel
     */
    public X509Panel(WSDLModel m, WSDLComponent tokenType) {
        super();
        initComponents();
        this.model = m;
        this.tokenType = tokenType;
        
        inclusionLevelLabel.setText(NbBundle.getMessage(X509Panel.class, "LBL_InclusionLevel"));
        x509VersionLabel.setText(NbBundle.getMessage(X509Panel.class, "LBL_X509_VersionLabel"));
        requireDerivedKeysChBox.setText(NbBundle.getMessage(X509Panel.class, "LBL_RequireDerivedKeys"));
        requireKeyIdentifierChBox.setText(NbBundle.getMessage(X509Panel.class, "LBL_RequireKeyIdentifier"));
        requireIssueSerialChBox.setText(NbBundle.getMessage(X509Panel.class, "LBL_RequireIssuerSerial"));
        requireEmbeddedTokenReference.setText(NbBundle.getMessage(X509Panel.class, "LBL_RequireEmbeddedToken"));
        requireThumbprintReference.setText(NbBundle.getMessage(X509Panel.class, "LBL_RequireThumbprintReference"));

        inclusionLevelLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        inclusionLevelCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        x509VersionLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        x509VersionCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireDerivedKeysChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireEmbeddedTokenReference.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireIssueSerialChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireKeyIdentifierChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireThumbprintReference.setBackground(SectionVisualTheme.getDocumentBackgroundColor());

        
        inSync = true;
        inclusionLevelCombo.addItem(UsernamePanel.NONE);
        inclusionLevelCombo.addItem(UsernamePanel.NEVER);
//        inclusionLevelCombo.addItem(UsernamePanel.ONCE);
        inclusionLevelCombo.addItem(UsernamePanel.ALWAYSRECIPIENT);
        inclusionLevelCombo.addItem(UsernamePanel.ALWAYS);

        x509VersionCombo.addItem(UsernamePanel.NONE);
        x509VersionCombo.addItem(X509_V110);
        x509VersionCombo.addItem(X509_V310);
//        x509VersionCombo.addItem(X509_PKCS710);
//        x509VersionCombo.addItem(X509_PKIPATHV110);
        x509VersionCombo.addItem(X509_V111);
        x509VersionCombo.addItem(X509_V311);
//        x509VersionCombo.addItem(X509_PKCS711);
//        x509VersionCombo.addItem(X509_PKIPATHV111);
        inSync = false;
        
        sync();
    }
    
    private void sync() {
        inSync = true;

        setInclusionLevel(SecurityTokensModelHelper.getTokenInclusionLevel(tokenType));
        setProfileVersion(SecurityTokensModelHelper.getTokenProfileVersion(tokenType));
        setRequireDerivedKeys(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireDerivedKeys.class));
        setRequireKeyIdentifier(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireKeyIdentifierReference.class));
        setRequireIssuerSerial(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireIssuerSerialReference.class));
        setRequireEmbeddedToken(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireEmbeddedTokenReference.class));
        setRequireThumbprint(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireThumbprintReference.class));

        inSync = false;
    }

    public void setValue(javax.swing.JComponent source, Object value) {

        if (!inSync) {
            if (source.equals(inclusionLevelCombo)) {
                SecurityTokensModelHelper.setTokenInclusionLevel(tokenType, (String)inclusionLevelCombo.getSelectedItem());
//                setter.setDirty();
                return;
            }

            if (source.equals(x509VersionCombo)) {
                SecurityTokensModelHelper.setTokenProfileVersion(tokenType, (String)x509VersionCombo.getSelectedItem());
//                setter.setDirty();
                return;
            }

            if (source.equals(requireDerivedKeysChBox)) {
                boolean enable = requireDerivedKeysChBox.isSelected();
                if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireDerivedKeys.class) != enable) {
                    SecurityPolicyModelHelper.enableRequireDerivedKeys(tokenType, enable);
//                    setter.setDirty();
                }
                return;
            }

            if (source.equals(requireKeyIdentifierChBox)) {
                boolean enable = requireKeyIdentifierChBox.isSelected();
                if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireKeyIdentifierReference.class) != enable) {
                    SecurityPolicyModelHelper.enableRequireKeyIdentifierReference(tokenType, enable);
//                    setter.setDirty();
                }
                return;
            }

            if (source.equals(requireIssueSerialChBox)) {
                boolean enable = requireIssueSerialChBox.isSelected();
                if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireIssuerSerialReference.class) != enable) {
                    SecurityPolicyModelHelper.enableRequireIssuerSerialReference(tokenType, enable);
//                    setter.setDirty();
                }
                return;
            }

            if (source.equals(requireEmbeddedTokenReference)) {
                boolean enable = requireEmbeddedTokenReference.isSelected();
                if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireEmbeddedTokenReference.class) != enable) {
                    SecurityPolicyModelHelper.enableRequireEmbeddedTokenReference(tokenType, enable);
//                    setter.setDirty();
                }
                return;
            }

            if (source.equals(requireThumbprintReference)) {
                boolean enable = requireThumbprintReference.isSelected();
                if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireThumbprintReference.class) != enable) {
                    SecurityPolicyModelHelper.enableRequireThumbprintReference(tokenType, enable);
//                    setter.setDirty();
                }
                return;
            }
        }
    }
    
    private void setInclusionLevel(String item) {
        if (item == null) {
            this.inclusionLevelCombo.setSelectedIndex(0);
        } else {
            inclusionLevelCombo.setSelectedItem(item);
        }
    }

    private void setRequireDerivedKeys(Boolean enable) {
        if (enable == null) {
            this.requireDerivedKeysChBox.setSelected(false);
        } else {
            this.requireDerivedKeysChBox.setSelected(enable);
        }
    }
    
    private void setRequireKeyIdentifier(Boolean enable) {
        if (enable == null) {
            this.requireKeyIdentifierChBox.setSelected(false);
        } else {
            this.requireKeyIdentifierChBox.setSelected(enable);
        }
    }
    
    private void setRequireEmbeddedToken(Boolean enable) {
        if (enable == null) {
            this.requireEmbeddedTokenReference.setSelected(false);
        } else {
            this.requireEmbeddedTokenReference.setSelected(enable);
        }
    }

    private void setRequireIssuerSerial(Boolean enable) {
        if (enable == null) {
            this.requireIssueSerialChBox.setSelected(false);
        } else {
            this.requireIssueSerialChBox.setSelected(enable);
        }
    }
    
    private void setRequireThumbprint(Boolean enable) {
        if (enable == null) {
            this.requireThumbprintReference.setSelected(false);
        } else {
            this.requireThumbprintReference.setSelected(enable);
        }
    }

    private void setProfileVersion(String item) {
        if (item == null) {
            this.x509VersionCombo.setSelectedIndex(0);
        } else {
            x509VersionCombo.setSelectedItem(item);
        }
    }
    
    public WSDLComponent getTokenType() {
        return tokenType;
    }

    public void setTokenType(WSDLComponent tokenType) {
        this.tokenType = tokenType;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        inclusionLevelLabel = new javax.swing.JLabel();
        inclusionLevelCombo = new javax.swing.JComboBox();
        x509VersionLabel = new javax.swing.JLabel();
        x509VersionCombo = new javax.swing.JComboBox();
        requireKeyIdentifierChBox = new javax.swing.JCheckBox();
        requireIssueSerialChBox = new javax.swing.JCheckBox();
        requireEmbeddedTokenReference = new javax.swing.JCheckBox();
        requireThumbprintReference = new javax.swing.JCheckBox();
        requireDerivedKeysChBox = new javax.swing.JCheckBox();

        inclusionLevelLabel.setText("Inclusion level:");

        inclusionLevelCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                inclusionLevelComboActionPerformed(evt);
            }
        });

        x509VersionLabel.setText("X509 Version:");

        x509VersionCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                x509VersionComboActionPerformed(evt);
            }
        });

        requireKeyIdentifierChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireKeyIdentifierChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireKeyIdentifierChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireKeyIdentifierChBoxActionPerformed(evt);
            }
        });

        requireIssueSerialChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireIssueSerialChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireIssueSerialChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireIssueSerialChBoxActionPerformed(evt);
            }
        });

        requireEmbeddedTokenReference.setText("txt");
        requireEmbeddedTokenReference.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireEmbeddedTokenReference.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireEmbeddedTokenReference.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireEmbeddedTokenReferenceActionPerformed(evt);
            }
        });

        requireThumbprintReference.setText("txt");
        requireThumbprintReference.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireThumbprintReference.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireThumbprintReference.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireThumbprintReferenceActionPerformed(evt);
            }
        });

        requireDerivedKeysChBox.setText("Require Derived Keys");
        requireDerivedKeysChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireDerivedKeysChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireDerivedKeysChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireDerivedKeysChBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                        .add(layout.createSequentialGroup()
                            .add(inclusionLevelLabel)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(inclusionLevelCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(layout.createSequentialGroup()
                            .add(x509VersionLabel)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(x509VersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(requireKeyIdentifierChBox)
                    .add(requireIssueSerialChBox)
                    .add(requireEmbeddedTokenReference)
                    .add(requireThumbprintReference)
                    .add(requireDerivedKeysChBox))
                .addContainerGap(373, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {inclusionLevelCombo, x509VersionCombo}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(inclusionLevelLabel)
                    .add(inclusionLevelCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(x509VersionLabel)
                    .add(x509VersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireDerivedKeysChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireKeyIdentifierChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireIssueSerialChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireEmbeddedTokenReference)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireThumbprintReference)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void requireDerivedKeysChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireDerivedKeysChBoxActionPerformed
        setValue(requireDerivedKeysChBox, null);
    }//GEN-LAST:event_requireDerivedKeysChBoxActionPerformed

    private void requireThumbprintReferenceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireThumbprintReferenceActionPerformed
        setValue(requireThumbprintReference, null);
    }//GEN-LAST:event_requireThumbprintReferenceActionPerformed

    private void requireEmbeddedTokenReferenceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireEmbeddedTokenReferenceActionPerformed
        setValue(requireEmbeddedTokenReference, null);
    }//GEN-LAST:event_requireEmbeddedTokenReferenceActionPerformed

    private void requireIssueSerialChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireIssueSerialChBoxActionPerformed
        setValue(requireIssueSerialChBox, null);
    }//GEN-LAST:event_requireIssueSerialChBoxActionPerformed

    private void requireKeyIdentifierChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireKeyIdentifierChBoxActionPerformed
        setValue(requireKeyIdentifierChBox, null);
    }//GEN-LAST:event_requireKeyIdentifierChBoxActionPerformed

    private void x509VersionComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_x509VersionComboActionPerformed
        setValue(x509VersionCombo, null);
    }//GEN-LAST:event_x509VersionComboActionPerformed

    private void inclusionLevelComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_inclusionLevelComboActionPerformed
        setValue(inclusionLevelCombo, null);
    }//GEN-LAST:event_inclusionLevelComboActionPerformed
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox inclusionLevelCombo;
    private javax.swing.JLabel inclusionLevelLabel;
    private javax.swing.JCheckBox requireDerivedKeysChBox;
    private javax.swing.JCheckBox requireEmbeddedTokenReference;
    private javax.swing.JCheckBox requireIssueSerialChBox;
    private javax.swing.JCheckBox requireKeyIdentifierChBox;
    private javax.swing.JCheckBox requireThumbprintReference;
    private javax.swing.JComboBox x509VersionCombo;
    private javax.swing.JLabel x509VersionLabel;
    // End of variables declaration//GEN-END:variables
    
}
