/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security.symmetric.tokens;

import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.UsernameToken;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import static org.openide.util.NbBundle.*;

/**
 *
 * @author  Martin Grebac
 */
public class UsernamePanel extends javax.swing.JPanel {

    public static final String NONE = "       ";         //NOI18N
    
    public static final String NEVER = getMessage(UsernamePanel.class, "COMBO_Never");         //NOI18N
    public static final String ONCE = getMessage(UsernamePanel.class, "COMBO_Once");           //NOI18N
    public static final String ALWAYSRECIPIENT = getMessage(UsernamePanel.class, "COMBO_AlwaysToRecipient");       //NOI18N
    public static final String ALWAYS = getMessage(UsernamePanel.class, "COMBO_Always");       //NOI18N

    public static final String NEVER_POLICYSTR = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Never"; //NOI18N
    public static final String ONCE_POLICYSTR = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Once"; //NOI18N
    public static final String ALWAYSRECIPIENT_POLICYSTR = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient"; //NOI18N
    public static final String ALWAYS_POLICYSTR = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Always"; //NOI18N

    public static final String WSS11 = getMessage(UsernamePanel.class, "COMBO_WSS11");         //NOI18N
    public static final String WSS10 = getMessage(UsernamePanel.class, "COMBO_WSS10");         //NOI18N

    private boolean inSync = false;

    private WSDLComponent tokenType;
    private WSDLModel model;

    /**
     * Creates new form UsernamePanel
     */
    public UsernamePanel(WSDLModel m, WSDLComponent tokenType) {
        super();
        this.model = m;
        this.tokenType = tokenType;

        initComponents();

        inclusionLevelLabel.setText(getMessage(UsernamePanel.class, "LBL_InclusionLevel"));     //NOI18N
        wssVersionLabel.setText(getMessage(UsernamePanel.class, "LBL_Username_WSSVersion"));    //NOI18N

        inclusionLevelLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        inclusionLevelCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        wssVersionLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        wssVersionCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());

        inSync = true;
        inclusionLevelCombo.addItem(NONE);
        inclusionLevelCombo.addItem(NEVER);
//        inclusionLevelCombo.addItem(ONCE);
        inclusionLevelCombo.addItem(ALWAYSRECIPIENT);
        inclusionLevelCombo.addItem(ALWAYS);

        wssVersionCombo.addItem(NONE);
        wssVersionCombo.addItem(WSS10);
        wssVersionCombo.addItem(WSS11);
        inSync = false;

        sync();
    }

    private void sync() {
        inSync = true;

        setInclusionLevel(SecurityTokensModelHelper.getTokenInclusionLevel(tokenType));
        setProfileVersion(SecurityTokensModelHelper.getTokenProfileVersion(tokenType));

        inSync = false;
    }

    public void setValue(javax.swing.JComponent source, Object value) {
        if (!inSync) {
            if (source.equals(inclusionLevelCombo)) {
                SecurityTokensModelHelper.setTokenInclusionLevel(tokenType, (String)inclusionLevelCombo.getSelectedItem());
    //            setter.setDirty();
                return;
            }
            if (source.equals(wssVersionCombo)) {
                SecurityTokensModelHelper.setTokenProfileVersion(tokenType, (String)wssVersionCombo.getSelectedItem());
    //            setter.setDirty();
                return;
            }
        }
    }
    
    private void setInclusionLevel(String item) {
        if (item == null) {
            this.inclusionLevelCombo.setSelectedIndex(0);
        } else {
            inclusionLevelCombo.setSelectedItem(item);
        }
    }

    private void setProfileVersion(String item) {
        if (item == null) {
            this.wssVersionCombo.setSelectedIndex(0);
        } else {
            wssVersionCombo.setSelectedItem(item);
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        inclusionLevelLabel = new javax.swing.JLabel();
        inclusionLevelCombo = new javax.swing.JComboBox();
        wssVersionLabel = new javax.swing.JLabel();
        wssVersionCombo = new javax.swing.JComboBox();

        inclusionLevelLabel.setText("Inclusion level:");

        inclusionLevelCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                inclusionLevelComboActionPerformed(evt);
            }
        });

        wssVersionLabel.setText("WSS Version:");

        wssVersionCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                wssVersionComboActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(layout.createSequentialGroup()
                        .add(inclusionLevelLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(inclusionLevelCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .add(wssVersionLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(wssVersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(377, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {inclusionLevelCombo, wssVersionCombo}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(inclusionLevelLabel)
                    .add(inclusionLevelCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(wssVersionLabel)
                    .add(wssVersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void wssVersionComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wssVersionComboActionPerformed
        setValue(wssVersionCombo, null);
    }//GEN-LAST:event_wssVersionComboActionPerformed

    private void inclusionLevelComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_inclusionLevelComboActionPerformed
        setValue(inclusionLevelCombo, null);
    }//GEN-LAST:event_inclusionLevelComboActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox inclusionLevelCombo;
    private javax.swing.JLabel inclusionLevelLabel;
    private javax.swing.JComboBox wssVersionCombo;
    private javax.swing.JLabel wssVersionLabel;
    // End of variables declaration//GEN-END:variables

    public WSDLComponent getTokenType() {
        return tokenType;
    }

    public void setTokenType(WSDLComponent tokenType) {
        this.tokenType = tokenType;
    }
}
