/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security.symmetric.tokens;

import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.EncryptionToken;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.InitiatorToken;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RecipientToken;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.SignatureToken;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.NbBundle;

import java.awt.*;

/**
 *
 * @author  Martin Grebac
 */
public class TokensSymmetricPanel extends javax.swing.JPanel {
    
    public static String USERNAME = NbBundle.getMessage(TokensSymmetricPanel.class, "COMBO_UsernameToken");
    public static String X509 = NbBundle.getMessage(TokensSymmetricPanel.class, "COMBO_X509Token");
    public static String SAML = NbBundle.getMessage(TokensSymmetricPanel.class, "COMBO_SamlToken");
    public static String REL = NbBundle.getMessage(TokensSymmetricPanel.class, "COMBO_RelToken");
    public static String KERBEROS = NbBundle.getMessage(TokensSymmetricPanel.class, "COMBO_KerberosToken");
    public static String SECURITYCONTEXT = NbBundle.getMessage(TokensSymmetricPanel.class, "COMBO_SecurityContextToken");
    public static String SECURECONVERSATION = NbBundle.getMessage(TokensSymmetricPanel.class, "COMBO_SecureConversationToken");
    public static String ISSUED = NbBundle.getMessage(TokensSymmetricPanel.class, "COMBO_IssuedToken");
    public static String SPNEGOCONTEXT = NbBundle.getMessage(TokensSymmetricPanel.class, "COMBO_SpNegoContextToken");

    public static String PROTECTION = "protection";     //NOI18N
    public static String SIGNATURE = "signature";     //NOI18N
    public static String ENCRYPTION = "encryption";     //NOI18N
    public static String INITIATOR = "initiator";     //NOI18N
    public static String RECIPIENT = "recipient";     //NOI18N
    
    private UsernamePanel sigUsernamePanel;
    private UsernamePanel encUsernamePanel;
     
    private X509Panel sigX509Panel;
    private X509Panel encX509Panel;

    private SecurityContextPanel sigSecurityContextPanel;
    private SecurityContextPanel encSecurityContextPanel;

    private KerberosPanel sigKerberosPanel;
    private KerberosPanel encKerberosPanel;

    private RelPanel sigRelPanel;
    private RelPanel encRelPanel;

    private SamlPanel sigSamlPanel;
    private SamlPanel encSamlPanel;

    private SpnegoContextPanel sigSpnegoContextPanel;
    private SpnegoContextPanel encSpnegoContextPanel;

    private SecureConversationPanel sigSecureConversationPanel;
    private SecureConversationPanel encSecureConversationPanel;

    private IssuedPanel sigIssuedPanel;
    private IssuedPanel encIssuedPanel;
    
    private boolean inSync = false;
    
    private WSDLComponent secBinding;
    private WSDLModel model;
    private Binding binding;
    
    private boolean symmetric;
    private boolean isSameToken;
    
    /**
     * Creates new form TokensSymmetricPanel
     */
    public TokensSymmetricPanel(Binding b, WSDLModel model, boolean symmetric, WSDLComponent secBinding) {
        super();
        this.symmetric = symmetric;
        this.secBinding = secBinding;
        this.binding = b;
        this.model = model;
        
        initComponents();

        if (symmetric) {
            signatureTokenLabel.setText(NbBundle.getMessage(TokensSymmetricPanel.class, "LBL_SignatureTokenLabel"));
            encryptionTokenLabel.setText(NbBundle.getMessage(TokensSymmetricPanel.class, "LBL_EncryptionTokenLabel"));
            sameTokenChBox.setText(NbBundle.getMessage(TokensSymmetricPanel.class, "LBL_UseSameToken"));
        } else {
            signatureTokenLabel.setText(NbBundle.getMessage(TokensSymmetricPanel.class, "LBL_InitiatorTokenLabel"));
            encryptionTokenLabel.setText(NbBundle.getMessage(TokensSymmetricPanel.class, "LBL_RecipientTokenLabel"));
            sameTokenChBox.setVisible(false);
        }
        
        Font f = signatureTokenLabel.getFont().deriveFont(Font.BOLD);
        signatureTokenLabel.setFont(f);
        encryptionTokenLabel.setFont(f);

        encryptionTokenCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        encryptionTokenLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        signatureTokenCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        signatureTokenLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        sameTokenChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        encTokenSettingsPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        sigTokenSettingsPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        
        inSync = true;
//        encryptionTokenCombo.addItem(USERNAME);
        encryptionTokenCombo.addItem(X509);
        encryptionTokenCombo.addItem(SAML);
//        encryptionTokenCombo.addItem(REL);
//        encryptionTokenCombo.addItem(KERBEROS);
//        encryptionTokenCombo.addItem(SECURITYCONTEXT);
        encryptionTokenCombo.addItem(SECURECONVERSATION);
        encryptionTokenCombo.addItem(ISSUED);
//        encryptionTokenCombo.addItem(SPNEGOCONTEXT);

//        signatureTokenCombo.addItem(USERNAME);
        signatureTokenCombo.addItem(X509);
        signatureTokenCombo.addItem(SAML);
//        signatureTokenCombo.addItem(REL);
//        signatureTokenCombo.addItem(KERBEROS);
//        signatureTokenCombo.addItem(SECURITYCONTEXT);
        signatureTokenCombo.addItem(SECURECONVERSATION);
        signatureTokenCombo.addItem(ISSUED);
//        signatureTokenCombo.addItem(SPNEGOCONTEXT);
        inSync = false;
        
        sync();
    }

    
    private void sync() {
        inSync = true;
        
        String signatureToken = null;
        String encryptionToken = null;

        WSDLComponent sigTokenKind, encTokenKind;
        WSDLComponent sigTokenType = null, encTokenType = null;
        
        if (symmetric) {
            isSameToken = SecurityTokensModelHelper.isSameToken(getSecBinding());
            setSameToken(isSameToken);
            if (isSameToken) {
                sigTokenKind = SecurityTokensModelHelper.getTokenKindElement(getSecBinding(), ProtectionToken.class);
                encTokenKind = sigTokenKind;

                signatureToken = SecurityTokensModelHelper.getProtectionTokenType(getSecBinding());
                encryptionToken = signatureToken;
            } else {
                sigTokenKind = SecurityTokensModelHelper.getTokenKindElement(getSecBinding(), SignatureToken.class);
                encTokenKind = SecurityTokensModelHelper.getTokenKindElement(getSecBinding(), EncryptionToken.class);
                                
                signatureToken = SecurityTokensModelHelper.getSignatureTokenType(getSecBinding());
                encryptionToken = SecurityTokensModelHelper.getEncryptionTokenType(getSecBinding());
            }
        } else {
            sigTokenKind = SecurityTokensModelHelper.getTokenKindElement(getSecBinding(), InitiatorToken.class);
            encTokenKind = SecurityTokensModelHelper.getTokenKindElement(getSecBinding(), RecipientToken.class);
            
            signatureToken = SecurityTokensModelHelper.getInitiatorTokenType(getSecBinding());
            encryptionToken = SecurityTokensModelHelper.getRecipientTokenType(getSecBinding());
        }
        
        if ((sigTokenKind == null) && (encTokenKind == null)) {
            if (symmetric) {
                sigTokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), PROTECTION, USERNAME);
                encTokenType = sigTokenType;
                sigTokenKind = SecurityTokensModelHelper.getTokenKindElement(getSecBinding(), ProtectionToken.class);
                encTokenKind = sigTokenKind;
                signatureToken = USERNAME;
                encryptionToken = USERNAME;
            } else {
                sigTokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), INITIATOR, USERNAME);
                encTokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), RECIPIENT, USERNAME);
                sigTokenKind = SecurityTokensModelHelper.getTokenKindElement(getSecBinding(), InitiatorToken.class);
                sigTokenKind = SecurityTokensModelHelper.getTokenKindElement(getSecBinding(), RecipientToken.class);
                signatureToken = USERNAME;
                encryptionToken = USERNAME;
            }
        } else {        
            if (sigTokenKind != null) sigTokenType = SecurityTokensModelHelper.getTokenTypeElement(sigTokenKind);
            if (encTokenKind != null) encTokenType = SecurityTokensModelHelper.getTokenTypeElement(encTokenKind);
        }
        
        if (sigTokenType != null) setSignatureToken(signatureToken, sigTokenKind, sigTokenType);
        if (encTokenType != null) setEncryptionToken(encryptionToken, encTokenKind, encTokenType);

        enableDisable();

        inSync = false;
    }

    private void setEncryptionToken(String token, WSDLComponent tokenKind, WSDLComponent tokenType) {
        
        this.encryptionTokenCombo.setSelectedItem(token);
        this.remove(encTokenSettingsPanel);
        
        if (USERNAME.equals(token)) {
            encTokenSettingsPanel = getEncUsernamePanel(tokenType);
            refreshPanels();
            return;
        }
        if (X509.equals(token)) {
            encTokenSettingsPanel = getEncX509Panel(tokenType);
            refreshPanels();
            return;
        }
        if (SAML.equals(token)) {
            encTokenSettingsPanel = getEncSamlPanel(tokenType);
            refreshPanels();
            return;
        }
        if (REL.equals(token)) {
            encTokenSettingsPanel = getEncRelPanel(tokenType);
            refreshPanels();
            return;
        }
        if (KERBEROS.equals(token)) {
            encTokenSettingsPanel = getEncKerberosPanel(tokenType);
            refreshPanels();
            return;
        }
        if (SECURITYCONTEXT.equals(token)) {
            encTokenSettingsPanel = getEncSecurityContextPanel(tokenType);
            refreshPanels();
            return;
        }
        if (SECURECONVERSATION.equals(token)) {
            encTokenSettingsPanel = getEncSecureConversationPanel(tokenType);
            refreshPanels();
            return;
        }
        if (SPNEGOCONTEXT.equals(token)) {
            encTokenSettingsPanel = getEncSpnegoContextPanel(tokenType);
            refreshPanels();
            return;
        }
        if (ISSUED.equals(token)) {
            encTokenSettingsPanel = getEncIssuedPanel(tokenType);
            refreshPanels();
            return;
        }
    }

    private void setSignatureToken(String token, WSDLComponent tokenKind, WSDLComponent tokenType) {
        
        this.signatureTokenCombo.setSelectedItem(token);
        this.remove(sigTokenSettingsPanel);
        
        if (USERNAME.equals(token)) {
            sigTokenSettingsPanel = getSigUsernamePanel(tokenType);
            refreshPanels();
            return;
        }
        if (X509.equals(token)) {
            sigTokenSettingsPanel = getSigX509Panel(tokenType);
            refreshPanels();
            return;
        }
        if (SAML.equals(token)) {
            sigTokenSettingsPanel = getSigSamlPanel(tokenType);
            refreshPanels();
            return;
        }
        if (REL.equals(token)) {
            sigTokenSettingsPanel = getSigRelPanel(tokenType);
            refreshPanels();
            return;
        }
        if (KERBEROS.equals(token)) {
            sigTokenSettingsPanel = getSigKerberosPanel(tokenType);
            refreshPanels();
            return;
        }
        if (SECURITYCONTEXT.equals(token)) {
            sigTokenSettingsPanel = getSigSecurityContextPanel(tokenType);
            refreshPanels();
            return;
        }
        if (SECURECONVERSATION.equals(token)) {
            sigTokenSettingsPanel = getSigSecureConversationPanel(tokenType);
            refreshPanels();
            return;
        }
        if (SPNEGOCONTEXT.equals(token)) {
            sigTokenSettingsPanel = getSigSpnegoContextPanel(tokenType);
            refreshPanels();
            return;
        }
        if (ISSUED.equals(token)) {
            sigTokenSettingsPanel = getSigIssuedPanel(tokenType);
            refreshPanels();
            return;
        }
    }
    
    private void setSameToken(Boolean enable) {
        if (enable == null) {
            this.sameTokenChBox.setSelected(false);
        } else {
            this.sameTokenChBox.setSelected(enable);
        }
    }
    
    private UsernamePanel getEncUsernamePanel(WSDLComponent tokenType) {
        if (this.encUsernamePanel == null) {
            encUsernamePanel =  new UsernamePanel(model, tokenType);
            encUsernamePanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        encUsernamePanel.setTokenType(tokenType);
        return encUsernamePanel;
    }

    private UsernamePanel getSigUsernamePanel(WSDLComponent tokenType) {
        if (this.sigUsernamePanel == null) {
            sigUsernamePanel =  new UsernamePanel(model, tokenType);
            sigUsernamePanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        sigUsernamePanel.setTokenType(tokenType);
        return sigUsernamePanel;
    }

    private X509Panel getSigX509Panel(WSDLComponent tokenType) {
        if (this.sigX509Panel == null) {
            sigX509Panel =  new X509Panel(model, tokenType);
            sigX509Panel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        sigX509Panel.setTokenType(tokenType);
        return sigX509Panel;
    }

    private X509Panel getEncX509Panel(WSDLComponent tokenType) {
        if (this.encX509Panel == null) {
            encX509Panel =  new X509Panel(model, tokenType);
            encX509Panel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        encX509Panel.setTokenType(tokenType);
        return encX509Panel;
    }

    private IssuedPanel getEncIssuedPanel(WSDLComponent tokenType) {
        if (this.encIssuedPanel == null) {
            encIssuedPanel =  new IssuedPanel(model, tokenType);
            encIssuedPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        encIssuedPanel.setTokenType(tokenType);
        return encIssuedPanel;
    }

    private IssuedPanel getSigIssuedPanel(WSDLComponent tokenType) {
        if (this.sigIssuedPanel == null) {
            sigIssuedPanel =  new IssuedPanel(model, tokenType);
            sigIssuedPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        sigIssuedPanel.setTokenType(tokenType);
        return sigIssuedPanel;
    }

    private KerberosPanel getEncKerberosPanel(WSDLComponent tokenType) {
        if (this.encKerberosPanel == null) {
            encKerberosPanel =  new KerberosPanel();
            encKerberosPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
//        encKerberosPanel.setTokenType(tokenType);
        return encKerberosPanel;
    }

    private KerberosPanel getSigKerberosPanel(WSDLComponent tokenType) {
        if (this.sigKerberosPanel == null) {
            sigKerberosPanel =  new KerberosPanel();
            sigKerberosPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
//        sigKerberosPanel.setTokenType(tokenType);
        return sigKerberosPanel;
    }

    private SamlPanel getEncSamlPanel(WSDLComponent tokenType) {
        if (this.encSamlPanel == null) {
            encSamlPanel =  new SamlPanel(model, tokenType);
            encSamlPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        encSamlPanel.setTokenType(tokenType);
        return encSamlPanel;
    }

    private SamlPanel getSigSamlPanel(WSDLComponent tokenType) {
        if (this.sigSamlPanel == null) {
            sigSamlPanel =  new SamlPanel(model, tokenType);
            sigSamlPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        sigSamlPanel.setTokenType(tokenType);
        return sigSamlPanel;
    }

    private RelPanel getEncRelPanel(WSDLComponent tokenType) {
        if (this.encRelPanel == null) {
            encRelPanel =  new RelPanel();
            encRelPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
//        encRelPanel.setTokenType(tokenType);
        return encRelPanel;
    }

    private RelPanel getSigRelPanel(WSDLComponent tokenType) {
        if (this.sigRelPanel == null) {
            sigRelPanel =  new RelPanel();
            sigRelPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
//        sigRelPanel.setTokenType(tokenType);
        return sigRelPanel;
    }
    
    private SecurityContextPanel getSigSecurityContextPanel(WSDLComponent tokenType) {
        if (this.sigSecurityContextPanel == null) {
            sigSecurityContextPanel =  new SecurityContextPanel(model, tokenType);
            sigSecurityContextPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        sigSecurityContextPanel.setTokenType(tokenType);
        return sigSecurityContextPanel;
    }

    private SecurityContextPanel getEncSecurityContextPanel(WSDLComponent tokenType) {
        if (this.encSecurityContextPanel == null) {
            encSecurityContextPanel =  new SecurityContextPanel(model, tokenType);
            encSecurityContextPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        encSecurityContextPanel.setTokenType(tokenType);
        return encSecurityContextPanel;
    }

    private SpnegoContextPanel getSigSpnegoContextPanel(WSDLComponent tokenType) {
        if (this.sigSpnegoContextPanel == null) {
            sigSpnegoContextPanel =  new SpnegoContextPanel();
            sigSpnegoContextPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
//        sigSpnegoContextPanel.setTokenType(tokenType);
        return sigSpnegoContextPanel;
    }

    private SpnegoContextPanel getEncSpnegoContextPanel(WSDLComponent tokenType) {
        if (this.encSpnegoContextPanel == null) {
            encSpnegoContextPanel =  new SpnegoContextPanel();
            encSpnegoContextPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
//        encSpnegoContextPanel.setTokenType(tokenType);
        return encSpnegoContextPanel;
    }
    
    private SecureConversationPanel getSigSecureConversationPanel(WSDLComponent tokenType) {
        if (this.sigSecureConversationPanel == null) {
            sigSecureConversationPanel =  new SecureConversationPanel(model, tokenType);
            sigSecureConversationPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        sigSecureConversationPanel.setTokenType(tokenType);
        return sigSecureConversationPanel;
    }

    private SecureConversationPanel getEncSecureConversationPanel(WSDLComponent tokenType) {
        if (this.encSecureConversationPanel == null) {
            encSecureConversationPanel =  new SecureConversationPanel(model, tokenType);
            encSecureConversationPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        encSecureConversationPanel.setTokenType(tokenType);
        return encSecureConversationPanel;
    }
    
    public void setValue(javax.swing.JComponent source) {
      
        WSDLComponent tokenType = null;
        
        if (!inSync) {
            if (source.equals(sameTokenChBox)) {
                isSameToken = sameTokenChBox.isSelected();
                setValue(signatureTokenCombo);
                setValue(encryptionTokenCombo);
                return;
            }

            if (source.equals(signatureTokenCombo)) {
                if (((String)signatureTokenCombo.getSelectedItem()).equals(USERNAME)) {
                    if (isSameToken) {
                         tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), PROTECTION, USERNAME);
                    } else {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), SIGNATURE, USERNAME);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), INITIATOR, USERNAME);
                        }
                    }
                    this.remove(sigTokenSettingsPanel);
                    sigTokenSettingsPanel = getSigUsernamePanel(tokenType);
                }
                if (((String)signatureTokenCombo.getSelectedItem()).equals(X509)) {
                    if (isSameToken) {
                         tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), PROTECTION, X509);
                    } else {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), SIGNATURE, X509);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), INITIATOR, X509);
                        }
                    }
                    this.remove(sigTokenSettingsPanel);
                    sigTokenSettingsPanel = getSigX509Panel(tokenType);
                }
                if (((String)signatureTokenCombo.getSelectedItem()).equals(ISSUED)) {
                    if (isSameToken) {
                         tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), PROTECTION, ISSUED);
                    } else {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), SIGNATURE, ISSUED);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), INITIATOR, ISSUED);
                        }
                    }
                    this.remove(sigTokenSettingsPanel);
                    sigTokenSettingsPanel = getSigIssuedPanel(tokenType);
                }
                if (((String)signatureTokenCombo.getSelectedItem()).equals(SECURITYCONTEXT)) {
                    if (isSameToken) {
                         tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), PROTECTION, SECURITYCONTEXT);
                    } else {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), SIGNATURE, SECURITYCONTEXT);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), INITIATOR, SECURITYCONTEXT);
                        }
                    }
                    this.remove(sigTokenSettingsPanel);
                    sigTokenSettingsPanel = getSigSecurityContextPanel(tokenType);
                }
                if (((String)signatureTokenCombo.getSelectedItem()).equals(SECURECONVERSATION)) {
                    if (isSameToken) {
                         tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), PROTECTION, SECURECONVERSATION);
                    } else {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), SIGNATURE, SECURECONVERSATION);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), INITIATOR, SECURECONVERSATION);
                        }
                    }
                    this.remove(sigTokenSettingsPanel);
                    sigTokenSettingsPanel = getSigSecureConversationPanel(tokenType);
                }
                if (((String)signatureTokenCombo.getSelectedItem()).equals(KERBEROS)) {
                    if (isSameToken) {
                         tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), PROTECTION, KERBEROS);
                    } else {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), SIGNATURE, KERBEROS);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), INITIATOR, KERBEROS);
                        }
                    }
                    this.remove(sigTokenSettingsPanel);
                    sigTokenSettingsPanel = getSigKerberosPanel(tokenType);
                }
                if (((String)signatureTokenCombo.getSelectedItem()).equals(SAML)) {
                    if (isSameToken) {
                         tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), PROTECTION, SAML);
                    } else {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), SIGNATURE, SAML);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), INITIATOR, SAML);
                        }
                    }
                    this.remove(sigTokenSettingsPanel);
                    sigTokenSettingsPanel = getSigSamlPanel(tokenType);
                }
                if (((String)signatureTokenCombo.getSelectedItem()).equals(REL)) {
                    if (isSameToken) {
                         tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), PROTECTION, REL);
                    } else {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), SIGNATURE, REL);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), INITIATOR, REL);
                        }
                    }
                    this.remove(sigTokenSettingsPanel);
                    sigTokenSettingsPanel = getSigRelPanel(tokenType);
                }
                if (((String)signatureTokenCombo.getSelectedItem()).equals(SPNEGOCONTEXT)) {
                    if (isSameToken) {
                         tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), PROTECTION, SPNEGOCONTEXT);
                    } else {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), SIGNATURE, SPNEGOCONTEXT);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), INITIATOR, SPNEGOCONTEXT);
                        }
                    }
                    this.remove(sigTokenSettingsPanel);
                    sigTokenSettingsPanel = getSigSpnegoContextPanel(tokenType);
                }
//                .setDirty();
                refreshPanels();
                return;
            }
            if (source.equals(encryptionTokenCombo)) {
                if (USERNAME.equals(encryptionTokenCombo.getSelectedItem())) {
                    if (!isSameToken) {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), ENCRYPTION, USERNAME);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), RECIPIENT, USERNAME);
                        }
                    }
                    this.remove(encTokenSettingsPanel);
                    encTokenSettingsPanel = getEncUsernamePanel(tokenType);
                }
                if (X509.equals(encryptionTokenCombo.getSelectedItem())) {
                    if (!isSameToken) {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), ENCRYPTION, X509);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), RECIPIENT, X509);
                        }
                    }
                    this.remove(encTokenSettingsPanel);
                    encTokenSettingsPanel = getEncX509Panel(tokenType);
                }
                if (ISSUED.equals(encryptionTokenCombo.getSelectedItem())) {
                    if (!isSameToken) {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), ENCRYPTION, ISSUED);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), RECIPIENT, ISSUED);
                        }
                    }
                    this.remove(encTokenSettingsPanel);
                    encTokenSettingsPanel = getEncIssuedPanel(tokenType);
                }
                if (SECURITYCONTEXT.equals(encryptionTokenCombo.getSelectedItem())) {
                    if (!isSameToken) {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), ENCRYPTION, SECURITYCONTEXT);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), RECIPIENT, SECURITYCONTEXT);
                        }
                    }
                    this.remove(encTokenSettingsPanel);
                    encTokenSettingsPanel = getEncSecurityContextPanel(tokenType);
                }
                if (SECURECONVERSATION.equals(encryptionTokenCombo.getSelectedItem())) {
                    if (!isSameToken) {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), ENCRYPTION, SECURECONVERSATION);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), RECIPIENT, SECURECONVERSATION);
                        }
                    }
                    this.remove(encTokenSettingsPanel);
                    encTokenSettingsPanel = getEncSecureConversationPanel(tokenType);
                }
                if (KERBEROS.equals(encryptionTokenCombo.getSelectedItem())) {
                    if (!isSameToken) {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), ENCRYPTION, KERBEROS);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), RECIPIENT, KERBEROS);
                        }
                    }
                    this.remove(encTokenSettingsPanel);
                    encTokenSettingsPanel = getEncKerberosPanel(tokenType);
                }
                if (SAML.equals(encryptionTokenCombo.getSelectedItem())) {
                    if (!isSameToken) {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), ENCRYPTION, SAML);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), RECIPIENT, SAML);
                        }
                    }
                    this.remove(encTokenSettingsPanel);
                    encTokenSettingsPanel = getEncSamlPanel(tokenType);
                }
                if (REL.equals(encryptionTokenCombo.getSelectedItem())) {
                    if (!isSameToken) {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), ENCRYPTION, REL);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), RECIPIENT, REL);
                        }
                    }
                    this.remove(encTokenSettingsPanel);
                    encTokenSettingsPanel = getEncRelPanel(tokenType);
                }
                if (SPNEGOCONTEXT.equals(encryptionTokenCombo.getSelectedItem())) {
                    if (!isSameToken) {
                        if (symmetric) {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), ENCRYPTION, SPNEGOCONTEXT);
                        } else {
                            tokenType = SecurityTokensModelHelper.setTokenType(getSecBinding(), RECIPIENT, SPNEGOCONTEXT);
                        }
                    }
                    this.remove(encTokenSettingsPanel);
                    encTokenSettingsPanel = getEncSpnegoContextPanel(tokenType);
                }
//                setter.setDirty();
                refreshPanels();
                return;
            }
        }
    }
    
    private void refreshPanels() {
        updateLayout();
        revalidate();
        repaint();
    }
    
    private void updateLayout() {
        GroupLayout layout = (GroupLayout)this.getLayout();
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(encTokenSettingsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(encryptionTokenLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(encryptionTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .add(signatureTokenLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(signatureTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(26, 26, 26)
                        .add(sameTokenChBox))
                    .add(sigTokenSettingsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {encryptionTokenCombo, signatureTokenCombo}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(signatureTokenLabel)
                    .add(sameTokenChBox)
                    .add(signatureTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(sigTokenSettingsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(encryptionTokenLabel)
                    .add(encryptionTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(encTokenSettingsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }
    
    private void enableDisable() {
        if (symmetric) {
            boolean enable = !sameTokenChBox.isSelected();
            encryptionTokenCombo.setEnabled(enable);
            encryptionTokenLabel.setEnabled(enable);
            encTokenSettingsPanel.setEnabled(enable);
            Component[] comps = encTokenSettingsPanel.getComponents();
            for (Component c : comps) {
                if (c != null) {
                    c.setEnabled(enable);
                }
            }
        }
    }

    public WSDLComponent getSecBinding() {
        return secBinding;
    }

    public void setSecBinding(WSDLComponent secBinding) {
        this.secBinding = secBinding;
        sync();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        signatureTokenLabel = new javax.swing.JLabel();
        signatureTokenCombo = new javax.swing.JComboBox();
        sameTokenChBox = new javax.swing.JCheckBox();
        encryptionTokenLabel = new javax.swing.JLabel();
        encryptionTokenCombo = new javax.swing.JComboBox();
        encTokenSettingsPanel = new javax.swing.JPanel();
        sigTokenSettingsPanel = new javax.swing.JPanel();

        signatureTokenLabel.setText("txt");

        signatureTokenCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                signatureTokenComboActionPerformed(evt);
            }
        });

        sameTokenChBox.setText("txt");
        sameTokenChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        sameTokenChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        sameTokenChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sameTokenChBoxActionPerformed(evt);
            }
        });

        encryptionTokenLabel.setText("txt");

        encryptionTokenCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                encryptionTokenComboActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout encTokenSettingsPanelLayout = new org.jdesktop.layout.GroupLayout(encTokenSettingsPanel);
        encTokenSettingsPanel.setLayout(encTokenSettingsPanelLayout);
        encTokenSettingsPanelLayout.setHorizontalGroup(
            encTokenSettingsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 668, Short.MAX_VALUE)
        );
        encTokenSettingsPanelLayout.setVerticalGroup(
            encTokenSettingsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 10, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout sigTokenSettingsPanelLayout = new org.jdesktop.layout.GroupLayout(sigTokenSettingsPanel);
        sigTokenSettingsPanel.setLayout(sigTokenSettingsPanelLayout);
        sigTokenSettingsPanelLayout.setHorizontalGroup(
            sigTokenSettingsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 444, Short.MAX_VALUE)
        );
        sigTokenSettingsPanelLayout.setVerticalGroup(
            sigTokenSettingsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 10, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(encTokenSettingsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(encryptionTokenLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(encryptionTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .add(signatureTokenLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(signatureTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(26, 26, 26)
                        .add(sameTokenChBox))
                    .add(sigTokenSettingsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {encryptionTokenCombo, signatureTokenCombo}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(signatureTokenLabel)
                    .add(sameTokenChBox)
                    .add(signatureTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(sigTokenSettingsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(encryptionTokenLabel)
                    .add(encryptionTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(encTokenSettingsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void sameTokenChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sameTokenChBoxActionPerformed
        enableDisable();
        setValue(sameTokenChBox);        
    }//GEN-LAST:event_sameTokenChBoxActionPerformed

    private void encryptionTokenComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_encryptionTokenComboActionPerformed
        setValue(encryptionTokenCombo);
    }//GEN-LAST:event_encryptionTokenComboActionPerformed

    private void signatureTokenComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_signatureTokenComboActionPerformed
        setValue(signatureTokenCombo);
    }//GEN-LAST:event_signatureTokenComboActionPerformed
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel encTokenSettingsPanel;
    private javax.swing.JComboBox encryptionTokenCombo;
    private javax.swing.JLabel encryptionTokenLabel;
    private javax.swing.JCheckBox sameTokenChBox;
    private javax.swing.JPanel sigTokenSettingsPanel;
    private javax.swing.JComboBox signatureTokenCombo;
    private javax.swing.JLabel signatureTokenLabel;
    // End of variables declaration//GEN-END:variables
    
}
