/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security.symmetric.tokens;

import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.Utilities;
import org.netbeans.modules.websvc.wsitconf.ui.security.SecurityBindingTokensPanel;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.policy.All;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.EncryptionToken;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.EndorsingSupportingTokens;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.InitiatorToken;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RecipientToken;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.SignatureToken;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.SignedEndorsingSupportingTokens;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.SignedSupportingTokens;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.SupportingTokens;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.util.NbBundle;

public class SupportingTokensPanel extends SectionInnerPanel {
    
    private static String NONE = UsernamePanel.NONE;
    private static String USERNAME = TokensSymmetricPanel.USERNAME;
    private static String X509 = TokensSymmetricPanel.X509;
    private static String SAML = TokensSymmetricPanel.SAML;
    private static String REL = TokensSymmetricPanel.REL;
    private static String KERBEROS = TokensSymmetricPanel.KERBEROS;
    private static String SECURITYCONTEXT = TokensSymmetricPanel.SECURITYCONTEXT;
    private static String SECURECONVERSATION = TokensSymmetricPanel.SECURECONVERSATION;
    private static String ISSUED = TokensSymmetricPanel.ISSUED;
    private static String SPNEGOCONTEXT = TokensSymmetricPanel.SPNEGOCONTEXT;

    private static final int SUPPORTING = SecurityTokensModelHelper.SUPPORTING;
    private static final int SIGNED_SUPPORTING = SecurityTokensModelHelper.SIGNED_SUPPORTING;
    private static final int ENDORSING = SecurityTokensModelHelper.ENDORSING;
    private static final int SIGNED_ENDORSING = SecurityTokensModelHelper.SIGNED_ENDORSING;

    private UsernamePanel[] usernamePanel = new UsernamePanel[4];
    private X509Panel[] x509Panel = new X509Panel[4];
    private SecurityContextPanel[] securityContextPanel = new SecurityContextPanel[4];
    private KerberosPanel[] kerberosPanel = new KerberosPanel[4];
    private RelPanel[] relPanel = new RelPanel[4];
    private SamlPanel[] samlPanel = new SamlPanel[4];
    private SpnegoContextPanel[] spnegoContextPanel = new SpnegoContextPanel[4];
    private SecureConversationPanel[] secureConversationPanel = new SecureConversationPanel[4];
    private IssuedPanel[] issuedPanel = new IssuedPanel[4];
    private JPanel nosecurityPanel;

    List<JComboBox> combos = new ArrayList();
    List<JPanel> panels = new ArrayList();
    
    private boolean inSync = false;
    
    private SectionView view;
    private WSDLModel model;
    private Binding binding;
    
    /**
     * Creates new form SupportingTokensPanel
     */
    public SupportingTokensPanel(SectionView view, Binding b) {
        super(view);
        this.view = view;
        this.binding = b;
        this.model = b.getModel();
        
        initComponents();

        suppTokenLabel.setText(NbBundle.getMessage(SupportingTokensPanel.class, "LBL_SupportingTokenLabel"));        //NOI18N
        sigSuppTokenLabel.setText(NbBundle.getMessage(SupportingTokensPanel.class, "LBL_SignedSupportingTokenLabel"));     //NOI18N
        endSuppTokenLabel.setText(NbBundle.getMessage(SupportingTokensPanel.class, "LBL_EndorsingTokenLabel"));     //NOI18N
        sigEndSupTokenLabel.setText(NbBundle.getMessage(SupportingTokensPanel.class, "LBL_SignedEndorsingTokenLabel"));   //NOI18N
        
        Font f = suppTokenLabel.getFont().deriveFont(Font.BOLD);
        suppTokenLabel.setFont(f);
        sigSuppTokenLabel.setFont(f);
        endSuppTokenLabel.setFont(f);
        sigEndSupTokenLabel.setFont(f);
        
        suppTokenLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        sigSuppTokenLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        endSuppTokenLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        sigEndSupTokenLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        
        suppTokenPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        sigSuppTokenPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        endSuppTokenPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        sigEndSuppTokenPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());

        model.addComponentListener(new ComponentListener() {
            public void valueChanged(ComponentEvent evt) {
                sync();
            }
            public void childrenAdded(ComponentEvent evt) {
                sync();
            }
            public void childrenDeleted(ComponentEvent evt) {
                sync();
            }
        });
        
        inSync = true;
        
        combos.add(suppTokenCombo);
        combos.add(sigSuppTokenCombo);
        combos.add(endSuppTokenCombo);
        combos.add(sigEndSuppTokenCombo);

        panels.add(suppTokenPanel);
        panels.add(sigSuppTokenPanel);
        panels.add(endSuppTokenPanel);
        panels.add(sigEndSuppTokenPanel);
        
        for (JComboBox c : combos) {
            addModifier(c);
            c.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
            c.addItem(NONE);
            c.addItem(USERNAME);
            c.addItem(X509);
            c.addItem(SAML);
    //        c.addItem(REL);
    //        c.addItem(KERBEROS);
    //        c.addItem(SECURITYCONTEXT);
            c.addItem(SECURECONVERSATION);
            c.addItem(ISSUED);
    //        c.addItem(SPNEGOCONTEXT);
        }

        inSync = false;
        
        sync();
    }
    
    private void sync() {
        inSync = true;
        
        String[] token = new String[4];

        WSDLComponent[] tokenType = new WSDLComponent[4];
        
        Policy p = Utilities.getPolicyForElement(binding, model);
        SupportingTokens suppTokens = 
                (SupportingTokens) PolicyModelHelper.getTopLevelElement(p, SupportingTokens.class);
        SignedSupportingTokens sigSuppTokens = 
                (SignedSupportingTokens) PolicyModelHelper.getTopLevelElement(p, SignedSupportingTokens.class);
        EndorsingSupportingTokens endSuppTokens = 
                (EndorsingSupportingTokens) PolicyModelHelper.getTopLevelElement(p, EndorsingSupportingTokens.class);
        SignedEndorsingSupportingTokens endSigSuppTokens = 
                (SignedEndorsingSupportingTokens) PolicyModelHelper.getTopLevelElement(p, SignedEndorsingSupportingTokens.class);

        token[SUPPORTING] = SecurityTokensModelHelper.getTokenType(suppTokens); 
        token[SIGNED_SUPPORTING] = SecurityTokensModelHelper.getTokenType(sigSuppTokens); 
        token[ENDORSING] = SecurityTokensModelHelper.getTokenType(endSuppTokens); 
        token[SIGNED_ENDORSING] = SecurityTokensModelHelper.getTokenType(endSigSuppTokens); 

        tokenType[SUPPORTING] = SecurityTokensModelHelper.getTokenTypeElement(suppTokens); 
        tokenType[SIGNED_SUPPORTING] = SecurityTokensModelHelper.getTokenTypeElement(sigSuppTokens); 
        tokenType[ENDORSING] = SecurityTokensModelHelper.getTokenTypeElement(endSuppTokens); 
        tokenType[SIGNED_ENDORSING] = SecurityTokensModelHelper.getTokenTypeElement(endSigSuppTokens); 

        for (int i=0; i<4; i++) {
            setToken(i, token[i], tokenType[i]);
        }

        enableDisable();

        inSync = false;
        
    }

    private void setToken(int tokenKind, String token, WSDLComponent tokenType) {
        
        combos.get(tokenKind).setSelectedItem(token);
        this.remove(panels.get(tokenKind));
        
        if ((NONE.equals(token)) || (token == null)) {
            switch (tokenKind) {
                case SUPPORTING : suppTokenPanel = getNoTokenPanel(); break;
                case SIGNED_SUPPORTING : sigSuppTokenPanel = getNoTokenPanel(); break;
                case ENDORSING : endSuppTokenPanel = getNoTokenPanel(); break;
                case SIGNED_ENDORSING : sigEndSuppTokenPanel = getNoTokenPanel(); break;
            }             
        }
        if (USERNAME.equals(token)) {
            switch (tokenKind) {
                case SUPPORTING : suppTokenPanel = getUsernamePanel(tokenKind, tokenType); break;
                case SIGNED_SUPPORTING : sigSuppTokenPanel = getUsernamePanel(tokenKind, tokenType); break;
                case ENDORSING : endSuppTokenPanel = getUsernamePanel(tokenKind, tokenType); break;
                case SIGNED_ENDORSING : sigEndSuppTokenPanel = getUsernamePanel(tokenKind, tokenType); break;
            }             
        }
        if (X509.equals(token)) {
            switch (tokenKind) {
                case SUPPORTING : suppTokenPanel = getX509Panel(tokenKind, tokenType); break;
                case SIGNED_SUPPORTING : sigSuppTokenPanel = getX509Panel(tokenKind, tokenType); break;
                case ENDORSING : endSuppTokenPanel = getX509Panel(tokenKind, tokenType); break;
                case SIGNED_ENDORSING : sigEndSuppTokenPanel = getX509Panel(tokenKind, tokenType); break;
            }
        }
        if (SAML.equals(token)) {
            switch (tokenKind) {
                case SUPPORTING : suppTokenPanel = getSamlPanel(tokenKind, tokenType); break;
                case SIGNED_SUPPORTING : sigSuppTokenPanel = getSamlPanel(tokenKind, tokenType); break;
                case ENDORSING : endSuppTokenPanel = getSamlPanel(tokenKind, tokenType); break;
                case SIGNED_ENDORSING : sigEndSuppTokenPanel = getSamlPanel(tokenKind, tokenType); break;
            }
        }
        if (REL.equals(token)) {
            switch (tokenKind) {
                case SUPPORTING : suppTokenPanel = getRelPanel(tokenKind, tokenType); break;
                case SIGNED_SUPPORTING : sigSuppTokenPanel = getRelPanel(tokenKind, tokenType); break;
                case ENDORSING : endSuppTokenPanel = getRelPanel(tokenKind, tokenType); break;
                case SIGNED_ENDORSING : sigEndSuppTokenPanel = getRelPanel(tokenKind, tokenType); break;
            }
        }
        if (KERBEROS.equals(token)) {
            switch (tokenKind) {
                case SUPPORTING : suppTokenPanel = getKerberosPanel(tokenKind, tokenType); break;
                case SIGNED_SUPPORTING : sigSuppTokenPanel = getKerberosPanel(tokenKind, tokenType); break;
                case ENDORSING : endSuppTokenPanel = getKerberosPanel(tokenKind, tokenType); break;
                case SIGNED_ENDORSING : sigEndSuppTokenPanel = getKerberosPanel(tokenKind, tokenType); break;
            }
        }
        if (SECURITYCONTEXT.equals(token)) {
            switch (tokenKind) {
                case SUPPORTING : suppTokenPanel = getSecurityContextPanel(tokenKind, tokenType); break;
                case SIGNED_SUPPORTING : sigSuppTokenPanel = getSecurityContextPanel(tokenKind, tokenType); break;
                case ENDORSING : endSuppTokenPanel = getSecurityContextPanel(tokenKind, tokenType); break;
                case SIGNED_ENDORSING : sigEndSuppTokenPanel = getSecurityContextPanel(tokenKind, tokenType); break;
            }
        }
        if (SECURECONVERSATION.equals(token)) {
            switch (tokenKind) {
                case SUPPORTING : suppTokenPanel = getSecureConversationPanel(tokenKind, tokenType); break;
                case SIGNED_SUPPORTING : sigSuppTokenPanel = getSecureConversationPanel(tokenKind, tokenType); break;
                case ENDORSING : endSuppTokenPanel = getSecureConversationPanel(tokenKind, tokenType); break;
                case SIGNED_ENDORSING : sigEndSuppTokenPanel = getSecureConversationPanel(tokenKind, tokenType); break;
            }
        }
        if (SPNEGOCONTEXT.equals(token)) {
            switch (tokenKind) {
                case SUPPORTING : suppTokenPanel = getSpnegoContextPanel(tokenKind, tokenType); break;
                case SIGNED_SUPPORTING : sigSuppTokenPanel = getSpnegoContextPanel(tokenKind, tokenType); break;
                case ENDORSING : endSuppTokenPanel = getSpnegoContextPanel(tokenKind, tokenType); break;
                case SIGNED_ENDORSING : sigEndSuppTokenPanel = getSpnegoContextPanel(tokenKind, tokenType); break;
            }
        }
        if (ISSUED.equals(token)) {
            switch (tokenKind) {
                case SUPPORTING : suppTokenPanel = getIssuedPanel(tokenKind, tokenType); break;
                case SIGNED_SUPPORTING : sigSuppTokenPanel = getIssuedPanel(tokenKind, tokenType); break;
                case ENDORSING : endSuppTokenPanel = getIssuedPanel(tokenKind, tokenType); break;
                case SIGNED_ENDORSING : sigEndSuppTokenPanel = getIssuedPanel(tokenKind, tokenType); break;
            }
        }
        refreshPanels();
        return;
    }

    private JPanel getNoTokenPanel() {
        if (this.nosecurityPanel == null) {
            nosecurityPanel =  new JPanel();
            nosecurityPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        return nosecurityPanel;
    }
    
    private UsernamePanel getUsernamePanel(int tokenKind, WSDLComponent tokenType) {
        if (this.usernamePanel[tokenKind] == null) {
            usernamePanel[tokenKind] = new UsernamePanel(model, tokenType);
            usernamePanel[tokenKind].setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        usernamePanel[tokenKind].setTokenType(tokenType);
        return usernamePanel[tokenKind];
    }

    private X509Panel getX509Panel(int tokenKind, WSDLComponent tokenType) {
        if (this.x509Panel[tokenKind] == null) {
            x509Panel[tokenKind] =  new X509Panel(model, tokenType);
            x509Panel[tokenKind].setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        return x509Panel[tokenKind];
    }

    private IssuedPanel getIssuedPanel(int tokenKind, WSDLComponent tokenType) {
        if (this.issuedPanel[tokenKind] == null) {
            issuedPanel[tokenKind] =  new IssuedPanel(model, tokenType);
            issuedPanel[tokenKind].setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        return issuedPanel[tokenKind];
    }

    private KerberosPanel getKerberosPanel(int tokenKind, WSDLComponent tokenType) {
        if (this.kerberosPanel[tokenKind] == null) {
            kerberosPanel[tokenKind] =  new KerberosPanel();
            kerberosPanel[tokenKind].setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        return kerberosPanel[tokenKind];
    }

    private SamlPanel getSamlPanel(int tokenKind, WSDLComponent tokenType) {
        if (this.samlPanel[tokenKind] == null) {
            samlPanel[tokenKind] =  new SamlPanel(model, tokenType);
            samlPanel[tokenKind].setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        samlPanel[tokenKind].setTokenType(tokenType);
        return samlPanel[tokenKind];
    }

    private RelPanel getRelPanel(int tokenKind, WSDLComponent tokenType) {
        if (this.relPanel[tokenKind] == null) {
            relPanel[tokenKind] =  new RelPanel();
            relPanel[tokenKind].setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        return relPanel[tokenKind];
    }
    
    private SecurityContextPanel getSecurityContextPanel(int tokenKind, WSDLComponent tokenType) {
        if (this.securityContextPanel[tokenKind] == null) {
            securityContextPanel[tokenKind] =  new SecurityContextPanel(model, tokenType);
            securityContextPanel[tokenKind].setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        return securityContextPanel[tokenKind];
    }

    private SpnegoContextPanel getSpnegoContextPanel(int tokenKind, WSDLComponent tokenType) {
        if (this.spnegoContextPanel[tokenKind] == null) {
            spnegoContextPanel[tokenKind] =  new SpnegoContextPanel();
            spnegoContextPanel[tokenKind].setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        return spnegoContextPanel[tokenKind];
    }

    private SecureConversationPanel getSecureConversationPanel(int tokenKind, WSDLComponent tokenType) {
        if (this.secureConversationPanel[tokenKind] == null) {
            secureConversationPanel[tokenKind] =  new SecureConversationPanel(model, tokenType);
            secureConversationPanel[tokenKind].setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        secureConversationPanel[tokenKind].setTokenType(tokenType);
        return secureConversationPanel[tokenKind];
    }

    private void setPanel(int tokenKind, JPanel panel) {
        switch (tokenKind) {
            case SUPPORTING : suppTokenPanel = panel; break;
            case SIGNED_SUPPORTING : sigSuppTokenPanel = panel; break;
            case ENDORSING : endSuppTokenPanel = panel; break;
            case SIGNED_ENDORSING : sigEndSuppTokenPanel = panel; break;
        }
    }

    private JPanel getPanel(int tokenKind) {
        switch (tokenKind) {
            case SUPPORTING : return suppTokenPanel;
            case SIGNED_SUPPORTING : return sigSuppTokenPanel;
            case ENDORSING : return endSuppTokenPanel;
            case SIGNED_ENDORSING : return sigEndSuppTokenPanel;
        }
        return null;
    }
    
    public void setValue(javax.swing.JComponent source, Object value) {
      
        if (!inSync) {
            for (int tokenKind = 0; tokenKind < 4; tokenKind++) {
                if (source.equals(combos.get(tokenKind))) {
                    this.remove(panels.get(tokenKind));
                    
                    Policy p = Utilities.getPolicyForElement((WSDLComponent)binding, model);
                    All all = PolicyModelHelper.getTopLevelAll(p);
                    
                    if (((String)combos.get(tokenKind).getSelectedItem()).equals(NONE)) {
                        SecurityTokensModelHelper.setTopLevelSupportingTokens(all, NONE, tokenKind);
                        setPanel(tokenKind, getNoTokenPanel());
                    }
                    if (((String)combos.get(tokenKind).getSelectedItem()).equals(USERNAME)) {
                        WSDLComponent tokenType = SecurityTokensModelHelper.setTopLevelSupportingTokens(all, USERNAME, tokenKind);
                        setPanel(tokenKind, getUsernamePanel(tokenKind, tokenType));
                    }
                    if (((String)combos.get(tokenKind).getSelectedItem()).equals(X509)) {
                        WSDLComponent tokenType = SecurityTokensModelHelper.setTopLevelSupportingTokens(all, X509, tokenKind);
                        setPanel(tokenKind, getX509Panel(tokenKind, tokenType));
                    }
                    if (((String)combos.get(tokenKind).getSelectedItem()).equals(ISSUED)) {
                        WSDLComponent tokenType = SecurityTokensModelHelper.setTopLevelSupportingTokens(all, ISSUED, tokenKind);
                        setPanel(tokenKind, getIssuedPanel(tokenKind, tokenType));
                    }
                    if (((String)combos.get(tokenKind).getSelectedItem()).equals(SECURECONVERSATION)) {
                        WSDLComponent tokenType = SecurityTokensModelHelper.setTopLevelSupportingTokens(all, SECURECONVERSATION, tokenKind);
                        setPanel(tokenKind, getSecureConversationPanel(tokenKind, tokenType));
                    }
                    if (((String)combos.get(tokenKind).getSelectedItem()).equals(KERBEROS)) {
                        WSDLComponent tokenType = SecurityTokensModelHelper.setTopLevelSupportingTokens(all, KERBEROS, tokenKind);
                        setPanel(tokenKind, getKerberosPanel(tokenKind, tokenType));
                    }
                    if (((String)combos.get(tokenKind).getSelectedItem()).equals(SAML)) {
                        WSDLComponent tokenType = SecurityTokensModelHelper.setTopLevelSupportingTokens(all, SAML, tokenKind);
                        setPanel(tokenKind, getSamlPanel(tokenKind, tokenType));
                    }
                    if (((String)combos.get(tokenKind).getSelectedItem()).equals(REL)) {
                        WSDLComponent tokenType = SecurityTokensModelHelper.setTopLevelSupportingTokens(all, REL, tokenKind);
                        setPanel(tokenKind, getRelPanel(tokenKind, tokenType));
                    }
                    if (((String)combos.get(tokenKind).getSelectedItem()).equals(SPNEGOCONTEXT)) {
                        WSDLComponent tokenType = SecurityTokensModelHelper.setTopLevelSupportingTokens(all, SPNEGOCONTEXT, tokenKind);
                        setPanel(tokenKind, getSpnegoContextPanel(tokenKind, tokenType));
                    }
                }
            }
            refreshPanels();
            return;
        }
    }
    
    private void refreshPanels() {
        updateLayout();
        revalidate();
        repaint();
    }
    
    private void updateLayout() {
        GroupLayout layout = (GroupLayout)this.getLayout();
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .addContainerGap()
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(sigSuppTokenLabel)
                                    .add(suppTokenLabel)))
                            .add(layout.createSequentialGroup()
                                .add(10, 10, 10)
                                .add(sigEndSupTokenLabel))
                            .add(layout.createSequentialGroup()
                                .add(10, 10, 10)
                                .add(endSuppTokenLabel)))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(suppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(sigSuppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(endSuppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(sigEndSuppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, suppTokenPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, endSuppTokenPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, sigSuppTokenPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .add(layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(sigEndSuppTokenPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(10, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {endSuppTokenCombo, sigEndSuppTokenCombo, sigSuppTokenCombo, suppTokenCombo}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(suppTokenLabel)
                    .add(suppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(suppTokenPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(sigSuppTokenLabel)
                    .add(sigSuppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(sigSuppTokenPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(endSuppTokenLabel)
                    .add(endSuppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(endSuppTokenPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(sigEndSupTokenLabel)
                    .add(sigEndSuppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(sigEndSuppTokenPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }

    private void enableDisable() {
        String bindingType = SecurityPolicyModelHelper.getSecurityBindingType(binding, model);
        boolean enable = (bindingType != null) 
                                && (!SecurityBindingTokensPanel.NOSECURITY.equals(bindingType));
        Component[] components = this.getComponents();
        for (Component c : components) {
            c.setEnabled(enable);
        }
    }
    
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
    }

    public void rollbackValue(javax.swing.text.JTextComponent source) {
    }
    
    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public javax.swing.JComponent getErrorComponent(String errorId) {
        return null;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        suppTokenLabel = new javax.swing.JLabel();
        suppTokenCombo = new javax.swing.JComboBox();
        sigSuppTokenLabel = new javax.swing.JLabel();
        sigSuppTokenCombo = new javax.swing.JComboBox();
        sigSuppTokenPanel = new javax.swing.JPanel();
        suppTokenPanel = new javax.swing.JPanel();
        endSuppTokenLabel = new javax.swing.JLabel();
        endSuppTokenCombo = new javax.swing.JComboBox();
        endSuppTokenPanel = new javax.swing.JPanel();
        sigEndSupTokenLabel = new javax.swing.JLabel();
        sigEndSuppTokenCombo = new javax.swing.JComboBox();
        sigEndSuppTokenPanel = new javax.swing.JPanel();

        suppTokenLabel.setText("Supporting Token:");

        suppTokenCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                suppTokenComboActionPerformed(evt);
            }
        });

        sigSuppTokenLabel.setText("Signed supporting Token:");

        sigSuppTokenCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sigSuppTokenComboActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout sigSuppTokenPanelLayout = new org.jdesktop.layout.GroupLayout(sigSuppTokenPanel);
        sigSuppTokenPanel.setLayout(sigSuppTokenPanelLayout);
        sigSuppTokenPanelLayout.setHorizontalGroup(
            sigSuppTokenPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 453, Short.MAX_VALUE)
        );
        sigSuppTokenPanelLayout.setVerticalGroup(
            sigSuppTokenPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 10, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout suppTokenPanelLayout = new org.jdesktop.layout.GroupLayout(suppTokenPanel);
        suppTokenPanel.setLayout(suppTokenPanelLayout);
        suppTokenPanelLayout.setHorizontalGroup(
            suppTokenPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 453, Short.MAX_VALUE)
        );
        suppTokenPanelLayout.setVerticalGroup(
            suppTokenPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 10, Short.MAX_VALUE)
        );

        endSuppTokenLabel.setText("Endorsing Supporting Token:");

        endSuppTokenCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                endSuppTokenComboActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout endSuppTokenPanelLayout = new org.jdesktop.layout.GroupLayout(endSuppTokenPanel);
        endSuppTokenPanel.setLayout(endSuppTokenPanelLayout);
        endSuppTokenPanelLayout.setHorizontalGroup(
            endSuppTokenPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 453, Short.MAX_VALUE)
        );
        endSuppTokenPanelLayout.setVerticalGroup(
            endSuppTokenPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 10, Short.MAX_VALUE)
        );

        sigEndSupTokenLabel.setText("Signed Endorsing Supporting Token:");

        sigEndSuppTokenCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sigEndSuppTokenComboActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout sigEndSuppTokenPanelLayout = new org.jdesktop.layout.GroupLayout(sigEndSuppTokenPanel);
        sigEndSuppTokenPanel.setLayout(sigEndSuppTokenPanelLayout);
        sigEndSuppTokenPanelLayout.setHorizontalGroup(
            sigEndSuppTokenPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 453, Short.MAX_VALUE)
        );
        sigEndSuppTokenPanelLayout.setVerticalGroup(
            sigEndSuppTokenPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 10, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .addContainerGap()
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(sigSuppTokenLabel)
                                    .add(suppTokenLabel)))
                            .add(layout.createSequentialGroup()
                                .add(10, 10, 10)
                                .add(sigEndSupTokenLabel))
                            .add(layout.createSequentialGroup()
                                .add(10, 10, 10)
                                .add(endSuppTokenLabel)))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(suppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(sigSuppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(endSuppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(sigEndSuppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, suppTokenPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, endSuppTokenPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, sigSuppTokenPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .add(layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(sigEndSuppTokenPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(10, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {endSuppTokenCombo, sigEndSuppTokenCombo, sigSuppTokenCombo, suppTokenCombo}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(suppTokenLabel)
                    .add(suppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(suppTokenPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(sigSuppTokenLabel)
                    .add(sigSuppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(sigSuppTokenPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(endSuppTokenLabel)
                    .add(endSuppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(endSuppTokenPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(sigEndSupTokenLabel)
                    .add(sigEndSuppTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(sigEndSuppTokenPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void sigEndSuppTokenComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sigEndSuppTokenComboActionPerformed
        setValue(sigEndSuppTokenCombo, null);
    }//GEN-LAST:event_sigEndSuppTokenComboActionPerformed

    private void endSuppTokenComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_endSuppTokenComboActionPerformed
        setValue(endSuppTokenCombo, null);
    }//GEN-LAST:event_endSuppTokenComboActionPerformed

    private void sigSuppTokenComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sigSuppTokenComboActionPerformed
        setValue(sigSuppTokenCombo, null);
    }//GEN-LAST:event_sigSuppTokenComboActionPerformed

    private void suppTokenComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_suppTokenComboActionPerformed
        setValue(suppTokenCombo, null);
    }//GEN-LAST:event_suppTokenComboActionPerformed
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox endSuppTokenCombo;
    private javax.swing.JLabel endSuppTokenLabel;
    private javax.swing.JPanel endSuppTokenPanel;
    private javax.swing.JLabel sigEndSupTokenLabel;
    private javax.swing.JComboBox sigEndSuppTokenCombo;
    private javax.swing.JPanel sigEndSuppTokenPanel;
    private javax.swing.JComboBox sigSuppTokenCombo;
    private javax.swing.JLabel sigSuppTokenLabel;
    private javax.swing.JPanel sigSuppTokenPanel;
    private javax.swing.JComboBox suppTokenCombo;
    private javax.swing.JLabel suppTokenLabel;
    private javax.swing.JPanel suppTokenPanel;
    // End of variables declaration//GEN-END:variables
    
}
