/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security.symmetric.tokens;

import org.netbeans.modules.websvc.core.wseditor.spi.SaveSetter;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RequireDerivedKeys;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RequireExternalUriReference;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.SC10SecurityContextToken;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.NbBundle;

/**
 *
 * @author  Martin Grebac
 */
public class SecurityContextPanel extends javax.swing.JPanel {
    
    private boolean inSync = false;

    private WSDLComponent tokenType;
    private WSDLModel model;
    
    /**
     * Creates new form SecurityContextPanel
     */
    public SecurityContextPanel(WSDLModel m, WSDLComponent tokenType) {
        super();
        initComponents();
        this.model = m;
        this.tokenType = tokenType;

        inclusionLevelLabel.setText(NbBundle.getMessage(SecurityContextPanel.class, "LBL_InclusionLevel"));
        requireSecurityContextToken.setText(NbBundle.getMessage(SecurityContextPanel.class, "LBL_SC10SecurityContextToken"));
        requireExternalURIReferenceChBox.setText(NbBundle.getMessage(SecurityContextPanel.class, "LBL_RequireExternalURIReference"));
        requireDerivedKeysChBox.setText(NbBundle.getMessage(SecurityContextPanel.class, "LBL_RequireDerivedKeys"));        
        
        inclusionLevelLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        inclusionLevelCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireDerivedKeysChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireExternalURIReferenceChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireSecurityContextToken.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        
        inSync = true;
        inclusionLevelCombo.addItem(UsernamePanel.NONE);
        inclusionLevelCombo.addItem(UsernamePanel.NEVER);
//        inclusionLevelCombo.addItem(UsernamePanel.ONCE);
        inclusionLevelCombo.addItem(UsernamePanel.ALWAYSRECIPIENT);
        inclusionLevelCombo.addItem(UsernamePanel.ALWAYS);
        inSync = false;

        sync();
    }
    
    private void sync() {
        inSync = true;

        setInclusionLevel(SecurityTokensModelHelper.getTokenInclusionLevel(tokenType));
        setRequireDerivedKeys(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireDerivedKeys.class));
        setRequireExternalUri(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireExternalUriReference.class));
        setRequireSecurityContextToken(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, SC10SecurityContextToken.class));

        inSync = false;
    }
    
    public void setValue(javax.swing.JComponent source, Object value) {

        if (source.equals(inclusionLevelCombo) && (!inSync)) {
            SecurityTokensModelHelper.setTokenInclusionLevel(tokenType, (String)inclusionLevelCombo.getSelectedItem());
//            setter.setDirty();
            return;
        }

        if (source.equals(requireDerivedKeysChBox) && (!inSync)) {
            boolean enable = requireDerivedKeysChBox.isSelected();
            if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireDerivedKeys.class) != enable) {
                SecurityPolicyModelHelper.enableRequireDerivedKeys(tokenType, enable);
//                setter.setDirty();
            }
            return;
        }

        if (source.equals(requireSecurityContextToken) && (!inSync)) {
            boolean enable = requireSecurityContextToken.isSelected();
            if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, SC10SecurityContextToken.class) != enable) {
                SecurityPolicyModelHelper.enableRequireSecurityContextToken(tokenType, enable);
//                setter.setDirty();
            }
            return;
        }
        
        if (source.equals(requireExternalURIReferenceChBox) && (!inSync)) {
            boolean enable = requireExternalURIReferenceChBox.isSelected();
            if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireExternalUriReference.class) != enable) {
                SecurityPolicyModelHelper.enableRequireExternalUri(tokenType, enable);
//                setter.setDirty();
            }
            return;
        }   
    }

    private void setInclusionLevel(String item) {
        if (item == null) {
            this.inclusionLevelCombo.setSelectedIndex(0);
        } else {
            inclusionLevelCombo.setSelectedItem(item);
        }
    }

    private void setRequireDerivedKeys(Boolean enable) {
        if (enable == null) {
            this.requireDerivedKeysChBox.setSelected(false);
        } else {
            this.requireDerivedKeysChBox.setSelected(enable);
        }
    }

    private void setRequireExternalUri(Boolean enable) {
        if (enable == null) {
            this.requireExternalURIReferenceChBox.setSelected(false);
        } else {
            this.requireExternalURIReferenceChBox.setSelected(enable);
        }
    }

    private void setRequireSecurityContextToken(Boolean enable) {
        if (enable == null) {
            this.requireSecurityContextToken.setSelected(false);
        } else {
            this.requireSecurityContextToken.setSelected(enable);
        }
    }
    
    public WSDLComponent getTokenType() {
        return tokenType;
    }

    public void setTokenType(WSDLComponent tokenType) {
        this.tokenType = tokenType;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        requireDerivedKeysChBox = new javax.swing.JCheckBox();
        requireExternalURIReferenceChBox = new javax.swing.JCheckBox();
        requireSecurityContextToken = new javax.swing.JCheckBox();
        inclusionLevelLabel = new javax.swing.JLabel();
        inclusionLevelCombo = new javax.swing.JComboBox();

        requireDerivedKeysChBox.setText("txt");
        requireDerivedKeysChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireDerivedKeysChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireDerivedKeysChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireDerivedKeysChBoxActionPerformed(evt);
            }
        });

        requireExternalURIReferenceChBox.setText("txt");
        requireExternalURIReferenceChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireExternalURIReferenceChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireExternalURIReferenceChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireExternalURIReferenceChBoxActionPerformed(evt);
            }
        });

        requireSecurityContextToken.setText("txt");
        requireSecurityContextToken.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireSecurityContextToken.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireSecurityContextToken.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireSecurityContextTokenActionPerformed(evt);
            }
        });

        inclusionLevelLabel.setText("Inclusion level:");

        inclusionLevelCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                inclusionLevelComboActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(inclusionLevelLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(inclusionLevelCombo, 0, 58, Short.MAX_VALUE))
                    .add(requireDerivedKeysChBox)
                    .add(requireExternalURIReferenceChBox)
                    .add(requireSecurityContextToken))
                .add(377, 377, 377))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(inclusionLevelLabel)
                    .add(inclusionLevelCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireDerivedKeysChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireExternalURIReferenceChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireSecurityContextToken)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void requireSecurityContextTokenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireSecurityContextTokenActionPerformed
        setValue(requireSecurityContextToken, null);
    }//GEN-LAST:event_requireSecurityContextTokenActionPerformed

    private void requireExternalURIReferenceChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireExternalURIReferenceChBoxActionPerformed
        setValue(requireExternalURIReferenceChBox, null);
    }//GEN-LAST:event_requireExternalURIReferenceChBoxActionPerformed

    private void requireDerivedKeysChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireDerivedKeysChBoxActionPerformed
        setValue(requireDerivedKeysChBox, null);
    }//GEN-LAST:event_requireDerivedKeysChBoxActionPerformed

    private void inclusionLevelComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_inclusionLevelComboActionPerformed
        setValue(inclusionLevelCombo, null);
    }//GEN-LAST:event_inclusionLevelComboActionPerformed
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox inclusionLevelCombo;
    private javax.swing.JLabel inclusionLevelLabel;
    private javax.swing.JCheckBox requireDerivedKeysChBox;
    private javax.swing.JCheckBox requireExternalURIReferenceChBox;
    private javax.swing.JCheckBox requireSecurityContextToken;
    // End of variables declaration//GEN-END:variables
    
}
