/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security.symmetric.tokens;

import java.util.List;
import org.netbeans.modules.websvc.wsitconf.ui.security.SecurityBindingTokensPanel;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RequireDerivedKeys;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RequireExternalUriReference;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.SC10SecurityContextToken;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.SignedSupportingTokens;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.NbBundle;
import static org.openide.util.NbBundle.*;

/**
 *
 * @author  Martin Grebac
 */
public class SecureConversationPanel extends javax.swing.JPanel {
    
    private boolean inSync = false;

    private WSDLComponent tokenType;
    private WSDLModel model;
    
    /**
     * Creates new form SecureConversationPanel
     */
    public SecureConversationPanel(WSDLModel m, WSDLComponent tokenType) {
        super();
        this.model = m;
        this.tokenType = tokenType;

        initComponents();
       
        inclusionLevelLabel.setText(NbBundle.getMessage(SecureConversationPanel.class, "LBL_InclusionLevel"));  //NOI18N
        requireSecurityContextToken.setText(NbBundle.getMessage(SecureConversationPanel.class, "LBL_SC10SecurityContextToken")); //NOI18N
        requireExternalURIReferenceChBox.setText(NbBundle.getMessage(SecureConversationPanel.class, "LBL_RequireExternalURIReference")); //NOI18N
        requireDerivedKeysChBox.setText(NbBundle.getMessage(SecureConversationPanel.class, "LBL_RequireDerivedKeys"));  //NOI18N
        authTokenLabel.setText(NbBundle.getMessage(SecureConversationPanel.class, "LBL_AuthToken"));    //NOI18N
        protTokenLabel.setText(NbBundle.getMessage(SecureConversationPanel.class, "LBL_ProtToken"));    //NOI18N
        wssVersionLabel.setText(NbBundle.getMessage(SecureConversationPanel.class, "LBL_WssVersion"));  //NOI18N
        secBindingLabel.setText(NbBundle.getMessage(SecureConversationPanel.class, "LBL_SecBinding"));  //NOI18N
        
        authTokenLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        authTokenCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        protTokenLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        protTokenCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        wssVersionLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        wssVersionCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        secBindingLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        secBindingCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        inclusionLevelLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        inclusionLevelCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireDerivedKeysChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireExternalURIReferenceChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireSecurityContextToken.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        
        inSync = true;
        inclusionLevelCombo.addItem(UsernamePanel.NONE);
        inclusionLevelCombo.addItem(UsernamePanel.NEVER);
//        inclusionLevelCombo.addItem(UsernamePanel.ONCE);
        inclusionLevelCombo.addItem(UsernamePanel.ALWAYSRECIPIENT);
        inclusionLevelCombo.addItem(UsernamePanel.ALWAYS);

        protTokenCombo.addItem(TokensSymmetricPanel.X509);
        protTokenCombo.addItem(TokensSymmetricPanel.ISSUED);

        authTokenCombo.addItem(TokensSymmetricPanel.USERNAME);
        authTokenCombo.addItem(TokensSymmetricPanel.X509);
        authTokenCombo.addItem(TokensSymmetricPanel.ISSUED);

        wssVersionCombo.addItem(UsernamePanel.WSS10);
        wssVersionCombo.addItem(UsernamePanel.WSS11);
        
        secBindingCombo.addItem(SecurityBindingTokensPanel.TRANSPORT);
        secBindingCombo.addItem(SecurityBindingTokensPanel.SYMMETRIC);

        inSync = false;
        
        sync();
    }
    
    private void sync() {
        inSync = true;

        String secBindingType = SecurityPolicyModelHelper.getSecurityBindingType(tokenType);
        WSDLComponent secBindingElement = SecurityPolicyModelHelper.getSecurityBindingTypeElement(tokenType);
        setSecurityBinding(secBindingType);
        
        BootstrapPolicy bp = (BootstrapPolicy) SecurityTokensModelHelper.getBootstrapPolicy(tokenType);
        setAuthenticationToken(SecurityTokensModelHelper.getTokenType(bp, SignedSupportingTokens.class));
        
        if (SecurityBindingTokensPanel.SYMMETRIC.equals(secBindingType)) {
            setProtectionToken(SecurityTokensModelHelper.getTokenType(secBindingElement, ProtectionToken.class));
            
            List<Policy> policies = bp.getExtensibilityElements(Policy.class);
            if ((policies != null) && (!policies.isEmpty())) {
                Policy p = policies.get(0);
                setWssVersion(SecurityPolicyModelHelper.isWss11(p));
            }
        }

        setInclusionLevel(SecurityTokensModelHelper.getTokenInclusionLevel(tokenType));
        setRequireDerivedKeys(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireDerivedKeys.class));
        setRequireExternalUri(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireExternalUriReference.class));
        setRequireSecurityContextToken(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, SC10SecurityContextToken.class));

        enableDisable();
        inSync = false;
    }
    
    private void setSecurityBinding(String bindingType) {
        secBindingCombo.setSelectedItem(bindingType);
    }
    
    private void setProtectionToken(String protectionToken) {
        protTokenCombo.setSelectedItem(protectionToken);
    }

    private void setAuthenticationToken(String authToken) {
        authTokenCombo.setSelectedItem(authToken);
    }

    private void setWssVersion(boolean wss11) {
        if (wss11 == false) {
            this.wssVersionCombo.setSelectedItem(UsernamePanel.WSS10);
        } else {
            this.wssVersionCombo.setSelectedItem(UsernamePanel.WSS11);
        }
    }

    public void setValue(javax.swing.JComponent source, Object value) {

        if ((!inSync) && (source.equals(authTokenCombo) || 
            source.equals(protTokenCombo) || 
            source.equals(wssVersionCombo) || 
            source.equals(secBindingCombo))) {
                SecurityTokensModelHelper.setBootstrapPolicy(
                        tokenType, 
                        (String)secBindingCombo.getSelectedItem(),
                        (String)protTokenCombo.getSelectedItem(),
                        (String)authTokenCombo.getSelectedItem(),
                        (String)wssVersionCombo.getSelectedItem()
                        );
                return;
        }
        
        if (source.equals(inclusionLevelCombo) && (!inSync)) {
            SecurityTokensModelHelper.setTokenInclusionLevel(tokenType, (String)inclusionLevelCombo.getSelectedItem());
//            setter.setDirty();
            return;
        }

        if (source.equals(requireDerivedKeysChBox) && (!inSync)) {
            boolean enable = requireDerivedKeysChBox.isSelected();
            if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireDerivedKeys.class) != enable) {
                SecurityPolicyModelHelper.enableRequireDerivedKeys(tokenType, enable);
//                setter.setDirty();
            }
            return;
        }

        if (source.equals(requireSecurityContextToken) && (!inSync)) {
            boolean enable = requireSecurityContextToken.isSelected();
            if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, SC10SecurityContextToken.class) != enable) {
                SecurityPolicyModelHelper.enableRequireSecurityContextToken(tokenType, enable);
//                setter.setDirty();
            }
            return;
        }
        
        if (source.equals(requireExternalURIReferenceChBox) && (!inSync)) {
            boolean enable = requireExternalURIReferenceChBox.isSelected();
            if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireExternalUriReference.class) != enable) {
                SecurityPolicyModelHelper.enableRequireExternalUri(tokenType, enable);
//                setter.setDirty();
            }
            return;
        }   
    }
    
    private void setInclusionLevel(String item) {
        if (item == null) {
            this.inclusionLevelCombo.setSelectedIndex(0);
        } else {
            inclusionLevelCombo.setSelectedItem(item);
        }
    }

    private void setRequireDerivedKeys(Boolean enable) {
        if (enable == null) {
            this.requireDerivedKeysChBox.setSelected(false);
        } else {
            this.requireDerivedKeysChBox.setSelected(enable);
        }
    }

    private void setRequireExternalUri(Boolean enable) {
        if (enable == null) {
            this.requireExternalURIReferenceChBox.setSelected(false);
        } else {
            this.requireExternalURIReferenceChBox.setSelected(enable);
        }
    }

    private void setRequireSecurityContextToken(Boolean enable) {
        if (enable == null) {
            this.requireSecurityContextToken.setSelected(false);
        } else {
            this.requireSecurityContextToken.setSelected(enable);
        }
    }

    private void enableDisable() {
        boolean transport = SecurityBindingTokensPanel.TRANSPORT.equals(secBindingCombo.getSelectedItem());
//        wssVersionCombo.setEnabled(!transport);
        protTokenCombo.setEnabled(!transport);
    }
    
    public WSDLComponent getTokenType() {
        return tokenType;
    }

    public void setTokenType(WSDLComponent tokenType) {
        this.tokenType = tokenType;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        requireDerivedKeysChBox = new javax.swing.JCheckBox();
        requireExternalURIReferenceChBox = new javax.swing.JCheckBox();
        requireSecurityContextToken = new javax.swing.JCheckBox();
        inclusionLevelLabel = new javax.swing.JLabel();
        inclusionLevelCombo = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        wssVersionLabel = new javax.swing.JLabel();
        wssVersionCombo = new javax.swing.JComboBox();
        secBindingLabel = new javax.swing.JLabel();
        secBindingCombo = new javax.swing.JComboBox();
        authTokenLabel = new javax.swing.JLabel();
        protTokenLabel = new javax.swing.JLabel();
        authTokenCombo = new javax.swing.JComboBox();
        protTokenCombo = new javax.swing.JComboBox();

        requireDerivedKeysChBox.setText("txt");
        requireDerivedKeysChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireDerivedKeysChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireDerivedKeysChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireDerivedKeysChBoxActionPerformed(evt);
            }
        });

        requireExternalURIReferenceChBox.setText("txt");
        requireExternalURIReferenceChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireExternalURIReferenceChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireExternalURIReferenceChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireExternalURIReferenceChBoxActionPerformed(evt);
            }
        });

        requireSecurityContextToken.setText("txt");
        requireSecurityContextToken.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireSecurityContextToken.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireSecurityContextToken.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireSecurityContextTokenActionPerformed(evt);
            }
        });

        inclusionLevelLabel.setText("Inclusion level:");

        inclusionLevelCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                inclusionLevelComboActionPerformed(evt);
            }
        });

        jLabel1.setText("Bootstrap configuration:");

        wssVersionLabel.setText("WSS Version:");

        wssVersionCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                wssVersionComboActionPerformed(evt);
            }
        });

        secBindingLabel.setText("Security Binding:");

        secBindingCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                secBindingComboActionPerformed(evt);
            }
        });

        authTokenLabel.setText("Authentication Token:");

        protTokenLabel.setText("Protection Token:");

        authTokenCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                authTokenComboActionPerformed(evt);
            }
        });

        protTokenCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                protTokenComboActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(inclusionLevelLabel)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(inclusionLevelCombo, 0, 87, Short.MAX_VALUE))
                            .add(requireDerivedKeysChBox)
                            .add(requireExternalURIReferenceChBox)
                            .add(requireSecurityContextToken))
                        .add(341, 341, 341))
                    .add(layout.createSequentialGroup()
                        .add(jLabel1)
                        .addContainerGap(386, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(layout.createSequentialGroup()
                                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                        .add(protTokenLabel)
                                        .add(authTokenLabel))
                                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED))
                                .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                                    .add(secBindingLabel)
                                    .add(57, 57, 57)))
                            .add(wssVersionLabel))
                        .add(4, 4, 4)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(wssVersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 80, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(authTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(protTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(secBindingCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addContainerGap(277, Short.MAX_VALUE))))
        );

        layout.linkSize(new java.awt.Component[] {authTokenCombo, protTokenCombo, protTokenLabel, secBindingCombo, wssVersionCombo}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(11, 11, 11)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(inclusionLevelLabel)
                    .add(inclusionLevelCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireDerivedKeysChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireExternalURIReferenceChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireSecurityContextToken)
                .add(23, 23, 23)
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(secBindingLabel)
                    .add(secBindingCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(authTokenLabel)
                    .add(authTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(protTokenLabel)
                    .add(protTokenCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(wssVersionLabel)
                    .add(wssVersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void wssVersionComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wssVersionComboActionPerformed
        setValue(wssVersionCombo, null);
    }//GEN-LAST:event_wssVersionComboActionPerformed

    private void protTokenComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_protTokenComboActionPerformed
        setValue(protTokenCombo, null);
    }//GEN-LAST:event_protTokenComboActionPerformed

    private void authTokenComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_authTokenComboActionPerformed
        setValue(authTokenCombo, null);
    }//GEN-LAST:event_authTokenComboActionPerformed

    private void secBindingComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_secBindingComboActionPerformed
        enableDisable();
        setValue(secBindingCombo, null);
    }//GEN-LAST:event_secBindingComboActionPerformed

    private void requireSecurityContextTokenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireSecurityContextTokenActionPerformed
        setValue(requireSecurityContextToken, null);
    }//GEN-LAST:event_requireSecurityContextTokenActionPerformed

    private void requireExternalURIReferenceChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireExternalURIReferenceChBoxActionPerformed
        setValue(requireExternalURIReferenceChBox, null);
    }//GEN-LAST:event_requireExternalURIReferenceChBoxActionPerformed

    private void requireDerivedKeysChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireDerivedKeysChBoxActionPerformed
        setValue(requireDerivedKeysChBox, null);
    }//GEN-LAST:event_requireDerivedKeysChBoxActionPerformed

    private void inclusionLevelComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_inclusionLevelComboActionPerformed
        setValue(inclusionLevelCombo, null);
    }//GEN-LAST:event_inclusionLevelComboActionPerformed
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox authTokenCombo;
    private javax.swing.JLabel authTokenLabel;
    private javax.swing.JComboBox inclusionLevelCombo;
    private javax.swing.JLabel inclusionLevelLabel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JComboBox protTokenCombo;
    private javax.swing.JLabel protTokenLabel;
    private javax.swing.JCheckBox requireDerivedKeysChBox;
    private javax.swing.JCheckBox requireExternalURIReferenceChBox;
    private javax.swing.JCheckBox requireSecurityContextToken;
    private javax.swing.JComboBox secBindingCombo;
    private javax.swing.JLabel secBindingLabel;
    private javax.swing.JComboBox wssVersionCombo;
    private javax.swing.JLabel wssVersionLabel;
    // End of variables declaration//GEN-END:variables
    
}
