/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security.symmetric.tokens;

import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RequireDerivedKeys;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RequireKeyIdentifierReference;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.NbBundle;

/**
 *
 * @author  Martin Grebac
 */
public class SamlPanel extends javax.swing.JPanel {
    
    public static final String SAML_V1110 = NbBundle.getMessage(SamlPanel.class, "COMBO_SAML_V1110");
    public static final String SAML_V1011 = NbBundle.getMessage(SamlPanel.class, "COMBO_SAML_V1011");
    public static final String SAML_V1111 = NbBundle.getMessage(SamlPanel.class, "COMBO_SAML_V1111");
    public static final String SAML_V2011 = NbBundle.getMessage(SamlPanel.class, "COMBO_SAML_V2011");

    private boolean inSync = false;

    private WSDLComponent tokenType;
    private WSDLModel model;
    
    /**
     * Creates new form SamlPanel
     */
    public SamlPanel(WSDLModel m, WSDLComponent tokenType) {
        super();
        initComponents();
        this.model = m;
        this.tokenType = tokenType;

        inclusionLevelLabel.setText(NbBundle.getMessage(SamlPanel.class, "LBL_InclusionLevel"));
        samlVersionLabel.setText(NbBundle.getMessage(SamlPanel.class, "LBL_Saml_VersionLabel"));
        requireKeyIdentifierChBox.setText(NbBundle.getMessage(SamlPanel.class, "LBL_RequireKeyIdentifier"));
        requireDerivedKeysChBox.setText(NbBundle.getMessage(SamlPanel.class, "LBL_RequireDerivedKeys"));        
        
        inclusionLevelLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        inclusionLevelCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        samlVersionLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        samlVersionCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireKeyIdentifierChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireDerivedKeysChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        
        inSync = true;
        inclusionLevelCombo.addItem(UsernamePanel.NONE);
        inclusionLevelCombo.addItem(UsernamePanel.NEVER);
//        inclusionLevelCombo.addItem(UsernamePanel.ONCE);
        inclusionLevelCombo.addItem(UsernamePanel.ALWAYSRECIPIENT);
        inclusionLevelCombo.addItem(UsernamePanel.ALWAYS);

        samlVersionCombo.addItem(UsernamePanel.NONE);
        samlVersionCombo.addItem(SAML_V1110);
        samlVersionCombo.addItem(SAML_V1011);
//        samlVersionCombo.addItem(SAML_V1111);
//        samlVersionCombo.addItem(SAML_V2011);
        inSync = false;

        sync();
    }
    
    private void sync() {
        inSync = true;

        setInclusionLevel(SecurityTokensModelHelper.getTokenInclusionLevel(tokenType));
        setProfileVersion(SecurityTokensModelHelper.getTokenProfileVersion(tokenType));
        setRequireDerivedKeys(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireDerivedKeys.class));
        setRequireKeyIdentifier(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireKeyIdentifierReference.class));

        inSync = false;
    }
    
    public void setValue(javax.swing.JComponent source, Object value) {

        if (!inSync) {
            if (source.equals(inclusionLevelCombo)) {
                SecurityTokensModelHelper.setTokenInclusionLevel(tokenType, (String)inclusionLevelCombo.getSelectedItem());
//                setter.setDirty();
                return;
            }

            if (source.equals(samlVersionCombo)) {
                SecurityTokensModelHelper.setTokenProfileVersion(tokenType, (String)samlVersionCombo.getSelectedItem());
//                setter.setDirty();
                return;
            }

            if (source.equals(requireDerivedKeysChBox)) {
                boolean enable = requireDerivedKeysChBox.isSelected();
                if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireDerivedKeys.class) != enable) {
                    SecurityPolicyModelHelper.enableRequireDerivedKeys(tokenType, enable);
//                    setter.setDirty();
                }
                return;
            }

            if (source.equals(requireKeyIdentifierChBox)) {
                boolean enable = requireKeyIdentifierChBox.isSelected();
                if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireKeyIdentifierReference.class) != enable) {
                    SecurityPolicyModelHelper.enableRequireKeyIdentifierReference(tokenType, enable);
//                    setter.setDirty();
                }
                return;
            }
        }
    }
    
    private void setInclusionLevel(String item) {
        if (item == null) {
            this.inclusionLevelCombo.setSelectedIndex(0);
        } else {
            inclusionLevelCombo.setSelectedItem(item);
        }
    }

    private void setRequireDerivedKeys(Boolean enable) {
        if (enable == null) {
            this.requireDerivedKeysChBox.setSelected(false);
        } else {
            this.requireDerivedKeysChBox.setSelected(enable);
        }
    }

    private void setRequireKeyIdentifier(Boolean enable) {
        if (enable == null) {
            this.requireKeyIdentifierChBox.setSelected(false);
        } else {
            this.requireKeyIdentifierChBox.setSelected(enable);
        }
    }
    
    private void setProfileVersion(String item) {
        if (item == null) {
            this.samlVersionCombo.setSelectedIndex(0);
        } else {
            samlVersionCombo.setSelectedItem(item);
        }
    }
    
    public WSDLComponent getTokenType() {
        return tokenType;
    }

    public void setTokenType(WSDLComponent tokenType) {
        this.tokenType = tokenType;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        inclusionLevelLabel = new javax.swing.JLabel();
        inclusionLevelCombo = new javax.swing.JComboBox();
        samlVersionLabel = new javax.swing.JLabel();
        samlVersionCombo = new javax.swing.JComboBox();
        requireKeyIdentifierChBox = new javax.swing.JCheckBox();
        requireDerivedKeysChBox = new javax.swing.JCheckBox();

        inclusionLevelLabel.setText("txt");

        inclusionLevelCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                inclusionLevelComboActionPerformed(evt);
            }
        });

        samlVersionLabel.setText("txt");

        samlVersionCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samlVersionComboActionPerformed(evt);
            }
        });

        requireKeyIdentifierChBox.setText("txt");
        requireKeyIdentifierChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireKeyIdentifierChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireKeyIdentifierChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireKeyIdentifierChBoxActionPerformed(evt);
            }
        });

        requireDerivedKeysChBox.setText("txt");
        requireDerivedKeysChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireDerivedKeysChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireDerivedKeysChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireDerivedKeysChBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                        .add(layout.createSequentialGroup()
                            .add(inclusionLevelLabel)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(inclusionLevelCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(layout.createSequentialGroup()
                            .add(samlVersionLabel)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(samlVersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(requireKeyIdentifierChBox)
                    .add(requireDerivedKeysChBox))
                .addContainerGap(331, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {inclusionLevelCombo, samlVersionCombo}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(inclusionLevelLabel)
                    .add(inclusionLevelCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(samlVersionLabel)
                    .add(samlVersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireKeyIdentifierChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireDerivedKeysChBox)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void requireDerivedKeysChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireDerivedKeysChBoxActionPerformed
        setValue(requireDerivedKeysChBox, null);
    }//GEN-LAST:event_requireDerivedKeysChBoxActionPerformed

    private void requireKeyIdentifierChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireKeyIdentifierChBoxActionPerformed
        setValue(requireKeyIdentifierChBox, null);
    }//GEN-LAST:event_requireKeyIdentifierChBoxActionPerformed

    private void samlVersionComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samlVersionComboActionPerformed
        setValue(samlVersionCombo, null);
    }//GEN-LAST:event_samlVersionComboActionPerformed

    private void inclusionLevelComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_inclusionLevelComboActionPerformed
        setValue(inclusionLevelCombo, null);
    }//GEN-LAST:event_inclusionLevelComboActionPerformed
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox inclusionLevelCombo;
    private javax.swing.JLabel inclusionLevelLabel;
    private javax.swing.JCheckBox requireDerivedKeysChBox;
    private javax.swing.JCheckBox requireKeyIdentifierChBox;
    private javax.swing.JComboBox samlVersionCombo;
    private javax.swing.JLabel samlVersionLabel;
    // End of variables declaration//GEN-END:variables
    
}
