/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security.symmetric.tokens;

import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.openide.util.NbBundle;

/**
 *
 * @author  Martin Grebac
 */
public class RelPanel extends javax.swing.JPanel {
    
    private final String NEVER = NbBundle.getMessage(RelPanel.class, "COMBO_Never");
    private final String ONCE = NbBundle.getMessage(RelPanel.class, "COMBO_Once");
    private final String ALWAYSRECIPIENT = NbBundle.getMessage(RelPanel.class, "COMBO_AlwaysToRecipient");
    private final String ALWAYS = NbBundle.getMessage(RelPanel.class, "COMBO_Always");

    private final String REL_V1010 = NbBundle.getMessage(RelPanel.class, "COMBO_REL_V1010");
    private final String REL_V2010 = NbBundle.getMessage(RelPanel.class, "COMBO_REL_V2010");
    private final String REL_V1011 = NbBundle.getMessage(RelPanel.class, "COMBO_REL_V1011");
    private final String REL_V2011 = NbBundle.getMessage(RelPanel.class, "COMBO_REL_V2011");

    /**
     * Creates new form RelPanel
     */
    public RelPanel() {
        super();
        initComponents();
  
        inclusionLevelLabel.setText(NbBundle.getMessage(RelPanel.class, "LBL_InclusionLevel"));
        relVersionLabel.setText(NbBundle.getMessage(RelPanel.class, "LBL_Rel_VersionLabel"));
        requireKeyIdentifierChBox.setText(NbBundle.getMessage(RelPanel.class, "LBL_RequireKeyIdentifier"));
        requireDerivedKeysChBox.setText(NbBundle.getMessage(RelPanel.class, "LBL_RequireDerivedKeys"));        
        
        inclusionLevelLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        inclusionLevelCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        relVersionLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        relVersionCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireKeyIdentifierChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireDerivedKeysChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        
        inclusionLevelCombo.addItem(NEVER);
//        inclusionLevelCombo.addItem(ONCE);
        inclusionLevelCombo.addItem(ALWAYSRECIPIENT);
        inclusionLevelCombo.addItem(ALWAYS);

        relVersionCombo.addItem(REL_V1010);
        relVersionCombo.addItem(REL_V2010);
        relVersionCombo.addItem(REL_V1011);
        relVersionCombo.addItem(REL_V2011);

        sync();
    }
    
    private void sync() {
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        inclusionLevelLabel = new javax.swing.JLabel();
        inclusionLevelCombo = new javax.swing.JComboBox();
        relVersionLabel = new javax.swing.JLabel();
        relVersionCombo = new javax.swing.JComboBox();
        requireKeyIdentifierChBox = new javax.swing.JCheckBox();
        requireDerivedKeysChBox = new javax.swing.JCheckBox();

        inclusionLevelLabel.setText("txt");

        relVersionLabel.setText("txt");

        requireKeyIdentifierChBox.setText("txt");
        requireKeyIdentifierChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireKeyIdentifierChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        requireDerivedKeysChBox.setText("txt");
        requireDerivedKeysChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireDerivedKeysChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                        .add(layout.createSequentialGroup()
                            .add(inclusionLevelLabel)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                            .add(inclusionLevelCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .add(layout.createSequentialGroup()
                            .add(relVersionLabel)
                            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .add(relVersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(requireKeyIdentifierChBox)
                    .add(requireDerivedKeysChBox))
                .addContainerGap(331, Short.MAX_VALUE))
        );

        layout.linkSize(new java.awt.Component[] {inclusionLevelCombo, relVersionCombo}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(inclusionLevelLabel)
                    .add(inclusionLevelCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(relVersionLabel)
                    .add(relVersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireKeyIdentifierChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireDerivedKeysChBox)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox inclusionLevelCombo;
    private javax.swing.JLabel inclusionLevelLabel;
    private javax.swing.JComboBox relVersionCombo;
    private javax.swing.JLabel relVersionLabel;
    private javax.swing.JCheckBox requireDerivedKeysChBox;
    private javax.swing.JCheckBox requireKeyIdentifierChBox;
    // End of variables declaration//GEN-END:variables
    
}
