/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security.symmetric.tokens;

import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RequireExternalReference;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.security.tokens.RequireInternalReference;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.NbBundle;

/**
 *
 * @author  Martin Grebac
 */
public class IssuedPanel extends javax.swing.JPanel {
    
    private boolean inSync = false;

    private WSDLComponent tokenType;
    private WSDLModel model;
    
    /**
     * Creates new form IssuedPanel
     */
    public IssuedPanel(WSDLModel m, WSDLComponent tokenType) {
        super();
        this.model = m;
        this.tokenType = tokenType;

        initComponents();
        
        issuerLabel.setText(NbBundle.getMessage(IssuedPanel.class, "LBL_IssuerLabel"));
        inclusionLevelLabel.setText(NbBundle.getMessage(IssuedPanel.class, "LBL_InclusionLevel"));
        requireExternalReferenceChBox.setText(NbBundle.getMessage(IssuedPanel.class, "LBL_RequireExternalReference"));
        requireInternalReferenceChBox.setText(NbBundle.getMessage(IssuedPanel.class, "LBL_RequireInternalReference"));

        issuerLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        inclusionLevelLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        inclusionLevelCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireExternalReferenceChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireDerivedKeysChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireInternalReferenceChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        
        inSync = true;
        inclusionLevelCombo.addItem(UsernamePanel.NONE);
        inclusionLevelCombo.addItem(UsernamePanel.NEVER);
//        inclusionLevelCombo.addItem(UsernamePanel.ONCE);
        inclusionLevelCombo.addItem(UsernamePanel.ALWAYSRECIPIENT);
        inclusionLevelCombo.addItem(UsernamePanel.ALWAYS);
        inSync = false;

        sync();
    }
    
    private void sync() {
        inSync = true;

        setIssuer(SecurityTokensModelHelper.getTokenIssuer(tokenType));
        setInclusionLevel(SecurityTokensModelHelper.getTokenInclusionLevel(tokenType));
        setRequireExternalReference(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireExternalReference.class));
        setRequireInternalReference(SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireInternalReference.class));

        inSync = false;
    }

    public void setValue(javax.swing.JComponent source, Object value) {

        if (!inSync) {
            if (source.equals(inclusionLevelCombo)) {
                SecurityTokensModelHelper.setTokenInclusionLevel(tokenType, (String)inclusionLevelCombo.getSelectedItem());
//                setter.setDirty();
                return;
            }

            if (source.equals(issuerTextField)) {
                SecurityTokensModelHelper.setTokenIssuer(tokenType, issuerTextField.getText());
//                setter.setDirty();
                return;
            }

            if (source.equals(requireExternalReferenceChBox)) {
                boolean enable = requireExternalReferenceChBox.isSelected();
                if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireExternalReference.class) != enable) {
                    SecurityPolicyModelHelper.enableRequireExternalReference(tokenType, enable);
//                    setter.setDirty();
                }
                return;
            }

            if (source.equals(requireInternalReferenceChBox)) {
                boolean enable = requireInternalReferenceChBox.isSelected();
                if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement) tokenType, RequireInternalReference.class) != enable) {
                    SecurityPolicyModelHelper.enableRequireInternalReference(tokenType, enable);
//                    setter.setDirty();
                }
                return;
            }
        }
    }
    
    private void setInclusionLevel(String item) {
        if (item == null) {
            this.inclusionLevelCombo.setSelectedIndex(0);
        } else {
            inclusionLevelCombo.setSelectedItem(item);
        }
    }

    private void setIssuer(String issuer) {
        if (issuer != null) {
            this.issuerTextField.setText(issuer);
        }
    }

    private void setRequireDerivedKeys(Boolean enable) {
        if (enable == null) {
            this.requireDerivedKeysChBox.setSelected(false);
        } else {
            this.requireDerivedKeysChBox.setSelected(enable);
        }
    }

    private void setRequireExternalReference(Boolean enable) {
        if (enable == null) {
            this.requireExternalReferenceChBox.setSelected(false);
        } else {
            this.requireExternalReferenceChBox.setSelected(enable);
        }
    }
    
    private void setRequireInternalReference(Boolean enable) {
        if (enable == null) {
            this.requireInternalReferenceChBox.setSelected(false);
        } else {
            this.requireInternalReferenceChBox.setSelected(enable);
        }
    }

    public WSDLComponent getTokenType() {
        return tokenType;
    }

    public void setTokenType(WSDLComponent tokenType) {
        this.tokenType = tokenType;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        inclusionLevelLabel = new javax.swing.JLabel();
        inclusionLevelCombo = new javax.swing.JComboBox();
        requireDerivedKeysChBox = new javax.swing.JCheckBox();
        requireExternalReferenceChBox = new javax.swing.JCheckBox();
        requireInternalReferenceChBox = new javax.swing.JCheckBox();
        issuerLabel = new javax.swing.JLabel();
        issuerTextField = new javax.swing.JTextField();

        inclusionLevelLabel.setText("Inclusion level:");

        requireDerivedKeysChBox.setText("Require derived keys");
        requireDerivedKeysChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireDerivedKeysChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        requireExternalReferenceChBox.setText("Require external reference");
        requireExternalReferenceChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireExternalReferenceChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        requireInternalReferenceChBox.setText("Require internal reference");
        requireInternalReferenceChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireInternalReferenceChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        issuerLabel.setText("Issuer URI:");

        issuerTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                issuerTextFieldActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(inclusionLevelLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(inclusionLevelCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .add(issuerLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(issuerTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 299, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(requireDerivedKeysChBox)
                    .add(requireExternalReferenceChBox)
                    .add(requireInternalReferenceChBox))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(inclusionLevelLabel)
                    .add(inclusionLevelCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(issuerLabel)
                    .add(issuerTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireDerivedKeysChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireExternalReferenceChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireInternalReferenceChBox)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void issuerTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_issuerTextFieldActionPerformed
// TODO add your handling code here:
    }//GEN-LAST:event_issuerTextFieldActionPerformed
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox inclusionLevelCombo;
    private javax.swing.JLabel inclusionLevelLabel;
    private javax.swing.JLabel issuerLabel;
    private javax.swing.JTextField issuerTextField;
    private javax.swing.JCheckBox requireDerivedKeysChBox;
    private javax.swing.JCheckBox requireExternalReferenceChBox;
    private javax.swing.JCheckBox requireInternalReferenceChBox;
    // End of variables declaration//GEN-END:variables
    
}
