/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security.listmodels;

import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.util.NbBundle;

public class OutputMessage extends BindingMessage {
    
    private BindingOutput outputMsg;
    private BindingOperation operation;

    public OutputMessage(BindingOutput outputMsg, BindingOperation o) {
        this.setOutputMsg(outputMsg);
        this.setOperation(o);
    }
    
    public String toString() {
        if (getOutputMsg().getName() == null) {
            return getOperation().getName() + "  - " + NbBundle.getMessage(OutputMessage.class, "TXT_OutputMsg"); //NOI18N
        } else {
            return getOperation().getName() + "  - " + getOutputMsg().getName(); //NOI18N
        }
    }

    public BindingOutput getOutputMsg() {
        return outputMsg;
    }

    public void setOutputMsg(BindingOutput outputMsg) {
        this.outputMsg = outputMsg;
    }

    public BindingOperation getOperation() {
        return operation;
    }

    public void setOperation(BindingOperation operation) {
        this.operation = operation;
    }

    public WSDLComponent getComponent() {
        return outputMsg;
    }
    
}