/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security.listmodels;

import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.util.NbBundle;

public class FaultMessage extends BindingMessage {
    
    private BindingFault faultMsg;
    private BindingOperation operation;

    public FaultMessage(BindingFault faultMsg, BindingOperation o) {
        this.setFaultMsg(faultMsg);
        this.setOperation(o);
    }
    
    public String toString() {
        if (getFaultMsg().getName() == null) {
            return getOperation().getName() + "  - " + NbBundle.getMessage(FaultMessage.class, "TXT_FaultMsg"); //NOI18N
        } else {
            return getOperation().getName() + "  - " + getFaultMsg().getName(); //NOI18N
        }
    }

    public BindingFault getFaultMsg() {
        return faultMsg;
    }

    public void setFaultMsg(BindingFault faultMsg) {
        this.faultMsg = faultMsg;
    }

    public BindingOperation getOperation() {
        return operation;
    }

    public void setOperation(BindingOperation operation) {
        this.operation = operation;
    }

    public WSDLComponent getComponent() {
        return faultMsg;
    }
}