/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security.client;

import java.util.Collection;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

import javax.swing.*;
import java.awt.*;
import java.lang.ref.WeakReference;
import java.util.Iterator;

/**
 * @author Martin Grebac
 */
public class WSITSecurityClientTopComponent extends TopComponent {

    static final long serialVersionUID=6021472310161712674L;
    private static WeakReference<WSITSecurityClientTopComponent> component = new WeakReference(null); 
    private JComponent panel;

    private boolean initialized = false;
    private InnerPanelFactory panelFactory = null;

    private JaxWsModel jaxWsModel;
    private WSDLModel  wsdlModel;    
    private Client client;
    private Node node;
    
    public WSITSecurityClientTopComponent(Client client, JaxWsModel jaxWsModel, WSDLModel wsdlModel, Node node) {
        setLayout(new BorderLayout());
        this.jaxWsModel = jaxWsModel;
        this.panel = null;
        this.wsdlModel = wsdlModel;
        this.initialized = false;
        this.client = client;
        this.node = node;
    }
    
    protected String preferredID(){
        return "WSITClientTopComponent";    //NOI18N
    }

    private org.netbeans.modules.xml.wsdl.model.Service getService(String name, WSDLModel m) {
        if ((name != null) && (m != null)) {
            Collection services = m.getDefinitions().getServices();
            if (services != null) {
                Iterator i = services.iterator();
                org.netbeans.modules.xml.wsdl.model.Service s = null;
                while (i.hasNext()) {
                    s = (org.netbeans.modules.xml.wsdl.model.Service)i.next();
                    if ((s != null) && ((name.equals(s.getName())) || (services.size() == 1))) {
                        return s;
                    }
                }
            }
        }    
        return null;
    }
    
    /**
     * #38900 - lazy addition of GUI components
     */
    private void doInitialize() {
        initAccessibility();

        ToolBarDesignEditor tb = new ToolBarDesignEditor();
        panelFactory = new SecurityClientPanelFactory(tb, wsdlModel, node); 
        
        FileObject srcRoot = (FileObject) node.getLookup().lookup(FileObject.class);
        JAXWSClientSupport supp = JAXWSClientSupport.getJaxWsClientSupport(srcRoot);
        
        org.netbeans.modules.xml.wsdl.model.Service s = getService(client.getName(), wsdlModel); //TODO - the client name just won't work!!!
        if (s != null) {
            SecurityClientView mview = new SecurityClientView(panelFactory, wsdlModel, s);
            tb.setContentView(mview);
            add(tb);
        }
        setFocusable(true);
    }

    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_ALWAYS;
    }
    
    private void initAccessibility(){
        getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WSITSecurityClientTopComponent.class, "ACS_Tab_DESC")); // NOI18N
    }
    
    public void requestFocus(){
        super.requestFocus();
        panel.requestFocus();
    }
    
    public boolean requestFocusInWindow(){
        super.requestFocusInWindow();
        return panel.requestFocusInWindow();
    }
    

    /**
     * #38900 - lazy addition of GUI components
     */    
    public void addNotify() {
        if (!initialized) {
            initialized = true;
            doInitialize();
        }
        super.addNotify();
    }
    
    /**
     * Called when <code>TopComponent</code> is about to be shown.
     * Shown here means the component is selected or resides in it own cell
     * in container in its <code>Mode</code>. The container is visible and not minimized.
     * <p><em>Note:</em> component
     * is considered to be shown, even its container window
     * is overlapped by another window.</p>
     * @since 2.18
     *
     * #38900 - lazy addition of GUI components
     *
     */
    protected void componentShowing() {
        if (!initialized) {
            initialized = true;
            doInitialize();
        }
        super.componentShowing();
    }
    
}

