/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.websvc.wsitconf.ui.security.client;

import org.netbeans.modules.websvc.wsitconf.ui.security.nodes.AdvancedConfigurationClientNode;
import org.netbeans.modules.websvc.wsitconf.ui.security.nodes.BindingContainerClientNode;
import org.netbeans.modules.websvc.wsitconf.ui.security.nodes.KeystoreClientNode;
import org.netbeans.modules.websvc.wsitconf.ui.security.nodes.STSClientNode;
import org.netbeans.modules.xml.multiview.SectionNode;
import org.netbeans.modules.xml.multiview.ui.*;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

import java.util.Collection;

/**
 * @author Martin Grebac
 */
public class SecurityClientView extends SectionView {

    static final String KEYSTORE_NODE_ID = "keystore";        //NOI18N
    static final String STS_NODE_ID = "sts";        //NOI18N
    static final String ADVANCEDCONFIG_NODE_ID = "advancedconfig";        //NOI18N

    private SectionNode rootNode = null;
    
    private static final int REFRESH_DELAY = 40;
    
    public static final String ICON_BASE_DD_VALID =
            "org/netbeans/modules/websvc/wsdl/multiview/resources/DDValidIcon"; // NOI18N
        
    private WSDLModel model = null;
    private Service service = null;
    
    SecurityClientView(InnerPanelFactory factory, WSDLModel model, Service s) {
    
        super(factory);
        this.model = model;
        this.service = s;

        //create root node
        Children rootChildren = new Children.Array();
        Node root = new AbstractNode(rootChildren);

        //add service section
        Collection<Binding> bindings = model.getDefinitions().getBindings();
        Node[] bindingNodes = new Node[bindings.size()];
        int si = 0;

        for (Binding binding : bindings) {
            // main node container for a specific binding
            Children bindingChildren = new Children.Array();
            Node bindingNodeContainer = new BindingContainerClientNode(bindingChildren);
            SectionContainer bindingCont = new SectionContainer(this, 
                    bindingNodeContainer, 
                    NbBundle.getMessage(SecurityClientView.class, "LBL_Binding", binding.getName()));


            Node keystoreNode = new KeystoreClientNode(this, binding);
            Node stsNode = new STSClientNode(this, binding);
            Node advancedConfigNode = new AdvancedConfigurationClientNode(this, binding);
            
            Node[] nodes = new Node[] { 
                keystoreNode,
                stsNode,
                advancedConfigNode
            };
            
            bindingChildren.add(nodes);

            SectionPanel keystorePanel = new SectionPanel(this, keystoreNode, 
                    KEYSTORE_NODE_ID + binding.getName());
            SectionPanel stsPanel = new SectionPanel(this, stsNode, 
                    STS_NODE_ID + binding.getName());
            SectionPanel advancedConfigPanel = new SectionPanel(this, advancedConfigNode, 
                    ADVANCEDCONFIG_NODE_ID + binding.getName());
            
            bindingCont.addSection(keystorePanel);
            bindingCont.addSection(stsPanel);
            bindingCont.addSection(advancedConfigPanel);

            addSection(bindingCont, false);
        
            bindingNodes[si++] = bindingNodeContainer;
        }

        rootChildren.add(bindingNodes);
        setRoot(root);
        
    }
    
    private final RequestProcessor.Task refreshTask = RequestProcessor.getDefault().create(new Runnable() {
        public void run() {
            getRootNode().refreshSubtree();
        }
    });

    public void refreshView() {
        rootNode.refreshSubtree();
    }
    
    public void scheduleRefreshView() {
        refreshTask.schedule(REFRESH_DELAY);
    }

    public void dataModelPropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        rootNode.dataModelPropertyChange(source, propertyName, oldValue, newValue);
    }
    
    public SectionNode getRootNode() {
        return rootNode;
    }    
    
}
