/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security.client;

import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/**
 *
 * @author Martin Grebac
 */
public class AdvancedConfigPanelClient extends SectionInnerPanel {

    private WSDLModel model;
    private Node node;
    private Binding binding;
    private boolean inSync = false;

    private static final String DEFAULT_TIMESTAMP_FRESHNESS_LIMIT = "1200000";  //NOI18N
    private static final String DEFAULT_MAXCLOCKSKEW = "1200000";               //NOI18N
    private static final String DEFAULT_LIFETIME = "36000";                     //NOI18N
    
    public AdvancedConfigPanelClient(SectionView view, Node node, Binding binding) {
        super(view);
        this.model = binding.getModel();
        this.node = node;
        this.binding = binding;
        
        initComponents();

        maximumSkewLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        maximumSkewTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        timeFreshnessLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        timeFreshnessTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        lifeTimeLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        lifeTimeTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        renewExpiredChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        requireCancelChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());

        maximumSkewLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_AdvancedConfigPanel_MaxSkewLabel"));
        timeFreshnessLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_AdvancedConfigPanel_MaxTimeFreshness"));
        lifeTimeLabel.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_AdvancedConfigPanel_SCTokenLifeTime"));
        renewExpiredChBox.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_AdvancedConfigPanel_RenewExpired"));
        requireCancelChBox.setText(NbBundle.getMessage(KeystorePanel.class, "LBL_AdvancedConfigPanel_RequireCancel"));
        
        addModifier(maximumSkewTextField);
        addModifier(timeFreshnessTextField);
        addModifier(lifeTimeTextField);
        addModifier(renewExpiredChBox);
        addModifier(requireCancelChBox);

        addValidatee(maximumSkewTextField);
        addValidatee(timeFreshnessTextField);
        addValidatee(lifeTimeTextField);
        
        sync();
    }

    public void sync() {
        inSync = true;

        String maxClockSkew = ProprietarySecurityPolicyModelHelper.getMaxClockSkew(binding, true);
        if (maxClockSkew == null) { // no setup exists yet - set the default
            setMaxClockSkew(DEFAULT_MAXCLOCKSKEW);
            ProprietarySecurityPolicyModelHelper.setMaxClockSkew(binding, DEFAULT_MAXCLOCKSKEW, true);
        } else {
            setMaxClockSkew(maxClockSkew);
        } 

        String timestampFreshness = ProprietarySecurityPolicyModelHelper.getTimestampFreshness(binding, true);
        if (timestampFreshness == null) { // no setup exists yet - set the default
            setTimestampFreshness(DEFAULT_TIMESTAMP_FRESHNESS_LIMIT);
            ProprietarySecurityPolicyModelHelper.setTimestampFreshness(binding, 
                    DEFAULT_TIMESTAMP_FRESHNESS_LIMIT, true);
        } else {
            setTimestampFreshness(timestampFreshness);
        } 

        String lifeTime = ProprietarySecurityPolicyModelHelper.getLifeTime(binding, true);
        if (lifeTime == null) { // no setup exists yet - set the default
            setLifeTime(DEFAULT_LIFETIME);
            ProprietarySecurityPolicyModelHelper.setLifeTime(binding, DEFAULT_LIFETIME, true);
        } else {
            setLifeTime(lifeTime);
        } 

        setRenewExpired(ProprietarySecurityPolicyModelHelper.isRenewExpired(binding));
        setRequireCancel(ProprietarySecurityPolicyModelHelper.isRequireCancel(binding));

        inSync = false;
    }

    private String getMaxClockSkew() {
        return this.maximumSkewTextField.getText();
    }

    private void setMaxClockSkew(String maxClockSkew) {
        this.maximumSkewTextField.setText(maxClockSkew);
    }

    private String getLifeTime() {
        return this.lifeTimeTextField.getText();
    }

    private void setLifeTime(String time) {
        this.lifeTimeTextField.setText(time);
    }
    
    private String getTimestampFreshness() {
        return this.timeFreshnessTextField.getText();
    }

    private void setTimestampFreshness(String timestampFreshness) {
        this.timeFreshnessTextField.setText(timestampFreshness);
    }
    
    private void setRenewExpired(Boolean enable) {
        if (enable == null) {
            this.renewExpiredChBox.setSelected(false);
        } else {
            this.renewExpiredChBox.setSelected(enable);
        }
    }
    
    private void setRequireCancel(Boolean enable) {
        if (enable == null) {
            this.requireCancelChBox.setSelected(false);
        } else {
            this.requireCancelChBox.setSelected(enable);
        }
    }

    public void setValue(javax.swing.JComponent source, Object value) {
        if (!inSync) {
            if (source.equals(maximumSkewTextField)) {
                String maxSkew = getMaxClockSkew();
                if ((maxSkew != null) && (maxSkew.length() == 0)) {
                    ProprietarySecurityPolicyModelHelper.setMaxClockSkew(binding, null, true);
                } else {
                    ProprietarySecurityPolicyModelHelper.setMaxClockSkew(binding, maxSkew, true);
                }
                return;
            }

            if (source.equals(timeFreshnessTextField)) {
                String timestampFreshness = getTimestampFreshness();
                if ((timestampFreshness != null) && (timestampFreshness.length() == 0)) {
                    ProprietarySecurityPolicyModelHelper.setTimestampFreshness(binding, null, true);
                } else {
                    ProprietarySecurityPolicyModelHelper.setTimestampFreshness(binding, timestampFreshness, true);
                }
                return;
            }

            if (source.equals(lifeTimeTextField)) {
                String lifeTime = getLifeTime();
                if ((lifeTime != null) && (lifeTime.length() == 0)) {
                    ProprietarySecurityPolicyModelHelper.setLifeTime(binding, null, true);
                } else {
                    ProprietarySecurityPolicyModelHelper.setLifeTime(binding, lifeTime, true);
                }
                return;
            }

            if (source.equals(renewExpiredChBox)) {
                ProprietarySecurityPolicyModelHelper.setRenewExpired(binding, renewExpiredChBox.isSelected());
                return;
            }

            if (source.equals(requireCancelChBox)) {
                ProprietarySecurityPolicyModelHelper.setRequireCancel(binding, requireCancelChBox.isSelected());
                return;
            }
        }
    }
    
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
    }

    public void rollbackValue(javax.swing.text.JTextComponent source) {
    }
    
    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public javax.swing.JComponent getErrorComponent(String errorId) {
        return null;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        timeFreshnessLabel = new javax.swing.JLabel();
        maximumSkewLabel = new javax.swing.JLabel();
        timeFreshnessTextField = new javax.swing.JTextField();
        maximumSkewTextField = new javax.swing.JTextField();
        lifeTimeLabel = new javax.swing.JLabel();
        lifeTimeTextField = new javax.swing.JTextField();
        renewExpiredChBox = new javax.swing.JCheckBox();
        requireCancelChBox = new javax.swing.JCheckBox();

        timeFreshnessLabel.setText("Timestamp Freshness Limit:");
        timeFreshnessLabel.setToolTipText("The maximum number of seconds the time stamp remains valid.");

        maximumSkewLabel.setText("Maximum Clock Skew:");
        maximumSkewLabel.setToolTipText("The maximum number of seconds the sending clock can deviate from the receiving clock.");

        timeFreshnessTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);

        maximumSkewTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);

        lifeTimeLabel.setText("Secure Conversation Token Life Time:");

        lifeTimeTextField.setHorizontalAlignment(javax.swing.JTextField.RIGHT);

        renewExpiredChBox.setText("Renew  Expired Secure Conversation Token");
        renewExpiredChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        renewExpiredChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        renewExpiredChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                renewExpiredChBoxActionPerformed(evt);
            }
        });

        requireCancelChBox.setText("Require Cancel of Secure Conversation Token");
        requireCancelChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        requireCancelChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        requireCancelChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                requireCancelChBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .addContainerGap()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(timeFreshnessLabel)
                            .add(maximumSkewLabel)
                            .add(lifeTimeLabel))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(timeFreshnessTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 53, Short.MAX_VALUE)
                            .add(maximumSkewTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(lifeTimeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(requireCancelChBox))
                    .add(layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(renewExpiredChBox)))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {lifeTimeTextField, maximumSkewTextField, timeFreshnessTextField}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(timeFreshnessLabel)
                    .add(timeFreshnessTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(maximumSkewLabel)
                    .add(maximumSkewTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lifeTimeLabel)
                    .add(lifeTimeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(renewExpiredChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(requireCancelChBox)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void requireCancelChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_requireCancelChBoxActionPerformed
        setValue(requireCancelChBox, null);
    }//GEN-LAST:event_requireCancelChBoxActionPerformed

    private void renewExpiredChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_renewExpiredChBoxActionPerformed
        setValue(renewExpiredChBox, null);
    }//GEN-LAST:event_renewExpiredChBoxActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lifeTimeLabel;
    private javax.swing.JTextField lifeTimeTextField;
    private javax.swing.JLabel maximumSkewLabel;
    private javax.swing.JTextField maximumSkewTextField;
    private javax.swing.JCheckBox renewExpiredChBox;
    private javax.swing.JCheckBox requireCancelChBox;
    private javax.swing.JLabel timeFreshnessLabel;
    private javax.swing.JTextField timeFreshnessTextField;
    // End of variables declaration//GEN-END:variables
    
}
