/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security;

import java.awt.Component;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.nodes.Node;

import javax.swing.*;

/**
 *
 * @author Martin Grebac
 */
public class WssPanel extends SectionInnerPanel {

    private WSDLModel model;
    private Node node;
    private Binding binding;
    
    private Wss11SettingsPanel wss11SettingsPanel;
    private Wss10SettingsPanel wss10SettingsPanel;

    private boolean inSync = false;
    
    public WssPanel(SectionView view, WSDLModel model, Node node, Binding binding) {
        super(view);
        this.model = model;
        this.node = node;
        this.binding = binding;
        initComponents();

        wssSettingsPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        wssVersionCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        wssVersionLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        addModifier(wssVersionCombo);
        
        model.addComponentListener(new ComponentListener() {
            public void valueChanged(ComponentEvent evt) {
                enableDisable();
            }
            public void childrenAdded(ComponentEvent evt) {
                enableDisable();
            }
            public void childrenDeleted(ComponentEvent evt) {
                enableDisable();
            }
        });
        
        sync();
    }

    private void enableDisable() {
        String bindingType = SecurityPolicyModelHelper.getSecurityBindingType(binding, model);
        boolean enable = (bindingType != null) && (!SecurityBindingTokensPanel.NOSECURITY.equals(bindingType));
        Component[] components = this.getComponents();
        for (Component c : components) {
            c.setEnabled(enable);
        }
    }
    
    private JPanel getWss10SettingsPanel() {
        if (this.wss10SettingsPanel == null) {
            wss10SettingsPanel = new Wss10SettingsPanel(model, node, binding);
            wss10SettingsPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        wss10SettingsPanel.sync();
        return wss10SettingsPanel;
    }
    
    private JPanel getWss11SettingsPanel() {
        if (this.wss11SettingsPanel == null) {
            wss11SettingsPanel = new Wss11SettingsPanel(model, node, binding);
            wss11SettingsPanel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        }
        wss11SettingsPanel.sync();
        return wss11SettingsPanel;
    }

    private void sync() {
        inSync = true;

        enableDisable();

        boolean isWss11 = SecurityPolicyModelHelper.isWss11(binding, model);
        setWss(isWss11);
        
        this.remove(wssSettingsPanel);
        wssSettingsPanel = isWss11 ? getWss11SettingsPanel() : getWss10SettingsPanel();
        updateLayout();
        revalidate();
        repaint();
        inSync = false;
    }
        
    // wss
    private void setWss(boolean wss11) {
        if (wss11 == false) {
            this.wssVersionCombo.setSelectedIndex(0);
        } else {
            this.wssVersionCombo.setSelectedIndex(1);
        }
    }
    
    public void setValue(javax.swing.JComponent source, Object value) {
        if (source.equals(wssVersionCombo)) {
            if (wssVersionCombo.getSelectedIndex() == 0) {
                
                if (!(SecurityPolicyModelHelper.isWss10(binding, model)) && !inSync) {
                    SecurityPolicyModelHelper.disableWss(binding, true);
                    SecurityPolicyModelHelper.enableWss10(binding, model);
                    SecurityPolicyModelHelper.setDefaultTargets(binding, false);
//                    setter.setDirty();
                }
                
                this.remove(wssSettingsPanel);
                wssSettingsPanel = getWss10SettingsPanel();
                updateLayout();
                revalidate();
                repaint();
            }
            if (wssVersionCombo.getSelectedIndex() == 1) {

                if (!(SecurityPolicyModelHelper.isWss11(binding, model)) && !inSync) {
                    SecurityPolicyModelHelper.disableWss(binding, false);
                    SecurityPolicyModelHelper.enableWss11(binding, model);
                    SecurityPolicyModelHelper.setDefaultTargets(binding, true);
//                    setter.setDirty();
                }
                
                this.remove(wssSettingsPanel);
                wssSettingsPanel = getWss11SettingsPanel();
                updateLayout();
                revalidate();
                repaint();
            }
        }
    }

    private void updateLayout() {
        GroupLayout layout = (GroupLayout) this.getLayout();
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(wssVersionLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(wssVersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, wssSettingsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(wssVersionLabel)
                    .add(wssVersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(wssSettingsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }
    
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
    }

    public void rollbackValue(javax.swing.text.JTextComponent source) {
    }
    
    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public javax.swing.JComponent getErrorComponent(String errorId) {
        return null;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        wssSettingsPanel = new javax.swing.JPanel();
        wssVersionCombo = new javax.swing.JComboBox();
        wssVersionLabel = new javax.swing.JLabel();

        org.jdesktop.layout.GroupLayout wssSettingsPanelLayout = new org.jdesktop.layout.GroupLayout(wssSettingsPanel);
        wssSettingsPanel.setLayout(wssSettingsPanelLayout);
        wssSettingsPanelLayout.setHorizontalGroup(
            wssSettingsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 326, Short.MAX_VALUE)
        );
        wssSettingsPanelLayout.setVerticalGroup(
            wssSettingsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 100, Short.MAX_VALUE)
        );

        wssVersionCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "1.0", "1.1" }));
        wssVersionCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                wssVersionComboActionPerformed(evt);
            }
        });

        wssVersionLabel.setText(org.openide.util.NbBundle.getMessage(WssPanel.class, "LBL_WssPanel_WSSVersion"));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(wssVersionLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(wssVersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, wssSettingsPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(wssVersionLabel)
                    .add(wssVersionCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(wssSettingsPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void wssVersionComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_wssVersionComboActionPerformed
        setValue(wssVersionCombo, ""); //NOI18N
    }//GEN-LAST:event_wssVersionComboActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel wssSettingsPanel;
    private javax.swing.JComboBox wssVersionCombo;
    private javax.swing.JLabel wssVersionLabel;
    // End of variables declaration//GEN-END:variables
    
}
