/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security;

import java.awt.Component;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.nodes.Node;

import javax.swing.*;

/**
 *
 * @author Martin Grebac
 */
public class Wss11SettingsPanel extends JPanel {

    private WSDLModel model;
    private Node node;
    private Binding binding;
    
    private boolean inSync = false;
    
    public Wss11SettingsPanel(WSDLModel model, Node node, Binding binding) {
        this.model = model;
        this.node = node;
        this.binding = binding;
        initComponents();

        embeddedTokenChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        keyIdentifierChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        issuerSerialChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        externalUriChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        encryptedKeyChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        thumbprintChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        signatureConfirmationChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        
        model.addComponentListener(new ComponentListener() {
            public void valueChanged(ComponentEvent evt) {
                sync();
            }
            public void childrenAdded(ComponentEvent evt) {
                sync();
            }
            public void childrenDeleted(ComponentEvent evt) {
                sync();
            }
        });
        
        // no support for J1
        embeddedTokenChBox.setEnabled(false);
        externalUriChBox.setEnabled(false);

        sync();
    }

    private void enableDisable() {
        String bindingType = SecurityPolicyModelHelper.getSecurityBindingType(binding, model);
        boolean enable = (bindingType != null) && (!SecurityBindingTokensPanel.NOSECURITY.equals(bindingType));
        Component[] components = this.getComponents();
        for (Component c : components) {
            c.setEnabled(enable);
        }

        // no support for J1
        embeddedTokenChBox.setEnabled(false);
        externalUriChBox.setEnabled(false);
    }
    
    public void sync() {
        inSync = true;
        boolean isEmbeddedToken = SecurityPolicyModelHelper.isMustSupportRefEmbeddedToken(binding, model);
        setEmbeddedToken(isEmbeddedToken);        
        boolean isKeyIdentifier = SecurityPolicyModelHelper.isMustSupportRefKeyIdentifier(binding, model);
        setKeyIdentifier(isKeyIdentifier);        
        boolean isIssuerSerial = SecurityPolicyModelHelper.isMustSupportRefIssuerSerial(binding, model);
        setIssuerSerial(isIssuerSerial);        
        boolean isExternalURI = SecurityPolicyModelHelper.isMustSupportRefExternalURI(binding, model);
        setExternalURI(isExternalURI);
        boolean isEncryptedKey = SecurityPolicyModelHelper.isMustSupportRefEncryptedKey(binding, model);
        setEncryptedKey(isEncryptedKey);
        boolean isThumbprint = SecurityPolicyModelHelper.isMustSupportRefThumbprint(binding, model);
        setThumbprint(isThumbprint);
        boolean isSignatureConfirmation = SecurityPolicyModelHelper.isRequireSignatureConfirmation(binding, model);
        setSignatureConfirmation(isSignatureConfirmation);

        enableDisable();

        inSync = false;
    }

    private void setEmbeddedToken(boolean enable) {
        embeddedTokenChBox.setSelected(enable);
    }

    private void setKeyIdentifier(boolean enable) {
        keyIdentifierChBox.setSelected(enable);
    }

    private void setIssuerSerial(boolean enable) {
        issuerSerialChBox.setSelected(enable);
    }
    
    private void setExternalURI(boolean enable) {
        externalUriChBox.setSelected(enable);
    }

    private void setEncryptedKey(boolean enable) {
        encryptedKeyChBox.setSelected(enable);
    }

    private void setThumbprint(boolean enable) {
        thumbprintChBox.setSelected(enable);
    }

    private void setSignatureConfirmation(boolean enable) {
        signatureConfirmationChBox.setSelected(enable);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        keyIdentifierChBox = new javax.swing.JCheckBox();
        issuerSerialChBox = new javax.swing.JCheckBox();
        externalUriChBox = new javax.swing.JCheckBox();
        embeddedTokenChBox = new javax.swing.JCheckBox();
        thumbprintChBox = new javax.swing.JCheckBox();
        encryptedKeyChBox = new javax.swing.JCheckBox();
        signatureConfirmationChBox = new javax.swing.JCheckBox();

        keyIdentifierChBox.setText(org.openide.util.NbBundle.getMessage(Wss11SettingsPanel.class, "LBL_Wss11Settings_KeyIdentifier"));
        keyIdentifierChBox.setToolTipText(org.openide.util.NbBundle.getMessage(Wss11SettingsPanel.class, "LBL_Wss11Settings_KeyIdentifier_Tooltip"));
        keyIdentifierChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        keyIdentifierChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        keyIdentifierChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                keyIdentifierChBoxActionPerformed(evt);
            }
        });

        issuerSerialChBox.setText(org.openide.util.NbBundle.getMessage(Wss11SettingsPanel.class, "LBL_Wss11Settings_IssuerSerial"));
        issuerSerialChBox.setToolTipText(org.openide.util.NbBundle.getMessage(Wss11SettingsPanel.class, "LBL_Wss11Settings_IssuerSerial_Tooltip"));
        issuerSerialChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        issuerSerialChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        issuerSerialChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                issuerSerialChBoxActionPerformed(evt);
            }
        });

        externalUriChBox.setText(org.openide.util.NbBundle.getMessage(Wss11SettingsPanel.class, "LBL_Wss11Settings_ExternalURI"));
        externalUriChBox.setToolTipText(org.openide.util.NbBundle.getMessage(Wss11SettingsPanel.class, "LBL_Wss11Settings_ExternalURI_Tooltip"));
        externalUriChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        externalUriChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        externalUriChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                externalUriChBoxActionPerformed(evt);
            }
        });

        embeddedTokenChBox.setText(org.openide.util.NbBundle.getMessage(Wss11SettingsPanel.class, "LBL_Wss11Settings_EmbeddedToken"));
        embeddedTokenChBox.setToolTipText(org.openide.util.NbBundle.getMessage(Wss11SettingsPanel.class, "LBL_Wss11Settings_EmbeddedToken_Tooltip"));
        embeddedTokenChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        embeddedTokenChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        embeddedTokenChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                embeddedTokenChBoxActionPerformed(evt);
            }
        });

        thumbprintChBox.setText(org.openide.util.NbBundle.getMessage(Wss11SettingsPanel.class, "LBL_Wss11Settings_Thumbprint"));
        thumbprintChBox.setToolTipText(org.openide.util.NbBundle.getMessage(Wss11SettingsPanel.class, "LBL_Wss11Settings_Thumbprint_Tooltip"));
        thumbprintChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        thumbprintChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        thumbprintChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                thumbprintChBoxActionPerformed(evt);
            }
        });

        encryptedKeyChBox.setText(org.openide.util.NbBundle.getMessage(Wss11SettingsPanel.class, "LBL_Wss11Settings_EncryptedKey"));
        encryptedKeyChBox.setToolTipText(org.openide.util.NbBundle.getMessage(Wss11SettingsPanel.class, "LBL_Wss11Settings_EncryptedKey_Tooltip"));
        encryptedKeyChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        encryptedKeyChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        encryptedKeyChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                encryptedKeyChBoxActionPerformed(evt);
            }
        });

        signatureConfirmationChBox.setText(org.openide.util.NbBundle.getMessage(Wss11SettingsPanel.class, "LBL_Wss11Settings_RequireSignatureConfirmation"));
        signatureConfirmationChBox.setToolTipText(org.openide.util.NbBundle.getMessage(Wss11SettingsPanel.class, "LBL_Wss11Settings_RequireSignatureConfirmation_Tooltip"));
        signatureConfirmationChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        signatureConfirmationChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        signatureConfirmationChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                signatureConfirmationChBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(keyIdentifierChBox)
                    .add(issuerSerialChBox)
                    .add(externalUriChBox)
                    .add(embeddedTokenChBox))
                .add(47, 47, 47)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(thumbprintChBox)
                    .add(encryptedKeyChBox)
                    .add(signatureConfirmationChBox))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(thumbprintChBox)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(encryptedKeyChBox))
                    .add(layout.createSequentialGroup()
                        .add(keyIdentifierChBox)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(issuerSerialChBox)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(externalUriChBox)
                            .add(signatureConfirmationChBox))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(embeddedTokenChBox)))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void signatureConfirmationChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_signatureConfirmationChBoxActionPerformed
        if (!inSync) {
            boolean chBoxEnabled = signatureConfirmationChBox.isSelected();
            boolean modelEnabled = SecurityPolicyModelHelper.isRequireSignatureConfirmation(binding, model);
            if ((chBoxEnabled) && !(modelEnabled)) {
                SecurityPolicyModelHelper.enableRequireSignatureConfirmation(binding, model, true);
//                setter.setDirty();
                return;
            } 
            if ((!chBoxEnabled) && (modelEnabled)) {
                SecurityPolicyModelHelper.enableRequireSignatureConfirmation(binding, model, false);
//                setter.setDirty();
                return;
            }
        }
    }//GEN-LAST:event_signatureConfirmationChBoxActionPerformed

    private void encryptedKeyChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_encryptedKeyChBoxActionPerformed
        if (!inSync) {
            boolean chBoxEnabled = encryptedKeyChBox.isSelected();
            boolean modelEnabled = SecurityPolicyModelHelper.isMustSupportRefEncryptedKey(binding, model);
            if ((chBoxEnabled) && !(modelEnabled)) {
                SecurityPolicyModelHelper.enableMustSupportRefEncryptedKey(binding, model, true);
//                setter.setDirty();
                return;
            } 
            if ((!chBoxEnabled) && (modelEnabled)) {
                SecurityPolicyModelHelper.enableMustSupportRefEncryptedKey(binding, model, false);
//                setter.setDirty();
                return;
            }
        }
    }//GEN-LAST:event_encryptedKeyChBoxActionPerformed

    private void thumbprintChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_thumbprintChBoxActionPerformed
        if (!inSync) {
            boolean chBoxEnabled = thumbprintChBox.isSelected();
            boolean modelEnabled = SecurityPolicyModelHelper.isMustSupportRefThumbprint(binding, model);
            if ((chBoxEnabled) && !(modelEnabled)) {
                SecurityPolicyModelHelper.enableMustSupportRefThumbprint(binding, model, true);
//                setter.setDirty();
                return;
            } 
            if ((!chBoxEnabled) && (modelEnabled)) {
                SecurityPolicyModelHelper.enableMustSupportRefThumbprint(binding, model, false);
//                setter.setDirty();
                return;
            }
        }
    }//GEN-LAST:event_thumbprintChBoxActionPerformed

    private void externalUriChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_externalUriChBoxActionPerformed
        if (!inSync) {
            boolean chBoxEnabled = externalUriChBox.isSelected();
            boolean modelEnabled = SecurityPolicyModelHelper.isMustSupportRefExternalURI(binding, model);
            if ((chBoxEnabled) && !(modelEnabled)) {
                SecurityPolicyModelHelper.enableMustSupportRefExternalURI(binding, model, true, true);
//                setter.setDirty();
                return;
            } 
            if ((!chBoxEnabled) && (modelEnabled)) {
                SecurityPolicyModelHelper.enableMustSupportRefExternalURI(binding, model, true, false);
//                setter.setDirty();
                return;
            }
        }
    }//GEN-LAST:event_externalUriChBoxActionPerformed

    private void issuerSerialChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_issuerSerialChBoxActionPerformed
        if (!inSync) {
            boolean chBoxEnabled = issuerSerialChBox.isSelected();
            boolean modelEnabled = SecurityPolicyModelHelper.isMustSupportRefIssuerSerial(binding, model);
            if ((chBoxEnabled) && !(modelEnabled)) {
                SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(binding, model, true, true);
//                setter.setDirty();
                return;
            } 
            if ((!chBoxEnabled) && (modelEnabled)) {
                SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(binding, model, true, false);
//                setter.setDirty();
                return;
            }
        }
    }//GEN-LAST:event_issuerSerialChBoxActionPerformed

    private void keyIdentifierChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_keyIdentifierChBoxActionPerformed
        if (!inSync) {
            boolean chBoxEnabled = keyIdentifierChBox.isSelected();
            boolean modelEnabled = SecurityPolicyModelHelper.isMustSupportRefKeyIdentifier(binding, model);
            if ((chBoxEnabled) && !(modelEnabled)) {
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(binding, model, true, true);
//                setter.setDirty();
                return;
            } 
            if ((!chBoxEnabled) && (modelEnabled)) {
                SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(binding, model, true, false);
//                setter.setDirty();
                return;
            }
        }
    }//GEN-LAST:event_keyIdentifierChBoxActionPerformed

    private void embeddedTokenChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_embeddedTokenChBoxActionPerformed
        if (!inSync) {
            boolean chBoxEnabled = embeddedTokenChBox.isSelected();
            boolean modelEnabled = SecurityPolicyModelHelper.isMustSupportRefEmbeddedToken(binding, model);
            if ((chBoxEnabled) && !(modelEnabled)) {
                SecurityPolicyModelHelper.enableMustSupportRefEmbeddedToken(binding, model, true, true);
//                setter.setDirty();
                return;
            } 
            if ((!chBoxEnabled) && (modelEnabled)) {
                SecurityPolicyModelHelper.enableMustSupportRefEmbeddedToken(binding, model, true, false);
//                setter.setDirty();
                return;
            }
        }
    }//GEN-LAST:event_embeddedTokenChBoxActionPerformed
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox embeddedTokenChBox;
    private javax.swing.JCheckBox encryptedKeyChBox;
    private javax.swing.JCheckBox externalUriChBox;
    private javax.swing.JCheckBox issuerSerialChBox;
    private javax.swing.JCheckBox keyIdentifierChBox;
    private javax.swing.JCheckBox signatureConfirmationChBox;
    private javax.swing.JCheckBox thumbprintChBox;
    // End of variables declaration//GEN-END:variables
    
}
