/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security;

import java.awt.Component;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.nodes.Node;

import javax.swing.*;

/**
 *
 * @author Martin Grebac
 */
public class Wss10SettingsPanel extends JPanel {

    private WSDLModel model;
    private Node node;
    private Binding binding;
    
    boolean inSync = false;
    
    public Wss10SettingsPanel(WSDLModel model, Node node, Binding binding) {
        this.model = model;
        this.node = node;
        this.binding = binding;
        initComponents();

        keyIdentifierChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        issuerSerialChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        externalUriChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        embeddedTokenChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        
        externalUriChBox.setEnabled(false);
        embeddedTokenChBox.setEnabled(false);
        
        model.addComponentListener(new ComponentListener() {
            public void valueChanged(ComponentEvent evt) {
                sync();
            }
            public void childrenAdded(ComponentEvent evt) {
                sync();
            }
            public void childrenDeleted(ComponentEvent evt) {
                sync();
            }
        });
        
        sync();
    }

    private void enableDisable() {
        String bindingType = SecurityPolicyModelHelper.getSecurityBindingType(binding, model);
        boolean enable = (bindingType != null) && (!SecurityBindingTokensPanel.NOSECURITY.equals(bindingType));
        Component[] components = this.getComponents();
        for (Component c : components) {
            c.setEnabled(enable);
        }

        // no support for J1
        externalUriChBox.setEnabled(false);
        embeddedTokenChBox.setEnabled(false);
    }
    
    public void sync() {
        inSync = true;
        
        boolean isWss10 = SecurityPolicyModelHelper.isMustSupportRefEmbeddedToken(binding, model);
        boolean isEmbeddedToken = SecurityPolicyModelHelper.isMustSupportRefEmbeddedToken(binding, model);
        setEmbeddedToken(isEmbeddedToken);        
        boolean isKeyIdentifier = SecurityPolicyModelHelper.isMustSupportRefKeyIdentifier(binding, model);
        setKeyIdentifier(isKeyIdentifier);        
        boolean isIssuerSerial = SecurityPolicyModelHelper.isMustSupportRefIssuerSerial(binding, model);
        setIssuerSerial(isIssuerSerial);        
        boolean isExternalURI = SecurityPolicyModelHelper.isMustSupportRefExternalURI(binding, model);
        setExternalURI(isExternalURI);

        enableDisable();
        
        inSync = false;
    }
        
    private void setEmbeddedToken(boolean enable) {
        embeddedTokenChBox.setSelected(enable);
    }

    private void setKeyIdentifier(boolean enable) {
        keyIdentifierChBox.setSelected(enable);
    }

    private void setIssuerSerial(boolean enable) {
        issuerSerialChBox.setSelected(enable);
    }
    
    private void setExternalURI(boolean enable) {
        externalUriChBox.setSelected(enable);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        keyIdentifierChBox = new javax.swing.JCheckBox();
        issuerSerialChBox = new javax.swing.JCheckBox();
        externalUriChBox = new javax.swing.JCheckBox();
        embeddedTokenChBox = new javax.swing.JCheckBox();

        keyIdentifierChBox.setText(org.openide.util.NbBundle.getMessage(Wss10SettingsPanel.class, "LBL_Wss11Settings_KeyIdentifier"));
        keyIdentifierChBox.setToolTipText(org.openide.util.NbBundle.getMessage(Wss10SettingsPanel.class, "LBL_Wss11Settings_KeyIdentifier_Tooltip"));
        keyIdentifierChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        keyIdentifierChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        keyIdentifierChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                keyIdentifierChBoxActionPerformed(evt);
            }
        });

        issuerSerialChBox.setText(org.openide.util.NbBundle.getMessage(Wss10SettingsPanel.class, "LBL_Wss11Settings_IssuerSerial"));
        issuerSerialChBox.setToolTipText(org.openide.util.NbBundle.getMessage(Wss10SettingsPanel.class, "LBL_Wss11Settings_IssuerSerial_Tooltip"));
        issuerSerialChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        issuerSerialChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        issuerSerialChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                issuerSerialChBoxActionPerformed(evt);
            }
        });

        externalUriChBox.setText(org.openide.util.NbBundle.getMessage(Wss10SettingsPanel.class, "LBL_Wss11Settings_ExternalURI"));
        externalUriChBox.setToolTipText(org.openide.util.NbBundle.getMessage(Wss10SettingsPanel.class, "LBL_Wss11Settings_ExternalURI_Tooltip"));
        externalUriChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        externalUriChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        externalUriChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                externalUriChBoxActionPerformed(evt);
            }
        });

        embeddedTokenChBox.setText(org.openide.util.NbBundle.getMessage(Wss10SettingsPanel.class, "LBL_Wss11Settings_EmbeddedToken"));
        embeddedTokenChBox.setToolTipText(org.openide.util.NbBundle.getMessage(Wss10SettingsPanel.class, "LBL_Wss11Settings_EmbeddedToken_Tooltip"));
        embeddedTokenChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        embeddedTokenChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        embeddedTokenChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                embeddedTokenChBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(keyIdentifierChBox)
                    .add(issuerSerialChBox)
                    .add(externalUriChBox)
                    .add(embeddedTokenChBox))
                .addContainerGap(220, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(keyIdentifierChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(issuerSerialChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(externalUriChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(embeddedTokenChBox)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void embeddedTokenChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_embeddedTokenChBoxActionPerformed
        boolean chBoxEnabled = embeddedTokenChBox.isSelected();
        boolean modelEnabled = SecurityPolicyModelHelper.isMustSupportRefEmbeddedToken(binding, model);
        if ((chBoxEnabled) && !(modelEnabled)) {
            SecurityPolicyModelHelper.enableMustSupportRefEmbeddedToken(binding, model, false, true);
//            setter.setDirty();
            return;
        } 
        if ((!chBoxEnabled) && (modelEnabled)) {
            SecurityPolicyModelHelper.enableMustSupportRefEmbeddedToken(binding, model, false, false);
//            setter.setDirty();
            return;
        }
    }//GEN-LAST:event_embeddedTokenChBoxActionPerformed

    private void externalUriChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_externalUriChBoxActionPerformed
        boolean chBoxEnabled = externalUriChBox.isSelected();
        boolean modelEnabled = SecurityPolicyModelHelper.isMustSupportRefExternalURI(binding, model);
        if ((chBoxEnabled) && !(modelEnabled)) {
            SecurityPolicyModelHelper.enableMustSupportRefExternalURI(binding, model, false, true);
//            setter.setDirty();
            return;
        } 
        if ((!chBoxEnabled) && (modelEnabled)) {
            SecurityPolicyModelHelper.enableMustSupportRefExternalURI(binding, model, false, false);
//            setter.setDirty();
            return;
        }

    }//GEN-LAST:event_externalUriChBoxActionPerformed

    private void issuerSerialChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_issuerSerialChBoxActionPerformed
        boolean chBoxEnabled = issuerSerialChBox.isSelected();
        boolean modelEnabled = SecurityPolicyModelHelper.isMustSupportRefIssuerSerial(binding, model);
        if ((chBoxEnabled) && !(modelEnabled)) {
            SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(binding, model, false, true);
//            setter.setDirty();
            return;
        } 
        if ((!chBoxEnabled) && (modelEnabled)) {
            SecurityPolicyModelHelper.enableMustSupportRefIssuerSerial(binding, model, false, false);
//            setter.setDirty();
            return;
        }

    }//GEN-LAST:event_issuerSerialChBoxActionPerformed

    private void keyIdentifierChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_keyIdentifierChBoxActionPerformed
        boolean chBoxEnabled = keyIdentifierChBox.isSelected();
        boolean modelEnabled = SecurityPolicyModelHelper.isMustSupportRefKeyIdentifier(binding, model);
        if ((chBoxEnabled) && !(modelEnabled)) {
            SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(binding, model, false, true);
//            setter.setDirty();
            return;
        } 
        if ((!chBoxEnabled) && (modelEnabled)) {
            SecurityPolicyModelHelper.enableMustSupportRefKeyIdentifier(binding, model, false, false);
//            setter.setDirty();
            return;
        }
    }//GEN-LAST:event_keyIdentifierChBoxActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox embeddedTokenChBox;
    private javax.swing.JCheckBox externalUriChBox;
    private javax.swing.JCheckBox issuerSerialChBox;
    private javax.swing.JCheckBox keyIdentifierChBox;
    // End of variables declaration//GEN-END:variables
    
}
