/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.websvc.wsitconf.ui.security;

import java.awt.Component;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.nodes.Node;

/**
 *
 * @author Martin Grebac
 */
public class TrustSettingsPanel extends SectionInnerPanel {

    private WSDLModel model;
    private Node node;
    private Binding binding;

    private boolean inSync = false;
    
    public TrustSettingsPanel(SectionView view, WSDLModel model, Node node, Binding binding) {
        super(view);
        this.model = model;
        this.node = node;
        this.binding = binding;
        initComponents();

        clientChallengeChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        serverChallengeChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        clientEntropyChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        serverEntropyChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        issuedTokenChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        
        //no support for J1
        clientChallengeChBox.setEnabled(false);
        serverChallengeChBox.setEnabled(false);

        addModifier(clientChallengeChBox);
        addModifier(serverChallengeChBox);
        addModifier(clientEntropyChBox);
        addModifier(serverEntropyChBox);
        addModifier(issuedTokenChBox);
        
        model.addComponentListener(new ComponentListener() {
            public void valueChanged(ComponentEvent evt) {
                sync();
            }
            public void childrenAdded(ComponentEvent evt) {
                sync();
            }
            public void childrenDeleted(ComponentEvent evt) {
                sync();
            }
        });
        
        sync();
    }

    private void enableDisable() {
        String bindingType = SecurityPolicyModelHelper.getSecurityBindingType(binding, model);
        boolean enable = (bindingType != null) && (!SecurityBindingTokensPanel.NOSECURITY.equals(bindingType));
        Component[] components = this.getComponents();
        for (Component c : components) {
            c.setEnabled(enable);
        }
        //no support for J1
        clientChallengeChBox.setEnabled(false);
        serverChallengeChBox.setEnabled(false);
    }
    
    public void sync() {
        inSync = true;
        enableDisable();
        boolean isClientChallengeChBox = SecurityPolicyModelHelper.isMustSupportClientChallenge(binding, model);
        setClientChallengeChBox(isClientChallengeChBox);
        boolean isServerChallengeChBox = SecurityPolicyModelHelper.isMustSupportServerChallenge(binding, model);
        setServerChallengeChBox(isServerChallengeChBox);
        boolean isClientEntropyChBox = SecurityPolicyModelHelper.isRequireClientEntropy(binding, model);
        setClientEntropyChBox(isClientEntropyChBox);
        boolean isServerEntropyChBox = SecurityPolicyModelHelper.isRequireServerEntropy(binding, model);
        setServerEntropyChBox(isServerEntropyChBox);
        boolean isIssuedTokenChBox = SecurityPolicyModelHelper.isMustSupportIssuedTokens(binding, model);
        setIssuedTokenChBox(isIssuedTokenChBox);
        inSync = false;
    }

    private void setClientChallengeChBox(boolean enable) {
        clientChallengeChBox.setSelected(enable);
    }

    private void setServerChallengeChBox(boolean enable) {
        serverChallengeChBox.setSelected(enable);
    }

    private void setClientEntropyChBox(boolean enable) {
        clientEntropyChBox.setSelected(enable);
    }

    private void setServerEntropyChBox(boolean enable) {
        serverEntropyChBox.setSelected(enable);
    }
    
    private void setIssuedTokenChBox(boolean enable) {
        issuedTokenChBox.setSelected(enable);
    }
    
    public void setValue(javax.swing.JComponent source, Object value) {
        
        if (inSync) return;
        
        if (source.equals(clientChallengeChBox)) {
            if (clientChallengeChBox.isSelected()) {
                if (!(SecurityPolicyModelHelper.isMustSupportClientChallenge(binding, model))) {
                    SecurityPolicyModelHelper.enableMustSupportClientChallenge(binding, model, true);
//                    setter.setDirty();
                }
            } else {
                if ((SecurityPolicyModelHelper.isMustSupportClientChallenge(binding, model))) {
                    SecurityPolicyModelHelper.enableMustSupportClientChallenge(binding, model, false);
//                    setter.setDirty();
                }
            }
            return;
        }

        if (source.equals(serverChallengeChBox)) {
            if (serverChallengeChBox.isSelected()) {
                if (!(SecurityPolicyModelHelper.isMustSupportServerChallenge(binding, model))) {
                    SecurityPolicyModelHelper.enableMustSupportServerChallenge(binding, model, true);
//                    setter.setDirty();
                }
            } else {
                if ((SecurityPolicyModelHelper.isMustSupportServerChallenge(binding, model))) {
                    SecurityPolicyModelHelper.enableMustSupportServerChallenge(binding, model, false);
//                    setter.setDirty();
                }
            }
            return;
        }

        if (source.equals(issuedTokenChBox)) {
            if (issuedTokenChBox.isSelected()) {
                if (!(SecurityPolicyModelHelper.isMustSupportIssuedTokens(binding, model))) {
                    SecurityPolicyModelHelper.enableMustSupportIssuedTokens(binding, model, true);
//                    setter.setDirty();
                }
            } else {
                if ((SecurityPolicyModelHelper.isMustSupportIssuedTokens(binding, model))) {
                    SecurityPolicyModelHelper.enableMustSupportIssuedTokens(binding, model, false);
//                    setter.setDirty();
                }
            }
            return;
        }

        if (source.equals(clientEntropyChBox)) {
            if (clientEntropyChBox.isSelected()) {
                if (!(SecurityPolicyModelHelper.isRequireClientEntropy(binding, model))) {
                    SecurityPolicyModelHelper.enableRequireClientEntropy(binding, model, true);
//                    setter.setDirty();
                }
            } else {
                if ((SecurityPolicyModelHelper.isRequireClientEntropy(binding, model))) {
                    SecurityPolicyModelHelper.enableRequireClientEntropy(binding, model, false);
//                    setter.setDirty();
                }
            }
            return;
        }

        if (source.equals(serverEntropyChBox)) {
            if (serverEntropyChBox.isSelected()) {
                if (!(SecurityPolicyModelHelper.isRequireServerEntropy(binding, model))) {
                    SecurityPolicyModelHelper.enableRequireServerEntropy(binding, model, true);
//                    setter.setDirty();
                }
            } else {
                if ((SecurityPolicyModelHelper.isRequireServerEntropy(binding, model))) {
                    SecurityPolicyModelHelper.enableRequireServerEntropy(binding, model, false);
//                    setter.setDirty();
                }
            }
            return;
        }
        
    }
    
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
    }

    public void rollbackValue(javax.swing.text.JTextComponent source) {
    }
    
    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public javax.swing.JComponent getErrorComponent(String errorId) {
        return null;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        clientChallengeChBox = new javax.swing.JCheckBox();
        serverChallengeChBox = new javax.swing.JCheckBox();
        clientEntropyChBox = new javax.swing.JCheckBox();
        serverEntropyChBox = new javax.swing.JCheckBox();
        issuedTokenChBox = new javax.swing.JCheckBox();

        clientChallengeChBox.setText(org.openide.util.NbBundle.getMessage(TrustSettingsPanel.class, "LBL_TrustSettings_ClientChallenge"));
        clientChallengeChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        clientChallengeChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        clientChallengeChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clientChallengeChBoxActionPerformed(evt);
            }
        });

        serverChallengeChBox.setText(org.openide.util.NbBundle.getMessage(TrustSettingsPanel.class, "LBL_TrustSettings_ServerChallenge"));
        serverChallengeChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        serverChallengeChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        serverChallengeChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                serverChallengeChBoxActionPerformed(evt);
            }
        });

        clientEntropyChBox.setText(org.openide.util.NbBundle.getMessage(TrustSettingsPanel.class, "LBL_TrustSettings_ClientEntropy"));
        clientEntropyChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        clientEntropyChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        clientEntropyChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clientEntropyChBoxActionPerformed(evt);
            }
        });

        serverEntropyChBox.setText(org.openide.util.NbBundle.getMessage(TrustSettingsPanel.class, "LBL_TrustSettings_ServerEntropy"));
        serverEntropyChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        serverEntropyChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        serverEntropyChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                serverEntropyChBoxActionPerformed(evt);
            }
        });

        issuedTokenChBox.setText(org.openide.util.NbBundle.getMessage(TrustSettingsPanel.class, "LBL_TrustSettings_IssuedToken"));
        issuedTokenChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        issuedTokenChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        issuedTokenChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                issuedTokenChBoxActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(clientChallengeChBox)
                    .add(serverChallengeChBox)
                    .add(issuedTokenChBox)
                    .add(layout.createSequentialGroup()
                        .add(clientEntropyChBox)
                        .add(6, 6, 6))
                    .add(serverEntropyChBox))
                .addContainerGap(238, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(clientChallengeChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(serverChallengeChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(issuedTokenChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(clientEntropyChBox)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(serverEntropyChBox)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void issuedTokenChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_issuedTokenChBoxActionPerformed
        setValue(issuedTokenChBox, ""); //NOI18N
    }//GEN-LAST:event_issuedTokenChBoxActionPerformed

    private void serverEntropyChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_serverEntropyChBoxActionPerformed
        setValue(serverEntropyChBox, ""); //NOI18N
    }//GEN-LAST:event_serverEntropyChBoxActionPerformed

    private void clientEntropyChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clientEntropyChBoxActionPerformed
        setValue(clientEntropyChBox, ""); //NOI18N
    }//GEN-LAST:event_clientEntropyChBoxActionPerformed

    private void serverChallengeChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_serverChallengeChBoxActionPerformed
        setValue(serverChallengeChBox, ""); //NOI18N
    }//GEN-LAST:event_serverChallengeChBoxActionPerformed

    private void clientChallengeChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clientChallengeChBoxActionPerformed
        setValue(clientChallengeChBox, ""); //NOI18N
    }//GEN-LAST:event_clientChallengeChBoxActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox clientChallengeChBox;
    private javax.swing.JCheckBox clientEntropyChBox;
    private javax.swing.JCheckBox issuedTokenChBox;
    private javax.swing.JCheckBox serverChallengeChBox;
    private javax.swing.JCheckBox serverEntropyChBox;
    // End of variables declaration//GEN-END:variables
    
}
